/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2RangeAssignmentProto;
import java.util.Objects;

public class K2Node {
    private final String id;
    private final String zone;

    public static K2RangeAssignmentProto.Node toProto(K2Node node) {
        return K2RangeAssignmentProto.Node.newBuilder().setId(node.id()).setZone(node.zone()).build();
    }

    public static K2Node fromProto(K2RangeAssignmentProto.Node nodeId) {
        return new K2Node(nodeId.getId(), nodeId.getZone());
    }

    public K2Node(Integer id) {
        this(id, null);
    }

    public K2Node(String id) {
        this(id, null);
    }

    public K2Node(Integer id, String zone) {
        this(Integer.toString(id), zone);
    }

    public K2Node(String id, String zone) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("K2Node id must be set");
        }
        this.id = id;
        this.zone = zone == null ? "" : zone;
    }

    public String id() {
        return this.id;
    }

    public String zone() {
        return this.zone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        K2Node k2Node = (K2Node)o;
        return Objects.equals(this.id, k2Node.id) && Objects.equals(this.zone, k2Node.zone);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.zone);
    }

    public String toString() {
        return "K2Node{id='" + this.id + '\'' + ", zone='" + this.zone + '\'' + '}';
    }

    public static enum NodeStatus {
        OFFLINE,
        ONLINE;

    }
}

