/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2RequestDeterminationBasedOnContextOnly;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterReplicaLogDirsRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.DeleteRecordsRequestData;
import org.apache.kafka.common.message.DescribeLogDirsRequestData;
import org.apache.kafka.common.message.DescribeProducersRequestData;
import org.apache.kafka.common.message.ElectLeadersRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterReplicaLogDirsRequest;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteRecordsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeProducersRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.RequestFeatureFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K2RequestDeterminationBasedOnRequestDetails
implements RequestFeatureFilter {
    private static final Logger logger = LoggerFactory.getLogger(K2RequestDeterminationBasedOnRequestDetails.class);
    private static final boolean FALSE_TO_ALLOW_RPC_PROCESSING_FOR_INTERNAL_AND_HC_PRINCIPALS = false;
    public static final String HEALTHCHECK_TOPIC_K2_PREFIX = "_k2_";
    private final K2RequestDeterminationBasedOnContextOnly principalDetermination = new K2RequestDeterminationBasedOnContextOnly();
    private final Function<Uuid, Optional<String>> topicIdToNameMapper;
    private final Function<String, Optional<TopicType>> topicNameToTypeMapper;

    public K2RequestDeterminationBasedOnRequestDetails(Function<Uuid, Optional<String>> topicIdToNameMapper, Function<String, Optional<TopicType>> topicNameToTypeMapper) {
        this.topicIdToNameMapper = Objects.requireNonNull(topicIdToNameMapper);
        this.topicNameToTypeMapper = Objects.requireNonNull(topicNameToTypeMapper);
    }

    public boolean appliesTo(AbstractRequest request, RequestContext context, Optional<Supplier<Set<String>>> sessionTopicNames) {
        boolean appliesToPrincipal = this.principalDetermination.appliesTo(request, context, sessionTopicNames);
        if (appliesToPrincipal && !K2RequestDeterminationBasedOnRequestDetails.mixedEntityRequestType(request)) {
            if (logger.isTraceEnabled()) {
                logger.trace(request.getClass().getSimpleName() + " determined to be a K2 request via context: " + context);
            }
            return true;
        }
        ApiKeys apiKey = request.apiKey();
        switch (apiKey) {
            case PRODUCE: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((ProduceRequest)request).data().topicData().stream().map(ProduceRequestData.TopicProduceData::name), apiKey.name);
            }
            case FETCH: {
                if (!sessionTopicNames.isPresent()) {
                    throw new IllegalArgumentException("Must set session topic names for " + request.getClass().getSimpleName());
                }
                return this.appliesToExistingTopicNames(request, context, sessionTopicNames.get().get().stream(), apiKey.name);
            }
            case LIST_OFFSETS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((ListOffsetsRequest)request).data().topics().stream().map(ListOffsetsRequestData.ListOffsetsTopic::name), apiKey.name);
            }
            case METADATA: {
                return true;
            }
            case CREATE_TOPICS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return K2RequestDeterminationBasedOnRequestDetails.appliesToNewTopicNames(request, ((CreateTopicsRequest)request).data().topics().stream().map(CreateTopicsRequestData.CreatableTopic::name), K2RequestDeterminationBasedOnRequestDetails.getRequestTypeForFurtherIntrospection(context), apiKey.name);
            }
            case DELETE_TOPICS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                Stream<Optional<String>> topics = ((DeleteTopicsRequest)request).topics().stream().map(deleteTopicState -> {
                    if (deleteTopicState.name() != null) {
                        return Optional.of(deleteTopicState.name());
                    }
                    return this.topicIdToNameMapper.apply(deleteTopicState.topicId());
                });
                return this.appliesToExistingTopicNames(request, context, K2RequestDeterminationBasedOnRequestDetails.filterPresent(topics), apiKey.name);
            }
            case DELETE_RECORDS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((DeleteRecordsRequest)request).data().topics().stream().map(DeleteRecordsRequestData.DeleteRecordsTopic::name), apiKey.name);
            }
            case ALTER_CONFIGS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                Set alterTopicConfigTopicNames = ((AlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) == ConfigResource.Type.TOPIC).map(AlterConfigsRequestData.AlterConfigsResource::resourceName).collect(Collectors.toSet());
                if (alterTopicConfigTopicNames.isEmpty()) {
                    return false;
                }
                boolean hasK2Topics = this.appliesToExistingTopicNames(request, context, alterTopicConfigTopicNames.stream(), apiKey.name);
                if (!hasK2Topics) {
                    return false;
                }
                Set nonTopicResourceDescriptions = ((AlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) != ConfigResource.Type.TOPIC).map(nonTopicResource -> ConfigResource.Type.forId((byte)nonTopicResource.resourceType()).name().toLowerCase(Locale.ROOT) + ":" + nonTopicResource.resourceName()).collect(Collectors.toSet());
                if (!nonTopicResourceDescriptions.isEmpty()) {
                    throw new InvalidRequestException("Existence of both topic and non-topic entities in the same " + request.apiKey().name + " request is not supported: topics=" + alterTopicConfigTopicNames + "; non-topics=" + nonTopicResourceDescriptions);
                }
                return true;
            }
            case INCREMENTAL_ALTER_CONFIGS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                Set incrementalAlterTopicConfigTopicNames = ((IncrementalAlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) == ConfigResource.Type.TOPIC).map(IncrementalAlterConfigsRequestData.AlterConfigsResource::resourceName).collect(Collectors.toSet());
                if (incrementalAlterTopicConfigTopicNames.isEmpty()) {
                    return false;
                }
                boolean hasK2Topics = this.appliesToExistingTopicNames(request, context, incrementalAlterTopicConfigTopicNames.stream(), apiKey.name);
                if (!hasK2Topics) {
                    return false;
                }
                Set nonTopicResourceDescriptions = ((IncrementalAlterConfigsRequest)request).data().resources().stream().filter(resource -> ConfigResource.Type.forId((byte)resource.resourceType()) != ConfigResource.Type.TOPIC).map(nonTopicResource -> ConfigResource.Type.forId((byte)nonTopicResource.resourceType()).name().toLowerCase(Locale.ROOT) + ":" + nonTopicResource.resourceName()).collect(Collectors.toSet());
                if (!nonTopicResourceDescriptions.isEmpty()) {
                    throw new InvalidRequestException("Existence of both topic and non-topic entities in the same " + request.apiKey().name + " request is not supported: topics=" + incrementalAlterTopicConfigTopicNames + "; non-topics=" + nonTopicResourceDescriptions);
                }
                return true;
            }
            case INIT_PRODUCER_ID: {
                return false;
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((OffsetsForLeaderEpochRequest)request).data().topics().stream().map(OffsetForLeaderEpochRequestData.OffsetForLeaderTopic::topic), apiKey.name);
            }
            case ADD_PARTITIONS_TO_TXN: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((AddPartitionsToTxnRequest)request).data().transactions().stream().map(x -> x.topics().stream().map(AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic::name)).flatMap(UnaryOperator.identity()), apiKey.name);
            }
            case WRITE_TXN_MARKERS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((WriteTxnMarkersRequest)request).data().markers().stream().map(x -> x.topics().stream().map(WriteTxnMarkersRequestData.WritableTxnMarkerTopic::name)).flatMap(UnaryOperator.identity()), apiKey.name);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((AlterReplicaLogDirsRequest)request).data().dirs().stream().map(x -> x.topics().stream().map(AlterReplicaLogDirsRequestData.AlterReplicaLogDirTopic::name)).flatMap(UnaryOperator.identity()), apiKey.name);
            }
            case DESCRIBE_LOG_DIRS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                DescribeLogDirsRequest describeLogDirsRequest = (DescribeLogDirsRequest)request;
                if (describeLogDirsRequest.isAllTopicPartitions()) {
                    return false;
                }
                return this.appliesToExistingTopicNames(request, context, describeLogDirsRequest.data().topics().stream().map(DescribeLogDirsRequestData.DescribableLogDirTopic::topic), apiKey.name);
            }
            case CREATE_PARTITIONS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((CreatePartitionsRequest)request).data().topics().stream().map(CreatePartitionsRequestData.CreatePartitionsTopic::name), apiKey.name);
            }
            case ELECT_LEADERS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, StreamSupport.stream(Spliterators.spliteratorUnknownSize(((ElectLeadersRequest)request).data().topicPartitions().iterator(), 16), false).map(ElectLeadersRequestData.TopicPartitions::topic), apiKey.name);
            }
            case ALTER_PARTITION_REASSIGNMENTS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((AlterPartitionReassignmentsRequest)request).data().topics().stream().map(AlterPartitionReassignmentsRequestData.ReassignableTopic::name), apiKey.name);
            }
            case DESCRIBE_PRODUCERS: {
                K2RequestDeterminationBasedOnRequestDetails.confirmNoTopicNameOverrides(request, sessionTopicNames);
                return this.appliesToExistingTopicNames(request, context, ((DescribeProducersRequest)request).data().topics().stream().map(DescribeProducersRequestData.TopicRequest::name), apiKey.name);
            }
        }
        logger.warn("Request class not covered in " + this.getClass().getSimpleName() + ": " + request.getClass());
        return false;
    }

    private static boolean mixedEntityRequestType(AbstractRequest request) {
        return request instanceof IncrementalAlterConfigsRequest || request instanceof AlterConfigsRequest;
    }

    private static void confirmNoTopicNameOverrides(AbstractRequest request, Optional<Supplier<Set<String>>> sessionTopicNames) {
        if (sessionTopicNames.isPresent()) {
            throw new IllegalArgumentException("Cannot set session topic names for " + request.getClass().getSimpleName());
        }
    }

    private static Boolean isK2HealthcheckTopic(String hcTenantTopicName) {
        return hcTenantTopicName.contains(HEALTHCHECK_TOPIC_K2_PREFIX);
    }

    private static Boolean isK2InternalTopic(String internalTopicName) {
        return !internalTopicName.startsWith("_");
    }

    private static Stream<String> filterPresent(Stream<Optional<String>> optionalStream) {
        return optionalStream.filter(Optional::isPresent).map(Optional::get);
    }

    private boolean appliesToExistingTopicNames(AbstractRequest request, RequestContext context, Stream<String> topicNames, String requestDescription) {
        Map<String, Optional<TopicType>> topicDeterminations = topicNames.distinct().collect(Collectors.toMap(topicName -> topicName, this.topicNameToTypeMapper));
        Map<String, Boolean> topicToK2Applicability = topicDeterminations.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> TopicType.FREIGHT == ((Optional)entry.getValue()).get()));
        if (topicToK2Applicability.isEmpty()) {
            RequestTypeForFurtherIntrospection requestTypeForFurtherIntrospection = K2RequestDeterminationBasedOnRequestDetails.getRequestTypeForFurtherIntrospection(context);
            return K2RequestDeterminationBasedOnRequestDetails.appliesToNewTopicNames(request, topicDeterminations.keySet().stream(), requestTypeForFurtherIntrospection, requestDescription);
        }
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicToK2Applicability, requestDescription);
        if (logger.isTraceEnabled()) {
            logger.trace(requestDescription + " request determined to " + (isK2Request ? "be " : "not be ") + "a K2 request: topicDeterminations=" + Utils.mkString(topicDeterminations, (String)"(", (String)")", (String)"=", (String)",") + "; request=" + request);
        }
        return isK2Request;
    }

    private static RequestTypeForFurtherIntrospection getRequestTypeForFurtherIntrospection(RequestContext context) {
        return K2RequestDeterminationBasedOnContextOnly.isHealthcheckTenant(context) ? RequestTypeForFurtherIntrospection.HEALTHCHECK_TENANT : RequestTypeForFurtherIntrospection.INTERNAL_LISTENER;
    }

    private static boolean appliesToNewTopicNames(AbstractRequest request, Stream<String> topicNames, RequestTypeForFurtherIntrospection requestTypeForFurtherIntrospection, String requestDescription) {
        boolean hcTenant = requestTypeForFurtherIntrospection == RequestTypeForFurtherIntrospection.HEALTHCHECK_TENANT;
        Map<String, Boolean> topicDeterminations = topicNames.distinct().collect(Collectors.toMap(topicName -> topicName, topicName -> hcTenant ? K2RequestDeterminationBasedOnRequestDetails.isK2HealthcheckTopic(topicName) : K2RequestDeterminationBasedOnRequestDetails.isK2InternalTopic(topicName)));
        boolean isK2Request = K2RequestDeterminationBasedOnRequestDetails.validate(topicDeterminations, requestDescription);
        if (logger.isTraceEnabled()) {
            logger.trace(requestDescription + " request determined to " + (isK2Request ? "be " : "not be ") + "a K2 request: topicDeterminations=" + Utils.mkString(topicDeterminations, (String)"(", (String)")", (String)"=", (String)",") + "; request=" + request);
        }
        return isK2Request;
    }

    private static boolean validate(Map<String, Boolean> topicNamesToDeterminations, String requestDescription) {
        HashSet<Boolean> uniqueTopicDeterminations = new HashSet<Boolean>(topicNamesToDeterminations.values());
        if (uniqueTopicDeterminations.size() > 1) {
            throw new InvalidRequestException("Existence of both K2 and Non-K2 topics in the same " + requestDescription + " request is not supported: " + Utils.mkString(topicNamesToDeterminations, (String)"", (String)"", (String)"=", (String)","));
        }
        return uniqueTopicDeterminations.isEmpty() || (Boolean)uniqueTopicDeterminations.iterator().next() != false;
    }

    private static enum RequestTypeForFurtherIntrospection {
        INTERNAL_LISTENER,
        HEALTHCHECK_TENANT;

    }
}

