/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;

public class K2TopicMetadata {
    private final String topicName;
    private final Uuid topicId;
    private final int numPartitions;
    private final K2TopicLifecycleState k2TopicLifecycleState;
    private final int lastExpandedToPartitionCount;
    private final Map<String, String> topicConfigs;

    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState) {
        this(topicName, topicId, numPartitions, k2TopicLifecycleState, 0);
    }

    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState, int lastExpandedToPartitionCount) {
        this(topicName, topicId, numPartitions, k2TopicLifecycleState, lastExpandedToPartitionCount, Collections.emptyMap());
    }

    public K2TopicMetadata(String topicName, Uuid topicId, int numPartitions, K2TopicLifecycleState k2TopicLifecycleState, int lastExpandedToPartitionCount, Map<String, String> topicConfigs) {
        this.topicName = Objects.requireNonNull(topicName);
        this.topicId = Objects.requireNonNull(topicId);
        this.numPartitions = numPartitions;
        this.k2TopicLifecycleState = Objects.requireNonNull(k2TopicLifecycleState);
        this.lastExpandedToPartitionCount = lastExpandedToPartitionCount;
        this.topicConfigs = Objects.requireNonNull(topicConfigs);
    }

    public String topicName() {
        return this.topicName;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int lastExpandedToPartitionCount() {
        return this.lastExpandedToPartitionCount;
    }

    public Map<String, String> topicConfigs() {
        return this.topicConfigs;
    }

    public Stream<TopicIdPartition> partitions() {
        return IntStream.range(0, Math.max(this.numPartitions, this.lastExpandedToPartitionCount)).mapToObj(part -> new TopicIdPartition(this.topicId, part, this.topicName));
    }

    public K2TopicLifecycleState k2TopicLifecycleState() {
        return this.k2TopicLifecycleState;
    }

    public String toString() {
        return "K2TopicMetadata{topicName='" + this.topicName + '\'' + ", topicId=" + this.topicId + ", numPartitions=" + this.numPartitions + ", k2TopicLifecycleState=" + (Object)((Object)this.k2TopicLifecycleState) + ", lastExpandedToPartitionCount=" + this.lastExpandedToPartitionCount + ", topicConfig=" + Utils.mkString(this.topicConfigs, (String)"{", (String)"}", (String)"=", (String)",") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        K2TopicMetadata that = (K2TopicMetadata)o;
        return this.numPartitions == that.numPartitions && Objects.equals(this.topicName, that.topicName) && Objects.equals(this.topicId, that.topicId) && this.k2TopicLifecycleState == that.k2TopicLifecycleState && this.lastExpandedToPartitionCount == that.lastExpandedToPartitionCount && Objects.equals(this.topicConfigs, that.topicConfigs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topicName, this.topicId, this.numPartitions, this.k2TopicLifecycleState, this.lastExpandedToPartitionCount, this.topicConfigs});
    }

    public static enum K2TopicLifecycleState {
        CREATING,
        ONLINE,
        DELETING;

    }
}

