/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.utils;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.kafka.common.serialization.Serde;

public class KeyBufferComparator<K>
implements Comparator<ByteBuffer>,
Serializable {
    private static final long serialVersionUID = 7847770324097153442L;
    private final Serde<K> keySerde;
    private final Comparator<? super K> keyComparator;

    public KeyBufferComparator(Serde<K> keySerde, Comparator<? super K> keyComparator) {
        this.keySerde = keySerde;
        this.keyComparator = keyComparator;
    }

    @Override
    public int compare(ByteBuffer b1, ByteBuffer b2) {
        byte[] key1Bytes = new byte[b1.remaining()];
        byte[] key2Bytes = new byte[b2.remaining()];
        b1.duplicate().get(key1Bytes);
        b2.duplicate().get(key2Bytes);
        Object key1 = this.keySerde.deserializer().deserialize(null, key1Bytes);
        Object key2 = this.keySerde.deserializer().deserialize(null, key2Bytes);
        return this.keyComparator.compare(key1, key2);
    }
}

