/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.streams.serdes.avro;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.streams.serdes.avro.ConfigurationUtils;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.reflect.ReflectData;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

@InterfaceStability.Unstable
public class ReflectionAvroDeserializer<T>
implements Deserializer<T> {
    private final KafkaAvroDeserializer inner;
    private final Schema schema;

    public ReflectionAvroDeserializer() {
        this.schema = null;
        this.inner = new KafkaAvroDeserializer();
    }

    public ReflectionAvroDeserializer(Class<T> type) {
        this.schema = ReflectData.get().getSchema(type);
        this.inner = new KafkaAvroDeserializer();
    }

    ReflectionAvroDeserializer(SchemaRegistryClient client) {
        this.schema = null;
        this.inner = new KafkaAvroDeserializer(client);
    }

    ReflectionAvroDeserializer(SchemaRegistryClient client, Class<T> type) {
        this.schema = ReflectData.get().getSchema(type);
        this.inner = new KafkaAvroDeserializer(client);
    }

    public void configure(Map<String, ?> deserializerConfig, boolean isDeserializerForRecordKeys) {
        this.inner.configure(ConfigurationUtils.withReflectionAvroEnabled(deserializerConfig), isDeserializerForRecordKeys);
    }

    public T deserialize(String topic, byte[] bytes) {
        return this.deserialize(topic, null, bytes);
    }

    public T deserialize(String topic, Headers headers, byte[] bytes) {
        return (T)this.inner.deserialize(topic, headers, bytes, this.schema);
    }

    public void close() {
        this.inner.close();
    }
}

