/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.jwt;

import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutableParametersRegistry;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.TinkBugException;
import com.google.crypto.tink.jwt.JsonUtil;
import com.google.crypto.tink.jwt.JwtFormat;
import com.google.crypto.tink.jwt.JwtHmacParameters;
import com.google.crypto.tink.jwt.JwtHmacProtoSerialization;
import com.google.crypto.tink.jwt.JwtInvalidException;
import com.google.crypto.tink.jwt.JwtMacInternal;
import com.google.crypto.tink.jwt.JwtValidator;
import com.google.crypto.tink.jwt.RawJwt;
import com.google.crypto.tink.jwt.VerifiedJwt;
import com.google.crypto.tink.proto.JwtHmacAlgorithm;
import com.google.crypto.tink.proto.JwtHmacKey;
import com.google.crypto.tink.proto.JwtHmacKeyFormat;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.subtle.PrfHmacJce;
import com.google.crypto.tink.subtle.PrfMac;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.crypto.spec.SecretKeySpec;

public final class JwtHmacKeyManager
extends KeyTypeManager<JwtHmacKey> {
    private static final String getAlgorithmName(JwtHmacAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case HS256: {
                return "HS256";
            }
            case HS384: {
                return "HS384";
            }
            case HS512: {
                return "HS512";
            }
        }
        throw new GeneralSecurityException("unknown algorithm");
    }

    private static final String getHmacAlgorithm(JwtHmacAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case HS256: {
                return "HMACSHA256";
            }
            case HS384: {
                return "HMACSHA384";
            }
            case HS512: {
                return "HMACSHA512";
            }
        }
        throw new GeneralSecurityException("unknown algorithm");
    }

    private static final int getMinimumKeySizeInBytes(JwtHmacAlgorithm algorithm) throws GeneralSecurityException {
        switch (algorithm) {
            case HS256: {
                return 32;
            }
            case HS384: {
                return 48;
            }
            case HS512: {
                return 64;
            }
        }
        throw new GeneralSecurityException("unknown algorithm");
    }

    public JwtHmacKeyManager() {
        super(JwtHmacKey.class, new PrimitiveFactory<JwtMacInternal, JwtHmacKey>(JwtMacInternal.class){

            @Override
            public JwtMacInternal getPrimitive(JwtHmacKey key) throws GeneralSecurityException {
                JwtHmacAlgorithm algorithm = key.getAlgorithm();
                byte[] keyValue = key.getKeyValue().toByteArray();
                SecretKeySpec keySpec = new SecretKeySpec(keyValue, "HMAC");
                PrfHmacJce prf = new PrfHmacJce(JwtHmacKeyManager.getHmacAlgorithm(algorithm), keySpec);
                PrfMac prfMac = new PrfMac(prf, prf.getMaxOutputLength());
                Optional<String> customKid = key.hasCustomKid() ? Optional.of(key.getCustomKid().getValue()) : Optional.empty();
                return new JwtHmac(JwtHmacKeyManager.getAlgorithmName(algorithm), customKid, prfMac);
            }
        });
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.JwtHmacKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(JwtHmacKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (key.getKeyValue().size() < JwtHmacKeyManager.getMinimumKeySizeInBytes(key.getAlgorithm())) {
            throw new GeneralSecurityException("key too short");
        }
    }

    @Override
    public JwtHmacKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return JwtHmacKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<JwtHmacKeyFormat, JwtHmacKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<JwtHmacKeyFormat, JwtHmacKey>(JwtHmacKeyFormat.class){

            @Override
            public void validateKeyFormat(JwtHmacKeyFormat format) throws GeneralSecurityException {
                if (format.getKeySize() < JwtHmacKeyManager.getMinimumKeySizeInBytes(format.getAlgorithm())) {
                    throw new GeneralSecurityException("key too short");
                }
            }

            @Override
            public JwtHmacKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return JwtHmacKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public JwtHmacKey createKey(JwtHmacKeyFormat format) {
                return JwtHmacKey.newBuilder().setVersion(JwtHmacKeyManager.this.getVersion()).setAlgorithm(format.getAlgorithm()).setKeyValue(ByteString.copyFrom((byte[])Random.randBytes(format.getKeySize()))).build();
            }
        };
    }

    private static Map<String, Parameters> namedParameters() throws GeneralSecurityException {
        HashMap<String, JwtHmacParameters> result = new HashMap<String, JwtHmacParameters>();
        result.put("JWT_HS256_RAW", JwtHmacParameters.builder().setKeySizeBytes(32).setAlgorithm(JwtHmacParameters.Algorithm.HS256).setKidStrategy(JwtHmacParameters.KidStrategy.IGNORED).build());
        result.put("JWT_HS256", JwtHmacParameters.builder().setKeySizeBytes(32).setAlgorithm(JwtHmacParameters.Algorithm.HS256).setKidStrategy(JwtHmacParameters.KidStrategy.BASE64_ENCODED_KEY_ID).build());
        result.put("JWT_HS384_RAW", JwtHmacParameters.builder().setKeySizeBytes(48).setAlgorithm(JwtHmacParameters.Algorithm.HS384).setKidStrategy(JwtHmacParameters.KidStrategy.IGNORED).build());
        result.put("JWT_HS384", JwtHmacParameters.builder().setKeySizeBytes(48).setAlgorithm(JwtHmacParameters.Algorithm.HS384).setKidStrategy(JwtHmacParameters.KidStrategy.BASE64_ENCODED_KEY_ID).build());
        result.put("JWT_HS512_RAW", JwtHmacParameters.builder().setKeySizeBytes(64).setAlgorithm(JwtHmacParameters.Algorithm.HS512).setKidStrategy(JwtHmacParameters.KidStrategy.IGNORED).build());
        result.put("JWT_HS512", JwtHmacParameters.builder().setKeySizeBytes(64).setAlgorithm(JwtHmacParameters.Algorithm.HS512).setKidStrategy(JwtHmacParameters.KidStrategy.BASE64_ENCODED_KEY_ID).build());
        return Collections.unmodifiableMap(result);
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new JwtHmacKeyManager(), newKeyAllowed);
        JwtHmacProtoSerialization.register();
        MutableParametersRegistry.globalInstance().putAll(JwtHmacKeyManager.namedParameters());
    }

    public static final KeyTemplate hs256Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(JwtHmacParameters.builder().setKeySizeBytes(32).setKidStrategy(JwtHmacParameters.KidStrategy.IGNORED).setAlgorithm(JwtHmacParameters.Algorithm.HS256).build()));
    }

    public static final KeyTemplate hs384Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(JwtHmacParameters.builder().setKeySizeBytes(48).setKidStrategy(JwtHmacParameters.KidStrategy.IGNORED).setAlgorithm(JwtHmacParameters.Algorithm.HS384).build()));
    }

    public static final KeyTemplate hs512Template() {
        return TinkBugException.exceptionIsBug(() -> KeyTemplate.createFrom(JwtHmacParameters.builder().setKeySizeBytes(64).setKidStrategy(JwtHmacParameters.KidStrategy.IGNORED).setAlgorithm(JwtHmacParameters.Algorithm.HS512).build()));
    }

    @Immutable
    private static final class JwtHmac
    implements JwtMacInternal {
        private final PrfMac prfMac;
        private final String algorithm;
        private final Optional<String> customKidFromHmacKey;

        public JwtHmac(String algorithm, Optional<String> customKidFromHmacKey, PrfMac prfMac) {
            this.algorithm = algorithm;
            this.customKidFromHmacKey = customKidFromHmacKey;
            this.prfMac = prfMac;
        }

        @Override
        public String computeMacAndEncodeWithKid(RawJwt rawJwt, Optional<String> kid) throws GeneralSecurityException {
            if (this.customKidFromHmacKey.isPresent()) {
                if (kid.isPresent()) {
                    throw new JwtInvalidException("custom_kid can only be set for RAW keys.");
                }
                kid = this.customKidFromHmacKey;
            }
            String unsignedCompact = JwtFormat.createUnsignedCompact(this.algorithm, kid, rawJwt);
            return JwtFormat.createSignedCompact(unsignedCompact, this.prfMac.computeMac(unsignedCompact.getBytes(StandardCharsets.US_ASCII)));
        }

        @Override
        public VerifiedJwt verifyMacAndDecodeWithKid(String compact, JwtValidator validator, Optional<String> kid) throws GeneralSecurityException {
            JwtFormat.Parts parts = JwtFormat.splitSignedCompact(compact);
            this.prfMac.verifyMac(parts.signatureOrMac, parts.unsignedCompact.getBytes(StandardCharsets.US_ASCII));
            JsonObject parsedHeader = JsonUtil.parseJson(parts.header);
            JwtFormat.validateHeader(this.algorithm, kid, this.customKidFromHmacKey, parsedHeader);
            RawJwt token = RawJwt.fromJsonPayload(JwtFormat.getTypeHeader(parsedHeader), parts.payload);
            return validator.validate(token);
        }
    }
}

