/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.keyderivation.internal;

import com.google.crypto.tink.Key;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.PrimitiveSet;
import com.google.crypto.tink.PrimitiveWrapper;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.keyderivation.KeysetDeriver;
import com.google.crypto.tink.keyderivation.internal.KeyDeriver;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;

public final class KeysetDeriverWrapper
implements PrimitiveWrapper<KeyDeriver, KeysetDeriver> {
    private static final KeysetDeriverWrapper WRAPPER = new KeysetDeriverWrapper();

    private static void validate(PrimitiveSet<KeyDeriver> primitiveSet) throws GeneralSecurityException {
        if (primitiveSet.getPrimary() == null) {
            throw new GeneralSecurityException("Primitive set has no primary.");
        }
    }

    KeysetDeriverWrapper() {
    }

    @Override
    public KeysetDeriver wrap(PrimitiveSet<KeyDeriver> primitiveSet) throws GeneralSecurityException {
        KeysetDeriverWrapper.validate(primitiveSet);
        return new WrappedKeysetDeriver(primitiveSet);
    }

    @Override
    public Class<KeysetDeriver> getPrimitiveClass() {
        return KeysetDeriver.class;
    }

    @Override
    public Class<KeyDeriver> getInputPrimitiveClass() {
        return KeyDeriver.class;
    }

    public static void register() throws GeneralSecurityException {
        Registry.registerPrimitiveWrapper(WRAPPER);
    }

    @Immutable
    private static class WrappedKeysetDeriver
    implements KeysetDeriver {
        private final PrimitiveSet<KeyDeriver> primitiveSet;

        private WrappedKeysetDeriver(PrimitiveSet<KeyDeriver> primitiveSet) {
            this.primitiveSet = primitiveSet;
        }

        private static KeysetHandle.Builder.Entry deriveAndGetEntry(byte[] salt, PrimitiveSet.Entry<KeyDeriver> entry, int primaryKeyId) throws GeneralSecurityException {
            KeyDeriver deriver = entry.getFullPrimitive();
            if (deriver == null) {
                throw new GeneralSecurityException("Primitive set has non-full primitives -- this is probably a bug");
            }
            Key key = deriver.deriveKey(salt);
            KeysetHandle.Builder.Entry result = KeysetHandle.importKey(key);
            result.withFixedId(entry.getKeyId());
            if (entry.getKeyId() == primaryKeyId) {
                result.makePrimary();
            }
            return result;
        }

        @Override
        public KeysetHandle deriveKeyset(byte[] salt) throws GeneralSecurityException {
            KeysetHandle.Builder builder = KeysetHandle.newBuilder();
            for (PrimitiveSet.Entry<KeyDeriver> entry : this.primitiveSet.getAllInKeysetOrder()) {
                builder.addEntry(WrappedKeysetDeriver.deriveAndGetEntry(salt, entry, this.primitiveSet.getPrimary().getKeyId()));
            }
            return builder.build();
        }
    }
}

