/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.keyderivation.internal;

import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.Key;
import com.google.crypto.tink.Registry;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.internal.KeyTypeManager;
import com.google.crypto.tink.internal.MutablePrimitiveRegistry;
import com.google.crypto.tink.internal.MutableSerializationRegistry;
import com.google.crypto.tink.internal.PrimitiveConstructor;
import com.google.crypto.tink.internal.PrimitiveFactory;
import com.google.crypto.tink.internal.ProtoKeySerialization;
import com.google.crypto.tink.keyderivation.PrfBasedKeyDerivationKey;
import com.google.crypto.tink.keyderivation.internal.KeyDeriver;
import com.google.crypto.tink.keyderivation.internal.PrfBasedKeyDerivationKeyProtoSerialization;
import com.google.crypto.tink.keyderivation.internal.PrfBasedKeyDeriver;
import com.google.crypto.tink.proto.KeyData;
import com.google.crypto.tink.proto.OutputPrefixType;
import com.google.crypto.tink.proto.PrfBasedDeriverKey;
import com.google.crypto.tink.proto.PrfBasedDeriverKeyFormat;
import com.google.crypto.tink.subtle.Validators;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.GeneralSecurityException;

public final class PrfBasedDeriverKeyManager
extends KeyTypeManager<PrfBasedDeriverKey> {
    private static final PrimitiveConstructor<PrfBasedKeyDerivationKey, KeyDeriver> PRIMITIVE_CONSTRUCTOR = PrimitiveConstructor.create(PrfBasedKeyDeriver::create, PrfBasedKeyDerivationKey.class, KeyDeriver.class);

    public PrfBasedDeriverKeyManager() {
        super(PrfBasedDeriverKey.class, new PrimitiveFactory[0]);
    }

    @Override
    public TinkFipsUtil.AlgorithmFipsCompatibility fipsStatus() {
        return TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_NOT_FIPS;
    }

    @Override
    public String getKeyType() {
        return "type.googleapis.com/google.crypto.tink.PrfBasedDeriverKey";
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public KeyData.KeyMaterialType keyMaterialType() {
        return KeyData.KeyMaterialType.SYMMETRIC;
    }

    @Override
    public void validateKey(PrfBasedDeriverKey key) throws GeneralSecurityException {
        Validators.validateVersion(key.getVersion(), this.getVersion());
        if (!key.hasPrfKey()) {
            throw new GeneralSecurityException("key.prf_key must be set");
        }
        if (!key.getParams().hasDerivedKeyTemplate()) {
            throw new GeneralSecurityException("key.params.derived_key_template must be set");
        }
    }

    @Override
    public PrfBasedDeriverKey parseKey(ByteString byteString) throws InvalidProtocolBufferException {
        return PrfBasedDeriverKey.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public KeyTypeManager.KeyFactory<PrfBasedDeriverKeyFormat, PrfBasedDeriverKey> keyFactory() {
        return new KeyTypeManager.KeyFactory<PrfBasedDeriverKeyFormat, PrfBasedDeriverKey>(PrfBasedDeriverKeyFormat.class){

            @Override
            public void validateKeyFormat(PrfBasedDeriverKeyFormat format) throws GeneralSecurityException {
                if (!format.hasPrfKeyTemplate()) {
                    throw new GeneralSecurityException("format.params.prf_key_template must be set");
                }
                if (!format.getParams().hasDerivedKeyTemplate()) {
                    throw new GeneralSecurityException("format.params.derived_key_template must be set");
                }
            }

            @Override
            public PrfBasedDeriverKeyFormat parseKeyFormat(ByteString byteString) throws InvalidProtocolBufferException {
                return PrfBasedDeriverKeyFormat.parseFrom(byteString, ExtensionRegistryLite.getEmptyRegistry());
            }

            @Override
            public PrfBasedDeriverKey createKey(PrfBasedDeriverKeyFormat format) throws GeneralSecurityException {
                KeyData prfKeyData = Registry.newKeyData(format.getPrfKeyTemplate());
                PrfBasedDeriverKey result = PrfBasedDeriverKey.newBuilder().setVersion(PrfBasedDeriverKeyManager.this.getVersion()).setParams(format.getParams()).setPrfKey(prfKeyData).build();
                OutputPrefixType outputPrefixType = result.getParams().getDerivedKeyTemplate().getOutputPrefixType();
                ProtoKeySerialization serialization = ProtoKeySerialization.create("type.googleapis.com/google.crypto.tink.PrfBasedDeriverKey", result.toByteString(), KeyData.KeyMaterialType.SYMMETRIC, result.getParams().getDerivedKeyTemplate().getOutputPrefixType(), outputPrefixType.equals((Object)OutputPrefixType.RAW) ? null : Integer.valueOf(0));
                Key key = MutableSerializationRegistry.globalInstance().parseKey(serialization, InsecureSecretKeyAccess.get());
                if (!(key instanceof PrfBasedKeyDerivationKey)) {
                    throw new GeneralSecurityException("Key parsing returned unexpected key type: " + key.getClass());
                }
                KeyDeriver unused = PrfBasedKeyDeriver.create((PrfBasedKeyDerivationKey)key);
                return result;
            }
        };
    }

    public static void register(boolean newKeyAllowed) throws GeneralSecurityException {
        Registry.registerKeyManager(new PrfBasedDeriverKeyManager(), newKeyAllowed);
        MutablePrimitiveRegistry.globalInstance().registerPrimitiveConstructor(PRIMITIVE_CONSTRUCTOR);
        PrfBasedKeyDerivationKeyProtoSerialization.register();
    }
}

