/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.AccessesPartialKey;
import com.google.crypto.tink.InsecureSecretKeyAccess;
import com.google.crypto.tink.PublicKeySign;
import com.google.crypto.tink.config.internal.TinkFipsUtil;
import com.google.crypto.tink.signature.RsaSsaPssParameters;
import com.google.crypto.tink.signature.RsaSsaPssPrivateKey;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.RsaSsaPssVerifyJce;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

@Immutable
public final class RsaSsaPssSignJce
implements PublicKeySign {
    public static final TinkFipsUtil.AlgorithmFipsCompatibility FIPS = TinkFipsUtil.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private final RSAPrivateCrtKey privateKey;
    private final RSAPublicKey publicKey;
    private final Enums.HashType sigHash;
    private final Enums.HashType mgf1Hash;
    private final int saltLength;
    private final byte[] outputPrefix;
    private final byte[] messageSuffix;
    private static final String RAW_RSA_ALGORITHM = "RSA/ECB/NOPADDING";

    public RsaSsaPssSignJce(RSAPrivateCrtKey priv, Enums.HashType sigHash, Enums.HashType mgf1Hash, int saltLength) throws GeneralSecurityException {
        this(priv, sigHash, mgf1Hash, saltLength, new byte[0], new byte[0]);
    }

    private RsaSsaPssSignJce(RSAPrivateCrtKey priv, Enums.HashType sigHash, Enums.HashType mgf1Hash, int saltLength, byte[] outputPrefix, byte[] messageSuffix) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use RSA PSS in FIPS-mode, as BoringCrypto module is not available.");
        }
        Validators.validateSignatureHash(sigHash);
        Validators.validateRsaModulusSize(priv.getModulus().bitLength());
        Validators.validateRsaPublicExponent(priv.getPublicExponent());
        this.privateKey = priv;
        KeyFactory kf = EngineFactory.KEY_FACTORY.getInstance("RSA");
        this.publicKey = (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(priv.getModulus(), priv.getPublicExponent()));
        this.sigHash = sigHash;
        this.mgf1Hash = mgf1Hash;
        this.saltLength = saltLength;
        this.outputPrefix = outputPrefix;
        this.messageSuffix = messageSuffix;
    }

    @AccessesPartialKey
    public static PublicKeySign create(RsaSsaPssPrivateKey key) throws GeneralSecurityException {
        byte[] byArray;
        KeyFactory kf = EngineFactory.KEY_FACTORY.getInstance("RSA");
        RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)kf.generatePrivate(new RSAPrivateCrtKeySpec(key.getPublicKey().getModulus(), key.getParameters().getPublicExponent(), key.getPrivateExponent().getBigInteger(InsecureSecretKeyAccess.get()), key.getPrimeP().getBigInteger(InsecureSecretKeyAccess.get()), key.getPrimeQ().getBigInteger(InsecureSecretKeyAccess.get()), key.getPrimeExponentP().getBigInteger(InsecureSecretKeyAccess.get()), key.getPrimeExponentQ().getBigInteger(InsecureSecretKeyAccess.get()), key.getCrtCoefficient().getBigInteger(InsecureSecretKeyAccess.get())));
        RsaSsaPssParameters params = key.getParameters();
        int n = params.getSaltLengthBytes();
        byte[] byArray2 = key.getOutputPrefix().toByteArray();
        if (key.getParameters().getVariant().equals(RsaSsaPssParameters.Variant.LEGACY)) {
            byte[] byArray3 = new byte[1];
            byArray = byArray3;
            byArray3[0] = 0;
        } else {
            byArray = new byte[]{};
        }
        return new RsaSsaPssSignJce(privateKey, RsaSsaPssVerifyJce.HASH_TYPE_CONVERTER.toProtoEnum(params.getSigHashType()), RsaSsaPssVerifyJce.HASH_TYPE_CONVERTER.toProtoEnum(params.getMgf1HashType()), n, byArray2, byArray);
    }

    private byte[] noPrefixSign(byte[] data) throws GeneralSecurityException {
        int modBits = this.publicKey.getModulus().bitLength();
        byte[] em = this.emsaPssEncode(data, modBits - 1);
        return this.rsasp1(em);
    }

    @Override
    public byte[] sign(byte[] data) throws GeneralSecurityException {
        byte[] signature = this.messageSuffix.length == 0 ? this.noPrefixSign(data) : this.noPrefixSign(Bytes.concat(data, this.messageSuffix));
        if (this.outputPrefix.length == 0) {
            return signature;
        }
        return Bytes.concat(this.outputPrefix, signature);
    }

    private byte[] rsasp1(byte[] m) throws GeneralSecurityException {
        Cipher decryptCipher = EngineFactory.CIPHER.getInstance(RAW_RSA_ALGORITHM);
        decryptCipher.init(2, this.privateKey);
        byte[] c = decryptCipher.doFinal(m);
        Cipher encryptCipher = EngineFactory.CIPHER.getInstance(RAW_RSA_ALGORITHM);
        encryptCipher.init(1, this.publicKey);
        byte[] m0 = encryptCipher.doFinal(c);
        if (!new BigInteger(1, m).equals(new BigInteger(1, m0))) {
            throw new RuntimeException("Security bug: RSA signature computation error");
        }
        return c;
    }

    private byte[] emsaPssEncode(byte[] m, int emBits) throws GeneralSecurityException {
        int i;
        Validators.validateSignatureHash(this.sigHash);
        MessageDigest digest = EngineFactory.MESSAGE_DIGEST.getInstance(SubtleUtil.toDigestAlgo(this.sigHash));
        byte[] mHash = digest.digest(m);
        int hLen = digest.getDigestLength();
        int emLen = (emBits - 1) / 8 + 1;
        if (emLen < hLen + this.saltLength + 2) {
            throw new GeneralSecurityException("encoding error");
        }
        byte[] salt = Random.randBytes(this.saltLength);
        byte[] mPrime = new byte[8 + hLen + this.saltLength];
        System.arraycopy(mHash, 0, mPrime, 8, hLen);
        System.arraycopy(salt, 0, mPrime, 8 + hLen, salt.length);
        byte[] h = digest.digest(mPrime);
        byte[] db = new byte[emLen - hLen - 1];
        db[emLen - this.saltLength - hLen - 2] = 1;
        System.arraycopy(salt, 0, db, emLen - this.saltLength - hLen - 1, salt.length);
        byte[] dbMask = SubtleUtil.mgf1(h, emLen - hLen - 1, this.mgf1Hash);
        byte[] maskedDb = new byte[emLen - hLen - 1];
        for (i = 0; i < maskedDb.length; ++i) {
            maskedDb[i] = (byte)(db[i] ^ dbMask[i]);
        }
        i = 0;
        while ((long)i < (long)emLen * 8L - (long)emBits) {
            int bytePos = i / 8;
            int bitPos = 7 - i % 8;
            maskedDb[bytePos] = (byte)(maskedDb[bytePos] & ~(1 << bitPos));
            ++i;
        }
        byte[] em = new byte[maskedDb.length + hLen + 1];
        System.arraycopy(maskedDb, 0, em, 0, maskedDb.length);
        System.arraycopy(h, 0, em, maskedDb.length, h.length);
        em[maskedDb.length + hLen] = -68;
        return em;
    }
}

