/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceType {
    public static final ResourceType ALL = new ResourceType("All");
    private static final Map<String, ResourceType> RESOURCE_TYPE_MAP = new ConcurrentHashMap<String, ResourceType>();
    private final String name;

    public ResourceType(String name) {
        this.name = name;
    }

    public static ResourceType resourceType(String resourceType) {
        ResourceType rt = RESOURCE_TYPE_MAP.get(resourceType);
        if (rt == null) {
            rt = RESOURCE_TYPE_MAP.computeIfAbsent(resourceType, ResourceType::new);
        }
        return rt;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceType)) {
            return false;
        }
        ResourceType that = (ResourceType)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name;
    }
}

