/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.CandidateState;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.FollowerState;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.ResignedState;
import org.apache.kafka.raft.UnattachedState;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.slf4j.Logger;

public class QuorumState {
    private final OptionalInt localId;
    private final Uuid localDirectoryId;
    private final Time time;
    private final Logger log;
    private final QuorumStateStore store;
    private final KRaftControlRecordStateMachine partitionState;
    private final Endpoints localListeners;
    private final SupportedVersionRange localSupportedKRaftVersion;
    private final Random random;
    private final int electionTimeoutMs;
    private final int fetchTimeoutMs;
    private final LogContext logContext;
    private volatile EpochState state;

    public QuorumState(OptionalInt localId, Uuid localDirectoryId, KRaftControlRecordStateMachine partitionState, Endpoints localListeners, SupportedVersionRange localSupportedKRaftVersion, int electionTimeoutMs, int fetchTimeoutMs, QuorumStateStore store, Time time, LogContext logContext, Random random) {
        this.localId = localId;
        this.localDirectoryId = localDirectoryId;
        this.partitionState = partitionState;
        this.localListeners = localListeners;
        this.localSupportedKRaftVersion = localSupportedKRaftVersion;
        this.electionTimeoutMs = electionTimeoutMs;
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.store = store;
        this.time = time;
        this.log = logContext.logger(QuorumState.class);
        this.random = random;
        this.logContext = logContext;
    }

    private ElectionState readElectionState() {
        ElectionState election = this.store.readElectionState().orElseGet(() -> ElectionState.withUnknownLeader(0, this.partitionState.lastVoterSet().voterIds()));
        return election;
    }

    public void initialize(OffsetAndEpoch logEndOffsetAndEpoch) throws IllegalStateException {
        EpochState initialState;
        ElectionState election = this.readElectionState();
        if (election.hasVoted() && !this.localId.isPresent()) {
            throw new IllegalStateException(String.format("Initialized quorum state (%s) with a voted candidate but without a local id", election));
        }
        if (election.epoch() < logEndOffsetAndEpoch.epoch()) {
            this.log.warn("Epoch from quorum store file ({}) is {}, which is smaller than last written epoch {} in the log", new Object[]{this.store.path(), election.epoch(), logEndOffsetAndEpoch.epoch()});
            initialState = new UnattachedState(this.time, logEndOffsetAndEpoch.epoch(), OptionalInt.empty(), Optional.empty(), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
        } else if (this.localId.isPresent() && election.isLeader(this.localId.getAsInt())) {
            initialState = new ResignedState(this.time, this.localId.getAsInt(), election.epoch(), this.partitionState.lastVoterSet().voterIds(), this.randomElectionTimeoutMs(), Collections.emptyList(), this.localListeners, this.logContext);
        } else if (this.localId.isPresent() && election.isVotedCandidate(ReplicaKey.of(this.localId.getAsInt(), this.localDirectoryId))) {
            initialState = new CandidateState(this.time, this.localId.getAsInt(), this.localDirectoryId, election.epoch(), this.partitionState.lastVoterSet(), Optional.empty(), 1, this.randomElectionTimeoutMs(), this.logContext);
        } else if (election.hasVoted()) {
            initialState = new UnattachedState(this.time, election.epoch(), OptionalInt.empty(), Optional.of(election.votedKey()), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
        } else if (election.hasLeader()) {
            VoterSet voters = this.partitionState.lastVoterSet();
            Endpoints leaderEndpoints = voters.listeners(election.leaderId());
            if (leaderEndpoints.isEmpty()) {
                this.log.info("The leader in election state {} is not a member of the latest voter set {}; transitioning to unattached instead of follower because the leader's endpoints are not known", (Object)election, (Object)voters);
                initialState = new UnattachedState(this.time, election.epoch(), OptionalInt.of(election.leaderId()), Optional.empty(), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
            } else {
                initialState = new FollowerState(this.time, election.epoch(), election.leaderId(), leaderEndpoints, voters.voterIds(), Optional.empty(), this.fetchTimeoutMs, this.logContext);
            }
        } else {
            initialState = new UnattachedState(this.time, election.epoch(), OptionalInt.empty(), Optional.empty(), this.partitionState.lastVoterSet().voterIds(), Optional.empty(), this.randomElectionTimeoutMs(), this.logContext);
        }
        this.durableTransitionTo(initialState);
    }

    public Set<Integer> voters() {
        return this.partitionState.lastVoterSet().voterIds();
    }

    public boolean isOnlyVoter() {
        return this.localId.isPresent() && this.partitionState.lastVoterSet().isOnlyVoter(ReplicaKey.of(this.localId.getAsInt(), this.localDirectoryId));
    }

    public int localIdOrSentinel() {
        return this.localId.orElse(-1);
    }

    public int localIdOrThrow() {
        return this.localId.orElseThrow(() -> new IllegalStateException("Required local id is not present"));
    }

    public OptionalInt localId() {
        return this.localId;
    }

    public Uuid localDirectoryId() {
        return this.localDirectoryId;
    }

    public ReplicaKey localReplicaKeyOrThrow() {
        return ReplicaKey.of(this.localIdOrThrow(), this.localDirectoryId());
    }

    public VoterSet.VoterNode localVoterNodeOrThrow() {
        return VoterSet.VoterNode.of(this.localReplicaKeyOrThrow(), this.localListeners, this.localSupportedKRaftVersion);
    }

    public int epoch() {
        return this.state.epoch();
    }

    public int leaderIdOrSentinel() {
        return this.state.election().leaderIdOrSentinel();
    }

    public Optional<LogOffsetMetadata> highWatermark() {
        return this.state.highWatermark();
    }

    public OptionalInt leaderId() {
        ElectionState election = this.state.election();
        if (election.hasLeader()) {
            return OptionalInt.of(this.state.election().leaderId());
        }
        return OptionalInt.empty();
    }

    public boolean hasLeader() {
        return this.leaderId().isPresent();
    }

    public boolean hasRemoteLeader() {
        return this.hasLeader() && this.leaderIdOrSentinel() != this.localIdOrSentinel();
    }

    public Endpoints leaderEndpoints() {
        return this.state.leaderEndpoints();
    }

    public boolean isVoter() {
        if (!this.localId.isPresent()) {
            return false;
        }
        return this.partitionState.lastVoterSet().isVoter(ReplicaKey.of(this.localId.getAsInt(), this.localDirectoryId));
    }

    public boolean isVoter(ReplicaKey nodeKey) {
        return this.partitionState.lastVoterSet().isVoter(nodeKey);
    }

    public boolean isObserver() {
        return !this.isVoter();
    }

    public void transitionToResigned(List<ReplicaKey> preferredSuccessors) {
        if (!this.isLeader()) {
            throw new IllegalStateException("Invalid transition to Resigned state from " + this.state);
        }
        int epoch = this.state.epoch();
        this.memoryTransitionTo(new ResignedState(this.time, this.localIdOrThrow(), epoch, this.partitionState.lastVoterSet().voterIds(), this.randomElectionTimeoutMs(), preferredSuccessors, this.localListeners, this.logContext));
    }

    public void transitionToUnattached(int epoch) {
        int currentEpoch = this.state.epoch();
        if (epoch <= currentEpoch) {
            throw new IllegalStateException("Cannot transition to Unattached with epoch= " + epoch + " from current state " + this.state);
        }
        long electionTimeoutMs = this.isObserver() ? Long.MAX_VALUE : (this.isCandidate() ? this.candidateStateOrThrow().remainingElectionTimeMs(this.time.milliseconds()) : (this.isUnattached() ? this.unattachedStateOrThrow().remainingElectionTimeMs(this.time.milliseconds()) : (long)this.randomElectionTimeoutMs()));
        this.durableTransitionTo(new UnattachedState(this.time, epoch, OptionalInt.empty(), Optional.empty(), this.partitionState.lastVoterSet().voterIds(), this.state.highWatermark(), electionTimeoutMs, this.logContext));
    }

    public void transitionToUnattachedVotedState(int epoch, ReplicaKey candidateKey) {
        int currentEpoch = this.state.epoch();
        if (this.localId.isPresent() && candidateKey.id() == this.localId.getAsInt()) {
            throw new IllegalStateException(String.format("Cannot transition to Voted for %s and epoch %d since it matches the local broker.id", candidateKey, epoch));
        }
        if (!this.localId.isPresent()) {
            throw new IllegalStateException("Cannot transition to voted without a replica id");
        }
        if (epoch < currentEpoch) {
            throw new IllegalStateException(String.format("Cannot transition to Voted for %s and epoch %d since the current epoch (%d) is larger", candidateKey, epoch, currentEpoch));
        }
        if (epoch == currentEpoch && !this.isUnattachedNotVoted()) {
            throw new IllegalStateException(String.format("Cannot transition to Voted for %s and epoch %d from the current state (%s)", candidateKey, epoch, this.state));
        }
        this.durableTransitionTo(new UnattachedState(this.time, epoch, OptionalInt.empty(), Optional.of(candidateKey), this.partitionState.lastVoterSet().voterIds(), this.state.highWatermark(), this.randomElectionTimeoutMs(), this.logContext));
        this.log.debug("Voted for candidate {} in epoch {}", (Object)candidateKey, (Object)epoch);
    }

    public void transitionToFollower(int epoch, int leaderId, Endpoints endpoints) {
        int currentEpoch = this.state.epoch();
        if (endpoints.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot transition to Follower with leader %s and epoch %s without a leader endpoint", leaderId, epoch));
        }
        if (this.localId.isPresent() && leaderId == this.localId.getAsInt()) {
            throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s and epoch %s since it matches the local node.id %s", leaderId, epoch, this.localId));
        }
        if (epoch < currentEpoch) {
            throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s and epoch %s since the current epoch %s is larger", leaderId, epoch, currentEpoch));
        }
        if (epoch == currentEpoch) {
            if (this.isFollower() && this.state.leaderEndpoints().size() >= endpoints.size()) {
                throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s, epoch %s and endpoints %s from state %s", leaderId, epoch, endpoints, this.state));
            }
            if (this.isLeader()) {
                throw new IllegalStateException(String.format("Cannot transition to Follower with leader %s and epoch %s from state %s", leaderId, epoch, this.state));
            }
        }
        this.durableTransitionTo(new FollowerState(this.time, epoch, leaderId, endpoints, this.partitionState.lastVoterSet().voterIds(), this.state.highWatermark(), this.fetchTimeoutMs, this.logContext));
    }

    public void transitionToCandidate() {
        if (this.isObserver()) {
            throw new IllegalStateException(String.format("Cannot transition to Candidate since the local id (%s) and directory id (%s) is not one of the voters %s", this.localId, this.localDirectoryId, this.partitionState.lastVoterSet()));
        }
        if (this.isLeader()) {
            throw new IllegalStateException("Cannot transition to Candidate since the local broker.id=" + this.localId + " since this node is already a Leader with state " + this.state);
        }
        int retries = this.isCandidate() ? this.candidateStateOrThrow().retries() + 1 : 1;
        int newEpoch = this.epoch() + 1;
        int electionTimeoutMs = this.randomElectionTimeoutMs();
        this.durableTransitionTo(new CandidateState(this.time, this.localIdOrThrow(), this.localDirectoryId, newEpoch, this.partitionState.lastVoterSet(), this.state.highWatermark(), retries, electionTimeoutMs, this.logContext));
    }

    public <T> LeaderState<T> transitionToLeader(long epochStartOffset, BatchAccumulator<T> accumulator) {
        if (this.isObserver()) {
            throw new IllegalStateException(String.format("Cannot transition to Leader since the local id (%s) and directory id (%s) is not one of the voters %s", this.localId, this.localDirectoryId, this.partitionState.lastVoterSet()));
        }
        if (!this.isCandidate()) {
            throw new IllegalStateException("Cannot transition to Leader from current state " + this.state);
        }
        CandidateState candidateState = this.candidateStateOrThrow();
        if (!candidateState.isVoteGranted()) {
            throw new IllegalStateException("Cannot become leader without majority votes granted");
        }
        LeaderState<T> state = new LeaderState<T>(this.time, ReplicaKey.of(this.localIdOrThrow(), this.localDirectoryId), this.epoch(), epochStartOffset, this.partitionState.lastVoterSet(), this.partitionState.lastVoterSetOffset(), this.partitionState.lastKraftVersion(), candidateState.grantingVoters(), accumulator, this.localListeners, this.fetchTimeoutMs, this.logContext);
        this.durableTransitionTo(state);
        return state;
    }

    private void durableTransitionTo(EpochState newState) {
        this.log.info("Attempting durable transition to {} from {}", (Object)newState, (Object)this.state);
        this.store.writeElectionState(newState.election(), this.partitionState.lastKraftVersion());
        this.memoryTransitionTo(newState);
    }

    private void memoryTransitionTo(EpochState newState) {
        if (this.state != null) {
            try {
                this.state.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to transition from " + this.state.name() + " to " + newState.name(), e);
            }
        }
        EpochState from = this.state;
        this.state = newState;
        this.log.info("Completed transition to {} from {}", (Object)newState, (Object)from);
    }

    private int randomElectionTimeoutMs() {
        if (this.electionTimeoutMs == 0) {
            return 0;
        }
        return this.electionTimeoutMs + this.random.nextInt(this.electionTimeoutMs);
    }

    public boolean canGrantVote(ReplicaKey candidateKey, boolean isLogUpToDate) {
        return this.state.canGrantVote(candidateKey, isLogUpToDate);
    }

    public FollowerState followerStateOrThrow() {
        if (this.isFollower()) {
            return (FollowerState)this.state;
        }
        throw new IllegalStateException("Expected to be Follower, but the current state is " + this.state);
    }

    public Optional<UnattachedState> maybeUnattachedState() {
        EpochState fixedState = this.state;
        if (fixedState instanceof UnattachedState) {
            return Optional.of((UnattachedState)fixedState);
        }
        return Optional.empty();
    }

    public UnattachedState unattachedStateOrThrow() {
        if (this.isUnattached()) {
            return (UnattachedState)this.state;
        }
        throw new IllegalStateException("Expected to be Unattached, but current state is " + this.state);
    }

    public <T> LeaderState<T> leaderStateOrThrow() {
        return this.maybeLeaderState().orElseThrow(() -> new IllegalStateException("Expected to be Leader, but current state is " + this.state));
    }

    public <T> Optional<LeaderState<T>> maybeLeaderState() {
        EpochState fixedState = this.state;
        if (fixedState instanceof LeaderState) {
            return Optional.of((LeaderState)fixedState);
        }
        return Optional.empty();
    }

    public ResignedState resignedStateOrThrow() {
        if (this.isResigned()) {
            return (ResignedState)this.state;
        }
        throw new IllegalStateException("Expected to be Resigned, but current state is " + this.state);
    }

    public CandidateState candidateStateOrThrow() {
        if (this.isCandidate()) {
            return (CandidateState)this.state;
        }
        throw new IllegalStateException("Expected to be Candidate, but current state is " + this.state);
    }

    public LeaderAndEpoch leaderAndEpoch() {
        ElectionState election = this.state.election();
        return new LeaderAndEpoch(election.optionalLeaderId(), election.epoch());
    }

    public boolean isFollower() {
        return this.state instanceof FollowerState;
    }

    public boolean isUnattached() {
        return this.state instanceof UnattachedState;
    }

    public boolean isUnattachedNotVoted() {
        return this.maybeUnattachedState().filter(unattached -> !unattached.votedKey().isPresent()).isPresent();
    }

    public boolean isUnattachedAndVoted() {
        return this.maybeUnattachedState().flatMap(UnattachedState::votedKey).isPresent();
    }

    public boolean isLeader() {
        return this.state instanceof LeaderState;
    }

    public boolean isResigned() {
        return this.state instanceof ResignedState;
    }

    public boolean isCandidate() {
        return this.state instanceof CandidateState;
    }
}

