/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.roledefinitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.roledefinitions.AccessPolicy;
import io.confluent.security.roledefinitions.RbacRoles;
import io.confluent.security.roledefinitions.Role;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class RolePermissionsFilter {
    private final Map<String, Map<String, List<String>>> rolePermissions;

    @JsonCreator
    public RolePermissionsFilter(@JsonProperty(value="roles") Map<String, Map<String, List<String>>> roles) {
        this.rolePermissions = roles;
    }

    public List<String> getRolesInFilter() {
        return new ArrayList<String>(this.rolePermissions.keySet());
    }

    public static List<String> getAllCloudFilters() {
        return Arrays.stream(FilterNames.values()).map(FilterNames::filterName).collect(Collectors.toList());
    }

    public static boolean doesFilterExist(String filterName) {
        List<FilterNames> filterNames = Arrays.asList(FilterNames.values());
        return filterNames.stream().anyMatch(filter -> filter.filterName().equals(filterName));
    }

    public ArrayList<AccessPolicy> filter(Role role) {
        return this.filterAccessPoliciesForRole(role);
    }

    private ArrayList<AccessPolicy> filterAccessPoliciesForRole(Role role) {
        ArrayList<AccessPolicy> filteredAccessPolicies = new ArrayList<AccessPolicy>();
        role.accessPolicies().forEach((bindingScope, accessPolicies) -> {
            for (AccessPolicy accessPolicy : accessPolicies) {
                AccessPolicy filteredAccessPolicy = new AccessPolicy((String)bindingScope, accessPolicy.bindWithResource(), this.filterResourceOperations(accessPolicy, this.rolePermissions.get(role.name())));
                if (filteredAccessPolicy.allowedOperations().isEmpty()) continue;
                filteredAccessPolicies.add(filteredAccessPolicy);
            }
        });
        return filteredAccessPolicies;
    }

    private Collection<AccessPolicy.ResourceOperations> filterResourceOperations(AccessPolicy accessPolicy, Map<String, List<String>> permittedResourceTypes) {
        ArrayList<AccessPolicy.ResourceOperations> filteredResourceOperations = new ArrayList<AccessPolicy.ResourceOperations>();
        for (AccessPolicy.ResourceOperations resourceOperations : accessPolicy.allowedOperations()) {
            String currentResourceType;
            Collection<String> filteredOperations;
            if (permittedResourceTypes == null || !permittedResourceTypes.containsKey(resourceOperations.resourceType()) || (filteredOperations = this.filterOperations(resourceOperations, permittedResourceTypes.get(currentResourceType = resourceOperations.resourceType()))).isEmpty()) continue;
            filteredResourceOperations.add(new AccessPolicy.ResourceOperations(currentResourceType, filteredOperations));
        }
        return filteredResourceOperations;
    }

    private Collection<String> filterOperations(AccessPolicy.ResourceOperations resourceOperations, List<String> permittedOperations) {
        ArrayList<String> filteredOperations = new ArrayList<String>();
        for (String operation : resourceOperations.operations()) {
            if (permittedOperations.contains(operation)) {
                filteredOperations.add(operation);
                continue;
            }
            if (!operation.equals("All")) continue;
            filteredOperations.addAll(permittedOperations);
        }
        return filteredOperations;
    }

    public static String listRolesAsASingleFilter(List<String> filters) {
        RbacRoles rbacRoles = RbacRoles.loadRolesWithFilters(filters);
        List orderedRbacRoles = rbacRoles.roles().stream().sorted(Comparator.comparing(Role::name)).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("roles:\n");
        for (Role role : orderedRbacRoles) {
            stringBuilder.append("\t").append(role.name()).append(":").append("\n");
            Collection<AccessPolicy> aps = role.flatAccessPolicies();
            TreeMap sortedMap = new TreeMap();
            for (AccessPolicy accessPolicy : aps) {
                Collection<AccessPolicy.ResourceOperations> ros = accessPolicy.allowedOperations();
                for (AccessPolicy.ResourceOperations ro : ros) {
                    if (sortedMap.containsKey(ro.resourceType())) {
                        List operations = (List)sortedMap.get(ro.resourceType());
                        operations.addAll(ro.operations());
                        operations.sort(String::compareTo);
                        sortedMap.put(ro.resourceType(), operations);
                        continue;
                    }
                    sortedMap.put(ro.resourceType(), ro.operations().stream().sorted().collect(Collectors.toList()));
                }
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                stringBuilder.append("\t\t").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static enum FilterNames {
        CLOUD_CORE_POLICY_FILTER("CloudCorePolicyFilter"),
        CLOUD_KAFKA_FILTER("CloudKafkaFilter"),
        CLOUD_SDS_FILTER("CloudSdsFilter"),
        CLOUD_RBAC_ROLES_FILTER("CloudRbacRolesFilter"),
        CLOUD_CATALOG_SR_RESOURCE_FILTER("CloudCatalogSrResourceFilter"),
        CLOUD_CATALOG_KAFKA_RESOURCE_FILTER("CloudCatalogKafkaResourceFilter"),
        CLOUD_CONNECT_V2_FILTER("CloudConnectV2Filter"),
        CLOUD_ACCESS_POINT_FILTER("CloudAccessPointFilter"),
        CLOUD_BILLING_FILTER("CloudBillingFilter"),
        CLOUD_CONNECTOR_FILTER("CloudConnectorFilter"),
        CLOUD_DNSRECORD_FILTER("CloudDnsRecordFilter"),
        CLOUD_FLINK_COMPUTE_POOL_FILTER("CloudFlinkComputePoolFilter"),
        CLOUD_FLINK_CONNECTION_FILTER("CloudFlinkConnectionFilter"),
        CLOUD_FLINK_FUNCTION_FILTER("CloudFlinkFunctionFilter"),
        CLOUD_FLINK_MODEL_FILTER("CloudFlinkModelFilter"),
        CLOUD_GATEWAY_FILTER("CloudGatewayFilter"),
        CLOUD_PRINCIPAL_DESCRIBE_FILTER("CloudPrincipalDescribeFilter"),
        CLOUD_PROVIDER_INTEGRATION_FILTER("CloudProviderIntegrationFilter"),
        CLOUD_WORKLOAD_IDENTITY_FILTER("CloudWorkloadIdentityFilter"),
        CLOUD_SA_CREATE_FILTER("CloudSaCreateFilter"),
        CLOUD_SDS_KEK_SR_RESOURCE_FILTER("CloudSdsKekSrResourceFilter"),
        CLOUD_SDS_KSQL_FILTER("CloudSdsKsqlFilter"),
        CLOUD_SDS_SR_FILTER("CloudSdsSrFilter"),
        CLOUD_ENV_ADMIN_IP_FILTER("CloudEnvAdminIpFilter"),
        CLOUD_TABLEFLOW_APIKEY_FILTER("CloudTableflowApiKeyFilter"),
        CLOUD_TABLEFLOW_CATALOG_INTEGRATION_FILTER("CloudTableflowCatalogIntegrationFilter"),
        CLOUD_TABLEFLOW_FILTER("CloudTableflowFilter"),
        CLOUD_PRINCIPAL_APIKEY_FILTER("CloudPrincipalApiKeyFilter"),
        CLOUD_IDENTITY_POOL_RESOURCE_OWNER_FILTER("CloudIdentityPoolResourceOwnerFilter"),
        CLOUD_CUSTOM_CODE_LOGGING_FILTER("CloudCustomCodeLoggingFilter");

        private final String filterName;

        private FilterNames(String filterName) {
            this.filterName = filterName;
        }

        public String filterName() {
            return this.filterName;
        }
    }
}

