/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.crypto;

import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.crypto.Cryptor;
import io.confluent.kafka.secretregistry.storage.SecretValue;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretTransformer {
    private static final Logger logger = LoggerFactory.getLogger(SecretTransformer.class);
    private final Cryptor cryptor;

    public static SecretTransformer getSecretTransformer(String masterEncryptionKey) {
        return new SecretTransformer(new Cryptor(SecretTransformer.getSecretKey(masterEncryptionKey), SecretTransformer.getProvider(), new SecureRandom()));
    }

    public SecretTransformer(Cryptor cryptor) {
        this.cryptor = cryptor;
    }

    public Secret transform(SecretValue secretValue) {
        if (secretValue == null) {
            return null;
        }
        return new Secret(secretValue.getPath(), secretValue.getKey(), secretValue.getVersion(), new String(this.cryptor.decrypt(secretValue.getEncrypted()), StandardCharsets.UTF_8));
    }

    public SecretValue transform(Secret secretEntity) {
        if (secretEntity == null) {
            return null;
        }
        byte[] bytes = secretEntity.getSecret().getBytes(StandardCharsets.UTF_8);
        return new SecretValue(secretEntity.getPath(), secretEntity.getKey(), secretEntity.getVersion(), this.cryptor.encryptionKeyDerivedFrom(secretEntity.getPath() + "/" + secretEntity.getKey()).encrypt(bytes), this.cryptor.computeHmac(bytes), null, System.currentTimeMillis());
    }

    private static Provider getProvider() {
        BouncyCastleFipsProvider provider = new BouncyCastleFipsProvider();
        if (Security.getProvider(provider.getName()) == null) {
            logger.debug("Registering new crypto provider {}", (Object)provider.getName());
            Security.addProvider((Provider)provider);
        }
        return provider;
    }

    private static SecretKey getSecretKey(String masterKey) {
        return new SecretKeySpec(masterKey.getBytes(StandardCharsets.UTF_8), "AES");
    }
}

