/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.rest;

import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import io.confluent.kafka.secretregistry.rest.SslFactory;
import io.confluent.kafka.secretregistry.rest.extensions.SecretRegistryResourceExtension;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyResource;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyVersionResource;
import io.confluent.kafka.secretregistry.rest.resources.PathResource;
import io.confluent.kafka.secretregistry.rest.resources.RootResource;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.kafka.secretregistry.storage.UriInfo;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.RestConfigException;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretRegistryRestApplication
extends Application<SecretRegistryConfig> {
    private static final Logger log = LoggerFactory.getLogger(SecretRegistryRestApplication.class);
    private KafkaSecretRegistry secretRegistry = null;
    private List<SecretRegistryResourceExtension> secretRegistryResourceExtensions = null;

    public SecretRegistryRestApplication(Properties props) throws RestConfigException {
        this(new SecretRegistryConfig(props));
    }

    public SecretRegistryRestApplication(SecretRegistryConfig config) {
        super((RestConfig)config);
    }

    protected KafkaSecretRegistry initSecretRegistry(SecretRegistryConfig config) {
        KafkaSecretRegistry kafkaSecretRegistry = null;
        try {
            kafkaSecretRegistry = new KafkaSecretRegistry(config);
            kafkaSecretRegistry.initStore();
            UriInfo uriInfo = KafkaSecretRegistry.getUriInfoForIdentity(config.getString("host.name"), config.getInt("port"), config.getList("listeners"), config.interInstanceProtocol());
            kafkaSecretRegistry.initRest(new SslFactory(config), uriInfo);
        }
        catch (SecretRegistryException e) {
            log.error("Error starting the secret registry", (Throwable)e);
            this.onShutdown();
            throw new RuntimeException(e);
        }
        return kafkaSecretRegistry;
    }

    public void setupResources(Configurable<?> config, SecretRegistryConfig secretRegistryConfig) {
        this.secretRegistry = this.initSecretRegistry(secretRegistryConfig);
        this.secretRegistryResourceExtensions = secretRegistryConfig.getConfiguredInstances(secretRegistryConfig.definedResourceExtensionConfigName(), SecretRegistryResourceExtension.class);
        config.register(RootResource.class);
        config.register((Object)new PathResource(this.secretRegistry));
        config.register((Object)new PathKeyResource(this.secretRegistry));
        config.register((Object)new PathKeyVersionResource(this.secretRegistry));
        if (this.secretRegistryResourceExtensions != null) {
            try {
                for (SecretRegistryResourceExtension secretRegistryResourceExtension : this.secretRegistryResourceExtensions) {
                    secretRegistryResourceExtension.register(config, secretRegistryConfig, this.secretRegistry);
                }
            }
            catch (SecretRegistryException e) {
                log.error("Error starting the secret registry", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    protected ResourceCollection getStaticResources() {
        List<String> locations = ((SecretRegistryConfig)this.config).getStaticLocations();
        if (locations != null && !locations.isEmpty()) {
            Resource[] resources = (Resource[])locations.stream().map(Resource::newClassPathResource).toArray(Resource[]::new);
            return new ResourceCollection(resources);
        }
        return super.getStaticResources();
    }

    public void onShutdown() {
        if (this.secretRegistry != null) {
            this.secretRegistry.close();
        }
        if (this.secretRegistryResourceExtensions != null) {
            for (SecretRegistryResourceExtension secretRegistryResourceExtension : this.secretRegistryResourceExtensions) {
                try {
                    secretRegistryResourceExtension.close();
                }
                catch (IOException e) {
                    log.error("Error closing the extension resource", (Throwable)e);
                }
            }
        }
    }

    public KafkaSecretRegistry secretRegistry() {
        return this.secretRegistry;
    }
}

