/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link;

import io.confluent.kafka.link.ClusterLinkApis;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterLinkApisTest {
    private final Map<ApiKeys, Integer> maxVerifiedVersions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)ApiKeys.FETCH, (Object)17), Utils.mkEntry((Object)ApiKeys.LIST_OFFSETS, (Object)9), Utils.mkEntry((Object)ApiKeys.METADATA, (Object)12), Utils.mkEntry((Object)ApiKeys.OFFSET_FETCH, (Object)9), Utils.mkEntry((Object)ApiKeys.FIND_COORDINATOR, (Object)6), Utils.mkEntry((Object)ApiKeys.DESCRIBE_GROUPS, (Object)5), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER, (Object)1), Utils.mkEntry((Object)ApiKeys.LIST_GROUPS, (Object)6), Utils.mkEntry((Object)ApiKeys.SASL_HANDSHAKE, (Object)1), Utils.mkEntry((Object)ApiKeys.API_VERSIONS, (Object)4), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CONFIGS, (Object)4), Utils.mkEntry((Object)ApiKeys.SASL_AUTHENTICATE, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_ACLS, (Object)3), Utils.mkEntry((Object)ApiKeys.OFFSET_FOR_LEADER_EPOCH, (Object)4), Utils.mkEntry((Object)ApiKeys.REPLICA_STATUS, (Object)4), Utils.mkEntry((Object)ApiKeys.CREATE_CLUSTER_LINKS, (Object)4), Utils.mkEntry((Object)ApiKeys.DELETE_CLUSTER_LINKS, (Object)2), Utils.mkEntry((Object)ApiKeys.LIST_CLUSTER_LINKS, (Object)5), Utils.mkEntry((Object)ApiKeys.DESCRIBE_CLUSTER_LINKS, (Object)4), Utils.mkEntry((Object)ApiKeys.INITIATE_REVERSE_CONNECTIONS, (Object)1), Utils.mkEntry((Object)ApiKeys.REVERSE_CONNECTION, (Object)1), Utils.mkEntry((Object)ApiKeys.ALTER_MIRRORS, (Object)10), Utils.mkEntry((Object)ApiKeys.LIST_MIRRORS, (Object)2), Utils.mkEntry((Object)ApiKeys.DESCRIBE_MIRRORS, (Object)9), Utils.mkEntry((Object)ApiKeys.CONSUMER_GROUP_DESCRIBE, (Object)0)});

    @Test
    public void testIsApiAllowedHandlesAllApiVersions() {
        HashSet<ApiKeys> unhandledApis = new HashSet<ApiKeys>();
        HashSet<ApiKeys> unverifiedVersionApis = new HashSet<ApiKeys>();
        for (ApiKeys api : ApiKeys.zkBrokerApis()) {
            try {
                Optional<Integer> maxValidatedVersion;
                if (!ClusterLinkApis.isApiAllowed((ApiKeys)api) || (maxValidatedVersion = Optional.ofNullable(this.maxVerifiedVersions.get(api))).isPresent() && api.latestVersion() <= maxValidatedVersion.get()) continue;
                unverifiedVersionApis.add(api);
            }
            catch (IllegalArgumentException e) {
                unhandledApis.add(api);
            }
        }
        Assertions.assertEquals(Collections.emptySet(), unhandledApis, (String)("The following APIs are not handled: " + unhandledApis));
        Assertions.assertEquals(Collections.emptySet(), unverifiedVersionApis, (String)("The following exposed APIs have unverified version bumps: " + unhandledApis));
    }
}

