/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.SslCertificateManager;
import io.confluent.kafka.multitenant.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslCertificateManagerTest {
    static final long TEST_MAX_WAIT_MS = TimeUnit.SECONDS.toMillis(60L);
    static final String SSL_CERTS_DIR = "mnt/sslcerts/";
    static final String DATA_DIR = "..data";
    static final String BROKER_ID = "0";
    static final URL TEST_ROOT;
    private static final URL TEST_SSL_CERTS_MAY;
    protected static final URL TEST_SSL_CERTS_AUG;
    ConfluentAdmin mockAdminClient;
    SslCertificateManager sslCache;
    String sslCertsPath;
    Path tempDir;
    static MockedStatic<LoggerFactory> loggerFactory;
    static Logger mockLog;

    @BeforeAll
    public static void beforeAll() {
        loggerFactory = Mockito.mockStatic(LoggerFactory.class);
        mockLog = (Logger)Mockito.mock(Logger.class);
        loggerFactory.when(() -> LoggerFactory.getLogger(SslCertificateManager.class)).thenReturn((Object)mockLog);
        loggerFactory.when(() -> LoggerFactory.getLogger(KafkaLogicalClusterMetadata.class)).thenReturn((Object)mockLog);
    }

    @AfterAll
    public static void afterAll() {
        loggerFactory.close();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        System.out.println("root resource: " + TEST_ROOT.getPath());
        Node node = new Node(0, "localhost", 9092);
        this.sslCertsPath = this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "spec.json";
        this.mockAdminClient = (ConfluentAdmin)Mockito.spy((Object)new MockAdminClient(Collections.singletonList(node), node));
        this.sslCache = new SslCertificateManager((Object)BROKER_ID, null, (Object)this.sslCertsPath, s -> this.mockAdminClient, Arrays.asList("EXTERNAL"), this.useBcfks());
    }

    @AfterEach
    public void teardown() {
        this.sslCache.shutdown();
        this.sslCache.close();
    }

    protected boolean useBcfks() {
        return false;
    }

    protected String keyStoreType() {
        return "PKCS12";
    }

    protected void setUpKeyStoreException(MockedStatic<KeyStore> ksFactory, Exception e) {
        ksFactory.when(() -> KeyStore.getInstance(this.keyStoreType())).thenThrow(new Throwable[]{e});
    }

    protected void verifyKeyStoreCall(MockedStatic<KeyStore> ksFactory) {
        ksFactory.verify(() -> KeyStore.getInstance((String)ArgumentMatchers.any()), Mockito.times((int)1));
    }

    @Test
    public void testAdminClientInvokedAfterCertificateSync() throws Exception {
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testCertsCouldNotBeParsed() {
        try (MockedStatic certFactory = Mockito.mockStatic(CertificateFactory.class);
             MockedStatic ksFactory = Mockito.mockStatic(KeyStore.class);){
            CertificateException ce = new CertificateException("something bad");
            certFactory.when(() -> CertificateFactory.getInstance("X509")).thenThrow(new Throwable[]{ce});
            KeyStoreException kse = new KeyStoreException("something worse");
            this.setUpKeyStoreException((MockedStatic<KeyStore>)ksFactory, kse);
            KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
            Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
            this.sslCache.loadSslCertFiles();
            ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
            certFactory.verify(() -> CertificateFactory.getInstance((String)ArgumentMatchers.any()), Mockito.times((int)1));
            this.verifyKeyStoreCall((MockedStatic<KeyStore>)ksFactory);
            ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).error(ArgumentMatchers.contains((String)"X509"), (Throwable)ArgumentMatchers.eq((Object)ce));
            ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).error(ArgumentMatchers.contains((String)this.keyStoreType()), (Throwable)ArgumentMatchers.eq((Object)kse));
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
    }

    @ParameterizedTest
    @CsvSource(value={"false,false", "true,false", "false,true"})
    public void testDynamicConfigsAfterCertificateSync(boolean twoListeners, boolean isController) throws Exception {
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        ArrayList<String> sslListenerNames = new ArrayList<String>();
        sslListenerNames.add("EXTERNAL");
        if (twoListeners) {
            sslListenerNames.add("EXTERNAL_BACKCHANNEL");
        }
        String controllerId = null;
        if (isController) {
            controllerId = BROKER_ID;
        }
        this.sslCache = new SslCertificateManager((Object)BROKER_ID, (Object)controllerId, (Object)this.sslCertsPath, s -> this.mockAdminClient, sslListenerNames, this.useBcfks());
        this.sslCache.loadSslCertFiles();
        ArgumentCaptor configsCaptor = ArgumentCaptor.forClass(Map.class);
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)configsCaptor.capture(), (AlterConfigsOptions)ArgumentMatchers.any());
        Map configs = (Map)configsCaptor.getValue();
        HashSet<String> configNames = new HashSet<String>();
        if (sslListenerNames.isEmpty()) {
            configNames.add("listener.name.external.ssl.keystore.location");
            configNames.add("listener.name.external.ssl.keystore.type");
        } else {
            sslListenerNames.forEach(ln -> {
                String configPrefix = new ListenerName(ln).configPrefix();
                configNames.add(configPrefix + "ssl.keystore.location");
                configNames.add(configPrefix + "ssl.keystore.type");
            });
        }
        Set alterConfigNames = configs.values().stream().flatMap(alterConfigOps -> alterConfigOps.stream()).map(alterConfigOp -> alterConfigOp.configEntry().name()).collect(Collectors.toSet());
        Assertions.assertEquals(configNames, alterConfigNames);
    }

    @Test
    public void testAdminClientNotInvokedWithoutReadPermissionForCerts() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        String fullchainFilepath = this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/" + DATA_DIR + "/fullchain.pem";
        String privkeyFilepath = this.tempDir.toRealPath(new LinkOption[0]) + "/" + SSL_CERTS_DIR + "/" + DATA_DIR + "/privkey.pem";
        Files.setPosixFilePermissions(Paths.get(fullchainFilepath, new String[0]), PosixFilePermissions.fromString("-wx-wx-wx"));
        Files.setPosixFilePermissions(Paths.get(privkeyFilepath, new String[0]), PosixFilePermissions.fromString("-wx-wx-wx"));
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    protected String getSpecFileName() {
        return "spec.json";
    }

    @Test
    public void testAdminClientNotInvokedWithoutSpecFile() throws Exception {
        String specfile = this.getSpecFileName();
        KafkaLogicalClusterUtils.moveFile((String)specfile, (URL)TEST_SSL_CERTS_AUG, (URL)TEST_ROOT);
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.moveFile((String)specfile, (URL)TEST_ROOT, (URL)TEST_SSL_CERTS_AUG);
    }

    protected String getStoreFileName() {
        return "pkcs.p12";
    }

    @Test
    public void testAdminClientNotInvokedWithoutPKCSCertificate() throws Exception {
        String pkcsfile = this.getStoreFileName();
        KafkaLogicalClusterUtils.moveFile((String)pkcsfile, (URL)TEST_SSL_CERTS_AUG, (URL)TEST_ROOT);
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.moveFile((String)pkcsfile, (URL)TEST_ROOT, (URL)TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutPrivkeyPemFile() throws Exception {
        String privkeyfile = "privkey.pem";
        KafkaLogicalClusterUtils.moveFile((String)privkeyfile, (URL)TEST_SSL_CERTS_AUG, (URL)TEST_ROOT);
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_ROOT, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.moveFile((String)privkeyfile, (URL)TEST_ROOT, (URL)TEST_SSL_CERTS_AUG);
    }

    @Test
    public void testAdminClientNotInvokedWithoutFullchainPemFile() throws Exception {
        String fullchainfile = "fullchain.pem";
        KafkaLogicalClusterUtils.moveFile((String)fullchainfile, (URL)TEST_SSL_CERTS_AUG, (URL)TEST_ROOT);
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)0))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.moveFile((String)fullchainfile, (URL)TEST_ROOT, (URL)TEST_SSL_CERTS_AUG);
    }

    private boolean verifyIncerementalAlterConfigsCalls(int wantedNumberOfInvocations) {
        try {
            ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)wantedNumberOfInvocations))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
            return true;
        }
        catch (MockitoAssertionError e) {
            return false;
        }
    }

    @Test
    public void testAdminClientInvocationOnIdenticalSslCertsSync() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.timeout((long)TEST_MAX_WAIT_MS).times(1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
    }

    @Test
    @Disabled(value="Flaky test tracked by KNET-14270")
    public void testAdminClientInvocationOnDifferentSslCertsSync() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> this.verifyIncerementalAlterConfigsCalls(2), (long)TEST_MAX_WAIT_MS, (String)"Should call after sync");
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> this.verifyIncerementalAlterConfigsCalls(3), (long)TEST_MAX_WAIT_MS, (String)"Should call after sync");
    }

    @Test
    @Disabled(value="Flaky test tracked by KNET-14270")
    public void testWatchServiceDoesNotTerminateOnDirectoryDeletion() throws Exception {
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((ConfluentAdmin)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        KafkaLogicalClusterUtils.deleteFiles((Path)this.tempDir, (String)SSL_CERTS_DIR);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_AUG, SSL_CERTS_DIR);
        TestUtils.waitForCondition(() -> this.verifyIncerementalAlterConfigsCalls(2), (long)TEST_MAX_WAIT_MS, (String)"Should call after sync");
    }

    @Test
    public void testAdminClientRecreatedAfterError() throws Exception {
        Admin adminClient = (Admin)Mockito.mock(CloudAdmin.class);
        this.sslCache = new SslCertificateManager((Object)BROKER_ID, null, (Object)this.sslCertsPath, s -> adminClient, Arrays.asList("EXTERNAL"), this.useBcfks());
        AlterConfigsResult result = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        KafkaFuture resultFuture = (KafkaFuture)Mockito.mock(KafkaFuture.class);
        Mockito.when((Object)adminClient.incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Mockito.when((Object)result.all()).thenReturn((Object)resultFuture);
        Mockito.when((Object)resultFuture.get()).thenThrow(new Throwable[]{new ExecutionException((Throwable)new UnknownServerException())}).thenAnswer(invocation -> null);
        Utils.syncCerts(this.tempDir, TEST_SSL_CERTS_MAY, SSL_CERTS_DIR);
        this.sslCache.startWatching();
        this.sslCache.loadSslCertFiles();
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Assertions.assertNull((Object)this.sslCache.getAdminClient());
        this.sslCache.loadSslCertFiles();
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)2))).incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any());
        Assertions.assertNotNull((Object)this.sslCache.getAdminClient());
    }

    static {
        try {
            TEST_ROOT = System.getenv("BAZEL_TEST") != null ? Paths.get(System.getenv("TEST_TMPDIR"), new String[0]).toUri().toURL() : SslCertificateManagerTest.class.getResource("/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            TEST_SSL_CERTS_MAY = JarResourceLoader.loadDirectoryFromResource(SslCertificateManagerTest.class, (String)"/cert_exp_may").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        try {
            TEST_SSL_CERTS_AUG = JarResourceLoader.loadDirectoryFromResource(SslCertificateManagerTest.class, (String)"/cert_exp_aug").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

