/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.TestCluster;
import io.confluent.kafka.multitenant.assignor.ClusterMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.assignor.ZkClusterDescriber;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.DirectoryId;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.placement.CellDescriber;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.TenantDescriber;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterMetadataTest {
    private TestCluster testCluster;
    private Map<Integer, Integer> brokerToCell;
    private CellDescriber cellDescriber = new CellDescriber(){

        public int getBrokerCellId(int brokerId) {
            return ClusterMetadataTest.this.brokerToCell.getOrDefault(brokerId, -1);
        }
    };
    private int tenantCellId;
    private TenantDescriber tenantDescriber = new TenantDescriber(){

        public List<Integer> getTenantCellIds(String tenant) {
            return Collections.singletonList(ClusterMetadataTest.this.tenantCellId);
        }
    };

    @BeforeEach
    public void setUp() {
        this.testCluster = new TestCluster();
        this.brokerToCell = new HashMap<Integer, Integer>();
        this.tenantCellId = -1;
    }

    private ClusterMetadata clusterMetadata(String tenant, Cluster cluster) {
        return new ClusterMetadata(tenant, (ClusterDescriber)new ZkClusterDescriber(cluster, this.cellDescriber, this.tenantDescriber), Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE);
    }

    private ClusterMetadata clusterMetadata(String tenant, Cluster cluster, PartitionPlacementStrategy placement) {
        return new ClusterMetadata(tenant, (ClusterDescriber)new ZkClusterDescriber(cluster, this.cellDescriber, this.tenantDescriber), Collections.emptySet(), placement);
    }

    @Test
    public void testExcludedBrokers() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        List<Integer> excludedBrokers = Arrays.asList(1, 2);
        List<Integer> eligibleBrokers = Arrays.asList(0, 3, 4);
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", (ClusterDescriber)new ZkClusterDescriber(this.testCluster.cluster(), this.cellDescriber, this.tenantDescriber), new HashSet<Integer>(excludedBrokers), PartitionPlacementStrategy.CLUSTER_WIDE);
        for (Integer eligibleBroker : eligibleBrokers) {
            Assertions.assertTrue((boolean)clusterMetadata.isBrokerEligibleForReplicaPlacement(eligibleBroker.intValue()), (String)"Expected non-excluded broker to be eligible for replica placement");
        }
        for (Integer excludedBroker : excludedBrokers) {
            Assertions.assertFalse((boolean)clusterMetadata.isBrokerEligibleForReplicaPlacement(excludedBroker.intValue()), (String)"Expected excluded broker to NOT be eligible for replica placement");
        }
        Assertions.assertEquals(new HashSet<Integer>(eligibleBrokers), (Object)clusterMetadata.eligibleBrokers());
        Assertions.assertEquals(new HashSet<Integer>(excludedBrokers), (Object)clusterMetadata.excludedBrokerIds());
    }

    @Test
    public void testRackAwareNoRacks() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertFalse((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testCellAwareNoCells() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertFalse((boolean)clusterMetadata.partitionCellAware(), (String)"Expected the cluster metadata to not be cell aware when no cells exist");
    }

    @Test
    public void testPartitionCellAware() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        this.testCluster.addNode(5, null);
        this.testCluster.addNode(6, null);
        this.brokerToCell.put(0, 1);
        this.brokerToCell.put(1, 1);
        this.brokerToCell.put(2, 2);
        this.brokerToCell.put(3, 2);
        this.brokerToCell.put(4, 3);
        this.brokerToCell.put(5, 3);
        this.tenantCellId = -1;
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster(), PartitionPlacementStrategy.PARTITION_IN_CELL);
        Assertions.assertTrue((boolean)clusterMetadata.partitionCellAware(), (String)"Expected the cluster metadata to be cell aware");
        Assertions.assertTrue((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(1)), (String)"Expected brokers to be in the same cell");
        Assertions.assertFalse((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(2)), (String)"Expected brokers in different cells to NOT be in the same cell");
        Assertions.assertEquals((int)1, (int)clusterMetadata.cellForBroker(1));
        Assertions.assertEquals((int)3, (int)clusterMetadata.cellForBroker(5));
        Assertions.assertEquals((int)-1, (int)clusterMetadata.cellForBroker(6));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1)), (Object)clusterMetadata.eligibleBrokersFromCell(1));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(4, 5)), (Object)clusterMetadata.eligibleBrokersFromCell(3));
        Assertions.assertEquals(new HashSet(), (Object)clusterMetadata.eligibleBrokersFromCell(6));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6)), (Object)clusterMetadata.eligibleBrokers());
    }

    @Test
    public void testTenantCellAware() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        this.testCluster.addNode(5, null);
        this.brokerToCell.put(0, 1);
        this.brokerToCell.put(1, 1);
        this.brokerToCell.put(2, 2);
        this.brokerToCell.put(3, 2);
        this.brokerToCell.put(4, 3);
        this.brokerToCell.put(5, 3);
        this.tenantCellId = 1;
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster(), PartitionPlacementStrategy.TENANT_IN_CELL);
        Assertions.assertTrue((boolean)clusterMetadata.tenantCellAware(), (String)"Expected the cluster metadata to be tenant cell aware");
        Assertions.assertFalse((boolean)clusterMetadata.partitionCellAware(), (String)"Expected the cluster metadata to not be partition cell aware");
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1)), (Object)clusterMetadata.eligibleBrokers());
        Assertions.assertTrue((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(1)), (String)"Expected brokers to be in the same cell");
        Assertions.assertFalse((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(2)), (String)"Expected brokers in different cells to NOT be in the same cell");
        Assertions.assertEquals((int)1, (int)clusterMetadata.cellForBroker(1));
        Assertions.assertEquals((int)3, (int)clusterMetadata.cellForBroker(5));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1)), (Object)clusterMetadata.eligibleBrokersFromCell(1));
        Assertions.assertEquals(new HashSet(), (Object)clusterMetadata.eligibleBrokersFromCell(3));
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(0, 1)), (Object)clusterMetadata.eligibleBrokers());
    }

    @Test
    public void testTenantCellAwareTenantNotAssignedCell() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        this.testCluster.addNode(5, null);
        this.brokerToCell.put(0, 1);
        this.brokerToCell.put(1, 1);
        this.brokerToCell.put(2, 2);
        this.tenantCellId = -1;
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster(), PartitionPlacementStrategy.TENANT_IN_CELL);
        Assertions.assertTrue((boolean)clusterMetadata.tenantCellAware(), (String)"Expected the cluster metadata to be tenant cell aware");
        Assertions.assertFalse((boolean)clusterMetadata.partitionCellAware(), (String)"Expected the cluster metadata to not be partition cell aware");
        Assertions.assertEquals(new HashSet(), (Object)clusterMetadata.eligibleBrokers());
    }

    @Test
    public void testTenantCellAwareExcludedBrokers() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        this.testCluster.addNode(5, null);
        this.brokerToCell.put(0, 1);
        this.brokerToCell.put(1, 1);
        this.brokerToCell.put(2, 2);
        this.tenantCellId = 1;
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", (ClusterDescriber)new ZkClusterDescriber(this.testCluster.cluster(), this.cellDescriber, this.tenantDescriber), new HashSet<Integer>(Arrays.asList(0, 1, 2, 4)), PartitionPlacementStrategy.TENANT_IN_CELL);
        Assertions.assertTrue((boolean)clusterMetadata.tenantCellAware(), (String)"Expected the cluster metadata to be tenant cell aware");
        Assertions.assertFalse((boolean)clusterMetadata.partitionCellAware(), (String)"Expected the cluster metadata to not be partition cell aware");
        Assertions.assertEquals(new HashSet(), (Object)clusterMetadata.eligibleBrokers());
    }

    @Test
    public void testCellAwareExclusion() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        this.testCluster.addNode(3, null);
        this.testCluster.addNode(4, null);
        this.testCluster.addNode(5, null);
        this.brokerToCell.put(0, 1);
        this.brokerToCell.put(1, 1);
        this.brokerToCell.put(2, 2);
        this.brokerToCell.put(3, 2);
        this.brokerToCell.put(4, 3);
        this.brokerToCell.put(5, 3);
        this.tenantCellId = -1;
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", (ClusterDescriber)new ZkClusterDescriber(this.testCluster.cluster(), this.cellDescriber, this.tenantDescriber), new HashSet<Integer>(Arrays.asList(0, 2, 4)), PartitionPlacementStrategy.PARTITION_IN_CELL);
        Assertions.assertTrue((boolean)clusterMetadata.partitionCellAware(), (String)"Expected the cluster metadata to be cell aware");
        Assertions.assertTrue((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(1)), (String)"Expected brokers to be in the same cell");
        Assertions.assertFalse((boolean)clusterMetadata.brokersInSameCell(Integer.valueOf(0), Integer.valueOf(2)), (String)"Expected brokers in different cells to NOT be in the same cell");
        Assertions.assertEquals((int)1, (int)clusterMetadata.cellForBroker(0));
        Assertions.assertEquals((int)2, (int)clusterMetadata.cellForBroker(2));
        Assertions.assertEquals(new HashSet<Integer>(Collections.singletonList(1)), (Object)clusterMetadata.eligibleBrokersFromCell(1));
        Assertions.assertEquals(new HashSet<Integer>(Collections.singletonList(3)), (Object)clusterMetadata.eligibleBrokersFromCell(2));
        Assertions.assertEquals(new HashSet<Integer>(Collections.singletonList(5)), (Object)clusterMetadata.eligibleBrokersFromCell(3));
    }

    @Test
    public void testRackAwareOneBrokerHasRack() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, "rack1");
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertFalse((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testRackAwareAllBrokersHasRack() {
        this.testCluster.addNode(0, "rack1");
        this.testCluster.addNode(1, "rack2");
        this.testCluster.addNode(2, "rack3");
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertTrue((boolean)clusterMetadata.rackAware());
    }

    @Test
    public void testNodeReplicaCountsOfflineBrokers() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 3), this.immutableList(2, 3, 0), this.immutableList(3, 0, 1));
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        String topic2 = "tenant2_topicA";
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        this.testCluster.createPartitions("tenant2_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster(true));
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounts = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.leaderCount((int)3).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.leaderCount((int)3).topic);
        Assertions.assertEquals((int)1, (int)nodeReplicaCounts.leaderCount((int)3).tenant);
        Assertions.assertEquals((int)4, (int)nodeReplicaCounts.followerCount((int)3).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.followerCount((int)3).topic);
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.followerCount((int)3).tenant);
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.leaderCount((int)1).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.leaderCount((int)2).topic);
        Assertions.assertEquals((int)1, (int)nodeReplicaCounts.leaderCount((int)0).tenant);
        Assertions.assertEquals((int)4, (int)nodeReplicaCounts.followerCount((int)0).total);
        Assertions.assertEquals((int)0, (int)nodeReplicaCounts.followerCount((int)1).topic);
        Assertions.assertEquals((int)2, (int)nodeReplicaCounts.followerCount((int)2).tenant);
    }

    @Test
    public void testNodeReplicaCountsNoTopics() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        ClusterMetadata.ReplicaCounts zeroReplicaCounts = new ClusterMetadata.ReplicaCounts(0, 0);
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.leaderCount(2));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)zeroReplicaCounts, (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsOneTenantTopic() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        ClusterMetadata.ReplicaCounts expectedLeaderCounts = new ClusterMetadata.ReplicaCounts(1, 1);
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(2));
        ClusterMetadata.ReplicaCounts expectedFollowerCounts = new ClusterMetadata.ReplicaCounts(2, 2);
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsMultipleTenants() {
        String tenant1 = "tenant1";
        String topic1 = "tenant1_topicA";
        String topic2 = "tenant2_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        this.testCluster.createPartitions("tenant2_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        ClusterMetadata.ReplicaCounts expectedLeaderCounts = new ClusterMetadata.ReplicaCounts(1, 2);
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)expectedLeaderCounts, (Object)nodeReplicaCounter.leaderCount(2));
        ClusterMetadata.ReplicaCounts expectedFollowerCounts = new ClusterMetadata.ReplicaCounts(2, 4);
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)expectedFollowerCounts, (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsForOneExistingTenantTopic() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0), this.immutableList(2, 0, 1), this.immutableList(0, 1, 2));
        this.testCluster.createPartitions("tenant1_topicA", 0, assignment);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        ClusterMetadata.NodeReplicaCounter replicaCounter = clusterMetadata.nodeReplicaCounts(ZkClusterDescriber.partitionInfosToReplicas((List)this.testCluster.cluster().partitionsForTopic("tenant1_topicA")));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), (Object)replicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), (Object)replicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), (Object)replicaCounter.leaderCount(2));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), (Object)replicaCounter.followerCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(3, 3, 3), (Object)replicaCounter.followerCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(3, 3, 3), (Object)replicaCounter.followerCount(2));
    }

    @Test
    public void testNodeReplicaCountsForUnregisteredBrokers() {
        String tenant = "tenant1";
        String topic = "tenant1_topicA";
        final List<List> topicReplicas = Arrays.asList(Arrays.asList(0, 1, 2), Arrays.asList(0, 1, 2), Arrays.asList(2, 0, 1));
        ClusterDescriber describer = new ClusterDescriber(){

            public Iterator<UsableBroker> usableBrokers() {
                return Arrays.asList(new UsableBroker(0, Optional.empty(), false), new UsableBroker(1, Optional.empty(), false)).iterator();
            }

            public Iterator<String> topicNames() {
                return Arrays.asList("tenant1_topicA").iterator();
            }

            public List<List<Integer>> replicasForTopicName(String topicName) {
                if (topicName.equals("tenant1_topicA")) {
                    return topicReplicas;
                }
                return Collections.emptyList();
            }

            public Uuid defaultDir(int brokerId) {
                return DirectoryId.MIGRATING;
            }
        };
        ClusterMetadata clusterMetadata = new ClusterMetadata("tenant1", describer, Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE);
        ClusterMetadata.NodeReplicaCounter replicaCounter = clusterMetadata.nodeReplicaCounts(topicReplicas);
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2, 2), (Object)replicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(0, 0, 0), (Object)replicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1, 1), (Object)replicaCounter.leaderCount(2));
    }

    @Test
    public void testUpdateNodeMetadataWithInvalidAssignment() {
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        Assertions.assertThrows(IllegalStateException.class, () -> clusterMetadata.updateNodeMetadata(this.immutableList(this.immutableList(0, 1, 2))), (String)"Expected updateNodeMetadata() to throw IllegalStateException");
    }

    @Test
    public void testUpdateNodeMetadata() {
        String tenant = "tenant1";
        this.testCluster.addNode(0, null);
        this.testCluster.addNode(1, null);
        this.testCluster.addNode(2, null);
        List<List<Integer>> assignment = this.immutableList(this.immutableList(0, 1, 2), this.immutableList(1, 2, 0));
        ClusterMetadata clusterMetadata = this.clusterMetadata("tenant1", this.testCluster.cluster());
        clusterMetadata.updateNodeMetadata(assignment);
        ClusterMetadata.NodeReplicaCounter nodeReplicaCounter = clusterMetadata.nodeReplicaCounts(Collections.emptyList());
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.leaderCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.leaderCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(0, 0), (Object)nodeReplicaCounter.leaderCount(2));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.followerCount(0));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(1, 1), (Object)nodeReplicaCounter.followerCount(1));
        Assertions.assertEquals((Object)new ClusterMetadata.ReplicaCounts(2, 2), (Object)nodeReplicaCounter.followerCount(2));
    }

    @Test
    public void testReplicaCountsComparison() {
        ClusterMetadata.ReplicaCounts counts0 = new ClusterMetadata.ReplicaCounts(1, 2, 4);
        ClusterMetadata.ReplicaCounts counts1 = new ClusterMetadata.ReplicaCounts(1, 2, 3);
        ClusterMetadata.ReplicaCounts counts2 = new ClusterMetadata.ReplicaCounts(1, 4, 3);
        ClusterMetadata.ReplicaCounts counts3 = new ClusterMetadata.ReplicaCounts(3, 2, 3);
        ClusterMetadata.ReplicaCounts counts4 = new ClusterMetadata.ReplicaCounts(4, 5, 3);
        ClusterMetadata.ReplicaCounts counts5 = new ClusterMetadata.ReplicaCounts(4, 5, 3);
        Assertions.assertTrue((counts0.compareTo(counts1) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((counts0.compareTo(counts2) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((counts4.compareTo(counts3) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((counts3.compareTo(counts2) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)counts5.compareTo(counts4));
        Assertions.assertTrue((counts5.compareTo(counts0) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaCountsCompareToThrowsExceptionForNullParameter() {
        ClusterMetadata.ReplicaCounts counts = new ClusterMetadata.ReplicaCounts(1, 2, 4);
        Assertions.assertThrows(NullPointerException.class, () -> counts.compareTo(null), (String)"Expected updateNodeMetadata() to throw IllegalStateException");
    }

    private List<Integer> immutableList(Integer ... numbers) {
        return Collections.unmodifiableList(Arrays.asList(numbers));
    }

    @SafeVarargs
    private final List<List<Integer>> immutableList(List<Integer> ... lists) {
        return Collections.unmodifiableList(Arrays.asList(lists));
    }

    @Test
    public void testFencedBrokersAreExcluded() {
        final List<UsableBroker> brokers = Arrays.asList(new UsableBroker(0, Optional.empty(), true), new UsableBroker(1, Optional.empty(), false), new UsableBroker(2, Optional.empty(), true), new UsableBroker(3, Optional.empty(), false));
        ClusterDescriber describer = new ClusterDescriber(){

            public Iterator<UsableBroker> usableBrokers() {
                return brokers.iterator();
            }

            public Iterator<String> topicNames() {
                return Collections.emptyList().iterator();
            }

            public List<List<Integer>> replicasForTopicName(String topicName) {
                return Collections.emptyList();
            }

            public Uuid defaultDir(int brokerId) {
                return DirectoryId.MIGRATING;
            }
        };
        ClusterMetadata clusterMetadata = new ClusterMetadata("foo", describer, Collections.emptySet(), PartitionPlacementStrategy.CLUSTER_WIDE);
        Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(1, 3)), (Object)clusterMetadata.eligibleBrokers());
        Assertions.assertEquals(new HashSet(), (Object)clusterMetadata.excludedBrokerIds());
    }
}

