/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.authorizer;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.authorizer.TenantAclProvider;
import io.confluent.kafka.multitenant.metrics.HotPartitionManager;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MultiTenantAuthorizerKraftUnitTest {
    MultiTenantAuthorizerKraftUnitTest() {
    }

    @AfterAll
    public static void verifyUnexpected() {
        KafkaTestUtils.verifyThreadCleanup();
    }

    @Test
    public void testKRaftProviderIgnoredIfMultiTenantProviderPresent() {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        Endpoint endpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        List<ConfluentBuiltInProviders.AccessRuleProviders> providers = Arrays.asList(ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT, ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL);
        Map<String, Object> configs = this.kraftBrokerConfig(brokerId, endpoint, providers);
        MultiTenantAuthorizer authorizer = new MultiTenantAuthorizer();
        authorizer.configure(configs);
        authorizer.start((AuthorizerServerInfo)this.serverInfo(clusterId, brokerId, endpoint)).values().forEach(future -> {
            Void cfr_ignored_0 = (Void)future.toCompletableFuture().join();
        });
        authorizer.completeInitialLoad();
        List accessRuleProviders = authorizer.accessRuleProviders();
        Assertions.assertEquals((int)1, (int)accessRuleProviders.size());
        Assertions.assertTrue((boolean)(accessRuleProviders.get(0) instanceof TenantAclProvider));
    }

    @Test
    public void testAclCreationReturnsNotControllerIfNoAclMutator() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, (KafkaPrincipal)tenantPrincipal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, logicalClusterId + "_foo", PatternType.LITERAL);
        AccessControlEntry accessControlEntry = new AccessControlEntry("TenantUser:" + logicalClusterId + "_bob", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        Assertions.assertThrows(NotControllerException.class, () -> authorizer.createAcls(requestContext, Collections.singletonList(aclBinding)));
    }

    @Test
    public void testAclResourcesMustBeTenantPrefixed() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, (KafkaPrincipal)tenantPrincipal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        AccessControlEntry accessControlEntry = new AccessControlEntry("TenantUser:" + logicalClusterId + "_bob", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        Assertions.assertThrows(InvalidRequestException.class, () -> authorizer.createAcls(requestContext, Collections.singletonList(aclBinding)));
    }

    @Test
    public void testAclPrincipalsMustBeTenantPrefixed() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, (KafkaPrincipal)tenantPrincipal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, logicalClusterId + "_foo", PatternType.LITERAL);
        AccessControlEntry accessControlEntry = new AccessControlEntry("TenantUser:bob", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        Assertions.assertThrows(InvalidRequestException.class, () -> authorizer.createAcls(requestContext, Collections.singletonList(aclBinding)));
    }

    @Test
    public void testAclPrincipalsMustHaveTenantUserPrincipalType() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, (KafkaPrincipal)tenantPrincipal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, logicalClusterId + "_foo", PatternType.LITERAL);
        AccessControlEntry accessControlEntry = new AccessControlEntry("User:bob", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        Assertions.assertThrows(InvalidRequestException.class, () -> authorizer.createAcls(requestContext, Collections.singletonList(aclBinding)));
    }

    @Test
    public void testAclDeletionReturnsNotControllerIfNoAclMutator() throws Exception {
        String clusterId = Uuid.randomUuid().toString();
        int brokerId = 0;
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.DELETE_ACLS, (KafkaPrincipal)tenantPrincipal);
        ResourcePatternFilter topicResourceFilter = new ResourcePatternFilter(ResourceType.TOPIC, logicalClusterId + "_foo", PatternType.LITERAL);
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(this.tenantWildcardPrincipal(logicalClusterId).toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(topicResourceFilter, accessControlEntryFilter);
        Assertions.assertThrows(NotControllerException.class, () -> authorizer.deleteAcls(requestContext, Collections.singletonList(aclBindingFilter)));
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED"})
    public void testAclCreationWithKafkaPrincipal(Errors error) throws Exception {
        KafkaPrincipal principal = new KafkaPrincipal("User", "foo");
        this.testAclCreation(principal, "__consumer_offsets", error);
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED"})
    public void testAclCreationWithMultiTenantPrincipal(Errors error) throws Exception {
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        this.testAclCreation((KafkaPrincipal)tenantPrincipal, logicalClusterId + "_foo", error);
    }

    private void testAclCreation(KafkaPrincipal principal, String literalTopicName, Errors error) throws Exception {
        int brokerId = 0;
        String clusterId = Uuid.randomUuid().toString();
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        AclMutator aclMutator = (AclMutator)Mockito.mock(AclMutator.class);
        authorizer.setAclMutator(aclMutator);
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, principal);
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, literalTopicName, PatternType.LITERAL);
        KafkaPrincipal basePrincipal = AccessRule.asBaseKafkaPrincipal((KafkaPrincipal)principal);
        AccessControlEntry accessControlEntry = new AccessControlEntry(basePrincipal.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBinding aclBinding = new AclBinding(topicResource, accessControlEntry);
        CompletableFuture<List<AclCreateResult>> createAclFuture = new CompletableFuture<List<AclCreateResult>>();
        Mockito.when((Object)aclMutator.createAcls((ControllerRequestContext)ArgumentMatchers.any(ControllerRequestContext.class), (List)ArgumentMatchers.eq(Collections.singletonList(aclBinding)), (AclState)ArgumentMatchers.any(AclState.class))).thenReturn(createAclFuture);
        List createAclRequestFutures = authorizer.createAcls(requestContext, Collections.singletonList(aclBinding));
        Assertions.assertEquals((int)1, (int)createAclRequestFutures.size());
        CompletableFuture createAclRequestFuture = ((CompletionStage)createAclRequestFutures.get(0)).toCompletableFuture();
        Assertions.assertFalse((boolean)createAclRequestFuture.isDone());
        if (error == Errors.NONE) {
            createAclFuture.complete(Collections.singletonList(AclCreateResult.SUCCESS));
            Assertions.assertTrue((boolean)createAclRequestFuture.isDone());
            Assertions.assertFalse((boolean)createAclRequestFuture.isCompletedExceptionally());
            Assertions.assertSame((Object)AclCreateResult.SUCCESS, createAclRequestFuture.get());
        } else {
            ApiException expectedException = error.exception();
            createAclFuture.completeExceptionally((Throwable)error.exception());
            Assertions.assertTrue((boolean)createAclRequestFuture.isDone());
            Assertions.assertFalse((boolean)createAclRequestFuture.isCompletedExceptionally());
            AclCreateResult result = (AclCreateResult)createAclRequestFuture.get();
            Assertions.assertEquals(Optional.of(expectedException), (Object)result.exception());
        }
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED"})
    public void testAclDeletionWithKafkaPrincipal(Errors error) throws Exception {
        KafkaPrincipal principal = new KafkaPrincipal("User", "joe");
        this.testAclDeletion(principal, "__consumer_offsets", error);
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"NONE", "CLUSTER_AUTHORIZATION_FAILED"})
    public void testAclDeletionWithMultiTenantPrincipal(Errors error) throws Exception {
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        this.testAclDeletion((KafkaPrincipal)tenantPrincipal, logicalClusterId + "_foo", error);
    }

    private void testAclDeletion(KafkaPrincipal principal, String literalTopicName, Errors error) throws Exception {
        int brokerId = 0;
        String clusterId = Uuid.randomUuid().toString();
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        AclMutator aclMutator = (AclMutator)Mockito.mock(AclMutator.class);
        authorizer.setAclMutator(aclMutator);
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, principal);
        ResourcePatternFilter topicResourceFilter = new ResourcePatternFilter(ResourceType.TOPIC, literalTopicName, PatternType.LITERAL);
        KafkaPrincipal basePrincipal = AccessRule.asBaseKafkaPrincipal((KafkaPrincipal)principal);
        AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(basePrincipal.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AclBindingFilter aclBindingFilter = new AclBindingFilter(topicResourceFilter, accessControlEntryFilter);
        CompletableFuture<List<AclDeleteResult>> deleteAclFuture = new CompletableFuture<List<AclDeleteResult>>();
        Mockito.when((Object)aclMutator.deleteAcls((ControllerRequestContext)ArgumentMatchers.any(ControllerRequestContext.class), (List)ArgumentMatchers.eq(Collections.singletonList(aclBindingFilter)), (AclState)ArgumentMatchers.any(AclState.class))).thenReturn(deleteAclFuture);
        List deleteAclsRequestFutures = authorizer.deleteAcls(requestContext, Collections.singletonList(aclBindingFilter));
        Assertions.assertEquals((int)1, (int)deleteAclsRequestFutures.size());
        CompletableFuture deleteAclsRequestFuture = ((CompletionStage)deleteAclsRequestFutures.get(0)).toCompletableFuture();
        Assertions.assertFalse((boolean)deleteAclsRequestFuture.isDone());
        if (error == Errors.NONE) {
            AclBinding deletedAclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, literalTopicName, PatternType.LITERAL), new AccessControlEntry(AccessRule.WILDCARD_USER_PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
            AclDeleteResult expectedResult = new AclDeleteResult(Collections.singletonList(new AclDeleteResult.AclBindingDeleteResult(deletedAclBinding)));
            deleteAclFuture.complete(Collections.singletonList(expectedResult));
            Assertions.assertTrue((boolean)deleteAclsRequestFuture.isDone());
            Assertions.assertFalse((boolean)deleteAclsRequestFuture.isCompletedExceptionally());
            Assertions.assertEquals((Object)expectedResult, deleteAclsRequestFuture.get());
        } else {
            ApiException expectedException = error.exception();
            deleteAclFuture.completeExceptionally((Throwable)error.exception());
            Assertions.assertTrue((boolean)deleteAclsRequestFuture.isDone());
            Assertions.assertFalse((boolean)deleteAclsRequestFuture.isCompletedExceptionally());
            AclDeleteResult result = (AclDeleteResult)deleteAclsRequestFuture.get();
            Assertions.assertEquals(Optional.of(expectedException), (Object)result.exception());
        }
    }

    @Test
    public void testTenantAuthorization() throws Exception {
        this.testTenantAuthorization(Optional.empty(), Optional.empty());
        this.testTenantAuthorization(Optional.of(Uuid.fromString((String)"dcEAXr6wSNCcHQeFCesKMA")), Optional.of(Uuid.fromString((String)"KLT_4kq7Qy66HZsBiL57HA")));
        Optional<Uuid> sameLink = Optional.of(Uuid.fromString((String)"M1cUxZhLRY22D6YadqedfQ"));
        this.testTenantAuthorization(sameLink, sameLink);
    }

    private void testTenantAuthorization(Optional<Uuid> linkId1, Optional<Uuid> linkId2) throws Exception {
        int brokerId = 0;
        String clusterId = Uuid.randomUuid().toString();
        MultiTenantAuthorizer authorizer = this.createAndStartBrokerAuthorizer(clusterId, brokerId);
        AclMutator aclMutator = (AclMutator)Mockito.mock(AclMutator.class);
        authorizer.setAclMutator(aclMutator);
        String logicalClusterId = "lkc-12345";
        MultiTenantPrincipal tenantPrincipal = this.tenantPrincipal(logicalClusterId, logicalClusterId + "_bob");
        ResourcePattern topicResource = new ResourcePattern(ResourceType.TOPIC, "lkc-12345-foo", PatternType.LITERAL);
        authorizer.completeInitialLoad();
        authorizer.applyAclChanges(Collections.singletonMap(Uuid.randomUuid(), Optional.of(new ConfluentStandardAcl(new StandardAcl(topicResource.resourceType(), topicResource.name(), topicResource.patternType(), this.tenantWildcardPrincipal(logicalClusterId).toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW), linkId1))));
        authorizer.applyAclChanges(Collections.singletonMap(Uuid.randomUuid(), Optional.of(new ConfluentStandardAcl(new StandardAcl(topicResource.resourceType(), topicResource.name(), topicResource.patternType(), this.tenantUserPrincipal(tenantPrincipal).toString(), "*", AclOperation.READ, AclPermissionType.ALLOW), linkId2))));
        AuthorizableRequestContext requestContext = this.sampleRequestContext(ApiKeys.CREATE_ACLS, (KafkaPrincipal)tenantPrincipal);
        Action describeAction = new Action(AclOperation.DESCRIBE, topicResource, 1, true, true);
        Action readAction = new Action(AclOperation.READ, topicResource, 1, true, true);
        Action writeAction = new Action(AclOperation.WRITE, topicResource, 1, true, true);
        Assertions.assertEquals(Arrays.asList(AuthorizationResult.ALLOWED, AuthorizationResult.ALLOWED, AuthorizationResult.DENIED), (Object)authorizer.authorize(requestContext, Arrays.asList(describeAction, readAction, writeAction)));
    }

    private KafkaPrincipal tenantWildcardPrincipal(String logicalClusterId) {
        return new KafkaPrincipal("TenantUser*", logicalClusterId + "_");
    }

    private KafkaPrincipal tenantUserPrincipal(MultiTenantPrincipal principal) {
        return new KafkaPrincipal("TenantUser", principal.getName());
    }

    private MultiTenantPrincipal tenantPrincipal(String logicalClusterId, String userId) {
        TenantMetadata tenantMetadata = new TenantMetadata.Builder(logicalClusterId, userId).build();
        return new MultiTenantPrincipal(userId, tenantMetadata);
    }

    private AuthorizableRequestContext sampleRequestContext(ApiKeys apiKey, KafkaPrincipal principal) throws Exception {
        if (principal instanceof MultiTenantPrincipal) {
            MockTime time = new MockTime();
            return new MultiTenantRequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), "ClientId", 0), "localhost:92342", -1L, InetAddress.getLocalHost(), Optional.empty(), (MultiTenantPrincipal)principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, (Time)time, new Metrics(), new TenantMetrics(), MultiTenantAuthorizerKraftUnitTest.createHotPartitionManager((Time)time), MultiTenantInterceptorConfig.DEFAULT, Optional.empty(), false, Optional.empty(), null, null, false, null);
        }
        return new RequestContext(new RequestHeader(apiKey, apiKey.latestVersion(), "ClientId", 0), "localhost:92342", InetAddress.getLocalHost(), principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
    }

    private static HotPartitionManager createHotPartitionManager(Time time) {
        HotPartitionManager hotPartitionManager = new HotPartitionManager(time);
        HashMap<String, Number> hotPartitionManagerConfig = new HashMap<String, Number>();
        hotPartitionManagerConfig.put("confluent.broker.limit.producer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_PRODUCER_DEFAULT);
        hotPartitionManagerConfig.put("confluent.broker.limit.consumer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_CONSUMER_DEFAULT);
        hotPartitionManagerConfig.put("confluent.hot.partition.ratio", 0.8);
        hotPartitionManager.configure(hotPartitionManagerConfig);
        return hotPartitionManager;
    }

    private MultiTenantAuthorizer createAndStartBrokerAuthorizer(String clusterId, int brokerId) {
        Endpoint endpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 9092);
        Map<String, Object> configs = this.kraftBrokerConfig(brokerId, endpoint, Collections.singletonList(ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT));
        MultiTenantAuthorizer authorizer = new MultiTenantAuthorizer();
        authorizer.configure(configs);
        authorizer.start((AuthorizerServerInfo)this.serverInfo(clusterId, brokerId, endpoint));
        authorizer.completeInitialLoad();
        return authorizer;
    }

    private Map<String, Object> kraftBrokerConfig(int brokerId, Endpoint endpoint, List<ConfluentBuiltInProviders.AccessRuleProviders> providers) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("controller.listener.names", "CONTROLLER");
        configs.put("process.roles", "broker");
        configs.put("controller.quorum.voters", "10@localhost:8092");
        configs.put("node.id", brokerId + "");
        configs.put("listeners", "PLAINTEXT://" + endpoint.host() + ":" + endpoint.port());
        configs.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        configs.put("confluent.multitenant.listener.names", "EXTERNAL");
        String providerString = providers.stream().map(Enum::name).collect(Collectors.joining(","));
        configs.put("confluent.authorizer.access.rule.providers", providerString);
        return configs;
    }

    private ConfluentAuthorizerServerInfo serverInfo(final String clusterId, final int brokerId, final Endpoint endpoint) {
        return new ConfluentAuthorizerServerInfo(){

            public ClusterResource clusterResource() {
                return new ClusterResource(clusterId);
            }

            public int brokerId() {
                return brokerId;
            }

            public Collection<Endpoint> endpoints() {
                return Collections.singleton(endpoint);
            }

            public Endpoint interBrokerEndpoint() {
                return endpoint;
            }

            public Collection<String> earlyStartListeners() {
                return Collections.emptyList();
            }

            public Metrics metrics() {
                return new Metrics();
            }

            public Map<String, ?> interBrokerClientConfig() {
                return Collections.singletonMap("bootstrap.servers", "localhost:" + endpoint.port());
            }
        };
    }
}

