/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.cluster;

import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.TestPlainSaslAuthenticator;
import io.confluent.kafka.multitenant.integration.cluster.UserMetadata;
import java.util.HashMap;
import java.util.Map;

public class LogicalCluster {
    private final String logicalClusterId;
    private final PhysicalCluster physicalCluster;
    private final Map<Integer, LogicalClusterUser> users;
    private final LogicalClusterUser adminUser;
    private String orgId;
    private String envId;

    public LogicalCluster(PhysicalCluster physicalCluster, String logicalClusterId, UserMetadata adminUser) {
        this(physicalCluster, logicalClusterId, null, null, adminUser);
    }

    public LogicalCluster(PhysicalCluster physicalCluster, String logicalClusterId, String orgId, String envId, UserMetadata adminUser) {
        this.physicalCluster = physicalCluster;
        this.logicalClusterId = logicalClusterId;
        this.users = new HashMap<Integer, LogicalClusterUser>();
        this.adminUser = this.addUser(adminUser);
        this.orgId = orgId;
        this.envId = envId;
    }

    public final synchronized LogicalClusterUser addUser(UserMetadata user) {
        int userId = user.userId();
        if (this.users.containsKey(userId)) {
            throw new IllegalArgumentException("User " + userId + " already exists in logical cluster");
        }
        LogicalClusterUser logicalClusterUser = new LogicalClusterUser(user, this.logicalClusterId);
        this.users.put(userId, logicalClusterUser);
        this.physicalCluster.addScramUser(logicalClusterUser.saslUserName(), user.apiSecret());
        this.physicalCluster.brokerSessionUuids().forEach(brokerSessionUuid -> TestPlainSaslAuthenticator.addUser(brokerSessionUuid, user, this.logicalClusterId));
        return logicalClusterUser;
    }

    public synchronized void removeUser(int userId) {
        this.users.remove(userId);
    }

    public synchronized void deleteUserCredential(LogicalClusterUser user) {
        int userId = user.userMetadata.userId();
        this.removeUser(userId);
        this.physicalCluster.deleteScramUser(user.saslUserName());
        this.physicalCluster.brokerSessionUuids().forEach(brokerSessionUuid -> TestPlainSaslAuthenticator.removeUser(brokerSessionUuid, user.userMetadata, this.logicalClusterId));
    }

    public synchronized LogicalClusterUser user(int userId) {
        return this.users.get(userId);
    }

    public synchronized LogicalClusterUser adminUser() {
        return this.adminUser;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    public String orgId() {
        return this.orgId;
    }

    public String envId() {
        return this.envId;
    }
}

