/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSni;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSniWithPathPrefix;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithSniStartWithPKC;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithWrongSni;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kafka.network.SocketServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.test.JarResourceLoader;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:size:medium")})
public class FileBasedPlainSaslAuthHostNameValidationIntegrationTest {
    public static final String LOCAL_HOST_IP = "127.0.0.1";
    private final String logicalClusterId = KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId();
    private final String serviceUserAPIkey = "APIKEY1";
    private final String serviceUserAPIkeyPassword = "pwd1";
    private IntegrationTestHarness testHarness;
    protected PhysicalCluster physicalCluster;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private final String path = JarResourceLoader.loadFileFromResource(FileBasedPlainSaslAuthenticatorTest.class, (String)"/file_auth_test_apikeys.json").getPath();
    private Path tempDir;
    private TestInfo testInfo;
    private Map<String, Object> testCert;

    public void setUpCluster(String mode) throws Exception {
        this.setUpCluster(mode, ProxyProtocol.NONE.name);
    }

    public void setUpCluster(String mode, String proxyProtocolVersion) throws Exception {
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness(this.testInfo);
        Properties brokerOverrideProps = this.setUpMetadata(this.brokerProps(mode, proxyProtocolVersion));
        this.physicalCluster = this.testHarness.start(brokerOverrideProps, this.controllerProps());
        int serviceUserId = 1;
        LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, serviceUserId);
        LogicalClusterUser testUser = logicalCluster.user(serviceUserId);
        this.testHarness.newAclCommand().addTopicAclArgs(testUser.prefixedKafkaPrincipal(), testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL).execute();
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo = testInfo;
        this.tempDir = TestUtils.tempDirectory().toPath();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        configs.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        configs.put("node.id", brokerProps.get("node.id"));
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(KafkaLogicalClusterUtils.LC_META_ABC, this.tempDir);
        TestUtils.waitForCondition(() -> this.metadata.metadata(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps(String mode, String proxyProtocolVersion) throws Exception {
        Properties props = this.nodeProps();
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", (Object)true);
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\"refresh_ms=\"1000\"sni_host_name_validation_mode=\"" + mode + "\";");
        props.put("confluent.multitenant.parse.sni.host.name.enable", (Object)true);
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,EXTERNAL:SASL_SSL");
        CertStores certStores = new CertStores(true, LOCAL_HOST_IP, InetAddress.getByName(LOCAL_HOST_IP));
        this.testCert = certStores.keyStoreProps();
        this.testCert.putAll(certStores.trustStoreProps());
        props.put("listeners", "INTERNAL://127.0.0.1:0,REPLICATION://127.0.0.1:0,EXTERNAL://127.0.0.1:0");
        props.put("inter.broker.listener.name", "REPLICATION");
        this.testCert.values().removeIf(Objects::isNull);
        props.putAll(this.testCert);
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.multitenant.parse.lkc.id.enable", (Object)true);
        props.put("listener.name.external.confluent.proxy.protocol.version", proxyProtocolVersion);
        return props;
    }

    private Properties nodeProps() {
        Properties props = new Properties();
        props.put("node.id", "0");
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.put("confluent.close.connections.on.credential.delete", "true");
        return props;
    }

    private Properties controllerProps() {
        return this.nodeProps();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulLkcValidationAuthWithProxyProtocol(String quorum) throws Exception {
        this.setUpCluster("", ProxyProtocol.V2.name);
        Properties clientProps = new Properties();
        clientProps.setProperty("confluent.proxy.protocol.client.version", ProxyProtocol.V2.name());
        clientProps.setProperty("confluent.proxy.protocol.client.address", "192.168.1.10");
        clientProps.setProperty("confluent.proxy.protocol.client.port", "9092");
        clientProps.setProperty("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.PROXY.toString());
        clientProps.setProperty("confluent.lkc.id", "lkc-abc");
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, clientProps);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedLkcValidationAuthWithProxyProtocol(String quorum) throws Exception {
        this.setUpCluster("", ProxyProtocol.V2.name);
        Properties clientProps = new Properties();
        clientProps.setProperty("confluent.proxy.protocol.client.version", ProxyProtocol.V2.name());
        clientProps.setProperty("confluent.proxy.protocol.client.address", "192.168.1.10");
        clientProps.setProperty("confluent.proxy.protocol.client.port", "9092");
        clientProps.setProperty("confluent.proxy.protocol.client.mode", ProxyProtocolCommand.PROXY.toString());
        clientProps.setProperty("confluent.lkc.id", "lkc-wrong");
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, clientProps);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
        HashMap<String, String> metricsTags = new HashMap<String, String>();
        metricsTags.put("tenant", "lkc-wrong");
        metricsTags.put("listener", "EXTERNAL");
        metricsTags.put("networkProcessor", "4");
        Assertions.assertTrue((boolean)this.verifyAuthMetric("failed-lkc-validation-total", metricsTags));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    public void testSuccessfulAuthenticationNoModeSpecified(String quorum) throws Exception {
        this.setUpCluster("");
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationOptionalMode(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedAuthenticationOptionalMode(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithWrongSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationInLegacyModeWhenSniStartWithPKC(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedAuthenticationInLegacyModeDueToSniNotSetByDefaultOnLocalHost(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedAuthenticationInLegacyModeSniIncorrect(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithWrongSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationInStrictModeSni(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedAuthenticationInStrictModeSniNotProvided(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedAuthenticationInStrictModeSniIncorrect(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithWrongSni.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testFailedAuthenticationInStrictModeSniStartsWithPkc(String quorum) throws Exception {
        this.setUpCluster(SniValidationMode.STRICT.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName());
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationInStrictModeWithPathPrefix(String quorum) throws Exception {
        this.testSuccessfulAuthenticationWithPathPrefix(SniValidationMode.STRICT);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationInOptionalModeWithPathPrefix(String quorum) throws Exception {
        this.testSuccessfulAuthenticationWithPathPrefix(SniValidationMode.OPTIONAL_VALIDATION);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testSuccessfulAuthenticationInLegacyModeWithPathPrefix(String quorum) throws Exception {
        this.testSuccessfulAuthenticationWithPathPrefix(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
    }

    private void testSuccessfulAuthenticationWithPathPrefix(SniValidationMode sniValidationMode) throws Exception {
        this.setUpCluster(sniValidationMode.getText());
        AdminClient client = this.testHarness.createSSLAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), this.testCert, SslEngineFactoryWithCorrectSniWithPathPrefix.class.getCanonicalName(), CaptureAndStripHostResolver.class);
        DescribeClusterResult describeClusterResult = client.describeCluster(new DescribeClusterOptions());
        Collection nodes = (Collection)describeClusterResult.nodes().get();
        Assertions.assertEquals((int)1, (int)nodes.size());
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifySuccessfulAuthenticationEvent(authenticationEvent);
        CaptureAndStripHostResolver dnsResolver = CaptureAndStripHostResolver.getInstance();
        int resolveAttempts = dnsResolver.resolveAttempts.size();
        Assertions.assertTrue((resolveAttempts > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)dnsResolver.resolveAttempts.get(resolveAttempts - 1)).startsWith("pb-"));
    }

    private void verifySuccessfulAuthentication(AdminClient client, KafkaFuture<Void> future) throws InterruptedException, ExecutionException {
        future.get();
        this.verifyExpectedTopicsPresent(client);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifySuccessfulAuthenticationEvent(authenticationEvent);
    }

    private void verifyFailedAuthentication(KafkaFuture<Void> future) throws InterruptedException {
        TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifyUnauthenticatedEvent(authenticationEvent);
    }

    private void verifyExpectedTopicsPresent(AdminClient client) throws InterruptedException, ExecutionException {
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
    }

    private void verifySuccessfulAuthenticationEvent(ConfluentAuthenticationEvent authenticationEvent) {
        Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent(), (String)"Authentication event should contain principal");
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"), (String)"Authentication event should contain logical cluster");
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"), (String)"Authentication event shouldn't contain tenant metadata");
        Assertions.assertEquals((Object)new Scope.Builder(new String[0]).addPath("organization=" + KafkaLogicalClusterUtils.LC_META_ABC.organizationId()).addPath("environment=" + KafkaLogicalClusterUtils.LC_META_ABC.environmentId()).addPath("cloud-cluster=" + KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId()).withKafkaCluster(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId()).build(), (Object)authenticationEvent.getScope());
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    private ConfluentAuthenticationEvent getLastAuthenticationEvent() {
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        return (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
    }

    private void verifyUnauthenticatedEvent(ConfluentAuthenticationEvent authenticationEvent) {
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent(), (String)"Authentication event shouldn't have principal");
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"), (String)"Authentication event should have lkc");
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent(), (String)"Authentication event should have exception");
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((errorInfo.errorMessage().contains("Cluster ID") && errorInfo.errorMessage().contains("does not match") ? 1 : 0) != 0, (String)"Error Info should contain Cluster Id doesn't match");
        Assertions.assertEquals((Object)"APIKEY1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    private boolean verifyAuthMetric(String metricName, Map<String, String> metricsTags) {
        Map<Integer, Metrics> metricsByNodeId = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().collect(Collectors.toMap(broker -> broker.config().brokerId(), KafkaBroker::metrics));
        Predicate<KafkaMetric> recordedMetric = metric -> metric != null && (Double)metric.metricValue() > 0.0;
        Predicate<Map> predicate = d -> d.values().stream().anyMatch(recordedMetric);
        TestCondition condition = () -> predicate.test(metricsByNodeId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.authMetric((Metrics)entry.getValue(), metricName, metricsTags))));
        try {
            return condition.conditionMet();
        }
        catch (Exception err) {
            return false;
        }
    }

    private KafkaMetric authMetric(Metrics metrics, String name, Map<String, String> tags) {
        return metrics.metric(metrics.metricName(name, SocketServer.MetricsGroup(), tags));
    }

    public static class CaptureAndStripHostResolver
    implements HostResolver {
        private static CaptureAndStripHostResolver instance;
        private final List<String> resolveAttempts = new ArrayList<String>();

        public static synchronized CaptureAndStripHostResolver getInstance() {
            return instance;
        }

        public CaptureAndStripHostResolver() {
            instance = this;
        }

        public synchronized List<String> resolveAttempts() {
            return new ArrayList<String>(this.resolveAttempts);
        }

        public synchronized InetAddress[] resolve(String host) throws UnknownHostException {
            this.resolveAttempts.add(host);
            if (host.startsWith("pb-")) {
                host = host.substring(3);
            }
            return InetAddress.getAllByName(host);
        }
    }
}

