/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.test.cluster.EmbeddedKafka;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.security.sasl.SaslServer;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.server.audit.DefaultAuthenticationEvent;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

@Tag(value="integration")
public class MultiTenantAuditLogTest {
    protected IntegrationTestHarness testHarness;
    protected String brokerUUID = "broker-uuid";
    protected String controllerUUID = "controller-uuid";
    private final String topic = "test.topic";
    private final String consumerGroup = "test.consumer.group";
    private final String logicalClusterId = "lkc-1234";
    protected PhysicalCluster physicalCluster;
    private LogicalCluster logicalCluster;
    private LogicalClusterUser user1;
    private LogicalClusterUser user2;
    private TestInfo testInfo;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
        MockAuditLogProvider.reset();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    @BeforeAll
    public static void verifyUnexpectedBefore() throws Exception {
        TestUtils.verifyNoUnexpectedThreads();
    }

    @AfterAll
    public static void verifyUnexpectedAfter() throws Exception {
        TestUtils.verifyNoUnexpectedThreads();
    }

    protected void startTestHarness(boolean enableAuditLogger) throws Exception {
        this.testHarness = new IntegrationTestHarness(this.testInfo);
        this.physicalCluster = this.testHarness.start(this.brokerProps(enableAuditLogger), this.controllerProps(enableAuditLogger));
        this.logicalCluster = this.physicalCluster.createLogicalCluster("lkc-1234", "testOrg", "testEnv", 100, 1, 2);
        this.user1 = this.logicalCluster.user(1);
        this.user2 = this.logicalCluster.user(2);
        TestUtils.waitForCondition(this::auditLoggerReady, (long)10000L, (String)"Audit Logger Ready");
    }

    private boolean auditLoggerReady() {
        try {
            if (this.physicalCluster.kafkaCluster().kafkas().isEmpty()) {
                return false;
            }
            for (EmbeddedKafka broker : this.physicalCluster.kafkaCluster().kafkas()) {
                MultiTenantAuthorizer authorizer = (MultiTenantAuthorizer)broker.kafkaBroker().authorizer().get();
                if (authorizer.isAuditLogEnabled()) continue;
                return true;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDisabled(String quorum) throws Throwable {
        this.startTestHarness(false);
        this.addProducerAcls(this.user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAcls(this.user2, "test.topic", "test.consumer.group", PatternType.LITERAL);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
        Assertions.assertTrue((boolean)MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.isEmpty());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateTopicAuthorization(String quorum) throws Exception {
        this.startTestHarness(true);
        String topicName = "foo";
        this.testHarness.newAclCommand().addTopicAclArgs(this.user1.prefixedKafkaPrincipal(), this.user1.withPrefix(topicName), AclOperation.CREATE, PatternType.LITERAL).execute();
        try (AdminClient adminClient = this.testHarness.createAdminClient(this.user1);){
            CreateTopicsResult result = adminClient.createTopics(Collections.singleton(new NewTopic(topicName, Optional.empty(), Optional.empty())));
            result.all().get();
        }
        String expectedEventSourceUUID = this.testHarness.isKraft() ? this.controllerUUID : this.brokerUUID;
        List<ConfluentAuthorizationEvent> controllerAuthEvents = this.collectUserAuthorizationEvents(expectedEventSourceUUID, this.user1);
        Assertions.assertEquals((int)1, (int)controllerAuthEvents.size());
        ConfluentAuthorizationEvent authorizationEvent = controllerAuthEvents.get(0);
        Assertions.assertEquals((Object)AuthorizeResult.ALLOWED, (Object)authorizationEvent.authorizeResult());
        Assertions.assertEquals((Object)this.user1.unprefixedKafkaPrincipal(), (Object)authorizationEvent.requestContext().principal());
        Assertions.assertEquals((Object)"Topic", (Object)authorizationEvent.action().resourceType().name());
        Assertions.assertEquals((Object)topicName, (Object)authorizationEvent.action().resourceName());
        Assertions.assertTrue((authorizationEvent.requestContext().kafkaRequestId() > 0L ? 1 : 0) != 0);
        if (!this.testHarness.isKraft()) {
            Assertions.assertTrue((authorizationEvent.requestContext().sessionId() > 0L ? 1 : 0) != 0);
        }
    }

    private List<ConfluentAuthorizationEvent> collectUserAuthorizationEvents(String sessionUuid, LogicalClusterUser user) {
        return MockAuditLogProvider.getInstance((String)sessionUuid).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals(user.unprefixedKafkaPrincipal().toString())).collect(Collectors.toList());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testLiteralAcls(String quorum) throws Throwable {
        this.startTestHarness(true);
        this.addProducerAcls(this.user1, "test.topic", PatternType.LITERAL);
        this.addConsumerAcls(this.user2, "test.topic", "test.consumer.group", PatternType.LITERAL);
        this.testHarness.produceConsume(this.user1, this.user2, "test.topic", "test.consumer.group", 0);
        List user1s = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:1")).collect(Collectors.toList());
        List produces = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:1") && e.action().resourceName().equals("test.topic") && e.action().operation().name().equals("Write") && e.authorizePolicy() instanceof AclAccessRule && ((AclAccessRule)e.authorizePolicy()).resourcePattern().name().equals("test.topic")).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)produces.size());
        List topicReads = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:2") && e.action().resourceName().equals("test.topic") && e.action().operation().name().equals("Read") && e.authorizePolicy() instanceof AclAccessRule && ((AclAccessRule)e.authorizePolicy()).resourcePattern().name().equals("test.topic")).collect(Collectors.toList());
        Assertions.assertFalse((boolean)topicReads.isEmpty());
        List groupReads = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:2") && e.action().resourceName().equals("test.consumer.group") && e.action().operation().name().equals("Read") && e.authorizePolicy() instanceof AclAccessRule && ((AclAccessRule)e.authorizePolicy()).resourcePattern().name().equals("test.consumer.group")).collect(Collectors.toList());
        Assertions.assertFalse((boolean)groupReads.isEmpty());
        Assertions.assertFalse((boolean)MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().anyMatch(e -> e.requestContext().principal().toString().contains("TenantUser:")));
        List tenantUserEntries = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:1") || e.requestContext().principal().toString().equals("User:2")).collect(Collectors.toList());
        Scope expectedScope = new Scope.Builder(new String[0]).addPath("organization=" + this.logicalCluster.orgId()).addPath("environment=" + this.logicalCluster.envId()).addPath("cloud-cluster=" + this.logicalCluster.logicalClusterId()).withKafkaCluster("lkc-1234").build();
        Assertions.assertTrue((boolean)tenantUserEntries.stream().allMatch(e -> e.sourceScope().equals((Object)expectedScope)));
        Assertions.assertTrue((boolean)tenantUserEntries.stream().allMatch(e -> e.action().scope().equals((Object)expectedScope)));
        Assertions.assertTrue((boolean)tenantUserEntries.stream().allMatch(e -> e.authorizePolicy() instanceof AclAccessRule && !((AclAccessRule)e.authorizePolicy()).resourcePattern().name().contains("lkc-1234") && !((AclAccessRule)e.authorizePolicy()).aclBinding().entry().principal().startsWith("TenantUser:")));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterResource(String quorum) throws Throwable {
        block14: {
            this.startTestHarness(true);
            try (AdminClient adminClient = this.testHarness.createAdminClient(this.user1);){
                adminClient.describeConfigs(Collections.singleton(new ConfigResource(ConfigResource.Type.BROKER, "0"))).all().get();
            }
            catch (ExecutionException e2) {
                if (e2.getCause() instanceof ClusterAuthorizationException) break block14;
                throw e2;
            }
        }
        List user1s = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:1")).collect(Collectors.toList());
        List describes = MockAuditLogProvider.getInstance((String)this.brokerUUID).authorizationLog.stream().filter(e -> e.requestContext().principal().toString().equals("User:1") && e.action().resourceName().equals("kafka-cluster") && e.action().operation().name().equals("DescribeConfigs") && e.authorizeResult() == AuthorizeResult.DENIED).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)describes.size());
    }

    protected Properties brokerProps(boolean auditLoggerEnable) throws IOException {
        Properties props = this.nodeProps(auditLoggerEnable);
        props.put(KafkaConfig$.MODULE$.BrokerSessionUuidProp(), this.brokerUUID);
        return props;
    }

    protected Properties controllerProps(boolean auditLoggerEnable) throws IOException {
        Properties props = this.nodeProps(auditLoggerEnable);
        props.put(KafkaConfig$.MODULE$.BrokerSessionUuidProp(), this.controllerUUID);
        return props;
    }

    protected Properties nodeProps(boolean auditLoggerEnable) throws IOException {
        Properties props = new Properties();
        props.put("authorizer.class.name", MultiTenantAuthorizer.class.getName());
        props.put("confluent.max.acls.per.tenant", "100");
        if (auditLoggerEnable) {
            props.put("confluent.security.event.logger.multitenant.enable", "true");
        }
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        props.putIfAbsent("log.dir", TestUtils.tempDirectory().getAbsolutePath());
        return props;
    }

    private void addProducerAcls(LogicalClusterUser user, String topic, PatternType patternType) {
        this.testHarness.newAclCommand().produceAclArgs(user.prefixedKafkaPrincipal(), user.withPrefix(topic), patternType).execute();
    }

    private void addConsumerAcls(LogicalClusterUser user, String topic, String consumerGroup, PatternType patternType) {
        this.testHarness.newAclCommand().consumeAclArgs(user.prefixedKafkaPrincipal(), user.withPrefix(topic), user.withPrefix(consumerGroup), patternType).execute();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAuthenticationEvent(String quorum) throws Throwable {
        boolean isAudit919Merged = false;
        this.startTestHarness(true);
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("0", new TenantMetadata("lkc-12345", "lkc-12345"));
        Assertions.assertEquals((Object)"TenantUser", (Object)principal.getPrincipalType());
        Assertions.assertTrue((boolean)principal.toString().contains("tenantMetadata"));
        SaslServer server = (SaslServer)Mockito.mock(SaslServer.class);
        SaslAuthenticationContext authenticationContext = new SaslAuthenticationContext(1111111111111L, server, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLocalHost(), SecurityProtocol.SASL_SSL.name());
        Scope scope = Scope.kafkaClusterScope((String)"ABC123");
        DefaultAuthenticationEvent authenticationEvent = new DefaultAuthenticationEvent((KafkaPrincipal)principal, (AuthenticationContext)authenticationContext, AuditEventStatus.SUCCESS);
        ConfluentAuthenticationEvent confluentAuthenticationEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)authenticationEvent, scope);
        auditLogProvider.logEvent((AuditEvent)confluentAuthenticationEvent);
        ConfluentAuthenticationEvent sanitizedEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertEquals((Object)"User:0", (Object)((KafkaPrincipal)sanitizedEvent.principal().get()).toString());
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)sanitizedEvent.principal().get()).getPrincipalType());
        Assertions.assertFalse((boolean)((KafkaPrincipal)sanitizedEvent.principal().get()).toString().contains("tenantMetadata"));
        Assertions.assertTrue((boolean)sanitizedEvent.getScope().toString().contains("kafka-cluster=lkc-12345"));
        Assertions.assertFalse((boolean)sanitizedEvent.getScope().toString().contains("ABC123"));
        Assertions.assertEquals((long)sanitizedEvent.authenticationContext().sessionId(), (long)1111111111111L);
        SslAuthenticationException authenticationException = new SslAuthenticationException("Ssl handshake failed");
        DefaultAuthenticationEvent failureEvent = new DefaultAuthenticationEvent(null, (AuthenticationContext)authenticationContext, AuditEventStatus.UNKNOWN_USER_DENIED, (AuthenticationException)authenticationException);
        ConfluentAuthenticationEvent confluentFailureEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)failureEvent, scope);
        auditLogProvider.logEvent((AuditEvent)confluentFailureEvent);
        sanitizedEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)sanitizedEvent.principal().isPresent());
        Assertions.assertTrue((!isAudit919Merged || sanitizedEvent.getScope().toString().contains("lkc-1234") ? 1 : 0) != 0);
        authenticationException = new SslAuthenticationException("username not specified", AuthenticationErrorInfo.UNKNOWN_USER_ERROR);
        failureEvent = new DefaultAuthenticationEvent(null, (AuthenticationContext)authenticationContext, AuditEventStatus.UNKNOWN_USER_DENIED, (AuthenticationException)authenticationException);
        confluentFailureEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)failureEvent, scope);
        auditLogProvider.logEvent((AuditEvent)confluentFailureEvent);
        sanitizedEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)sanitizedEvent.principal().isPresent());
        Assertions.assertTrue((!isAudit919Merged || sanitizedEvent.getScope().toString().contains("lkc-1234") ? 1 : 0) != 0);
        AuthenticationErrorInfo errorInfo = new AuthenticationErrorInfo(AuditEventStatus.UNAUTHENTICATED, "", "APIKEY123", "lkc123");
        authenticationException = new SaslAuthenticationException("Bad password for user", errorInfo);
        failureEvent = new DefaultAuthenticationEvent(null, (AuthenticationContext)authenticationContext, AuditEventStatus.UNAUTHENTICATED, (AuthenticationException)authenticationException);
        confluentFailureEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)failureEvent, scope);
        auditLogProvider.logEvent((AuditEvent)confluentFailureEvent);
        sanitizedEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assertions.assertFalse((boolean)sanitizedEvent.principal().isPresent());
        Assertions.assertTrue((boolean)sanitizedEvent.getScope().toString().contains("lkc123"));
        Assertions.assertFalse((boolean)sanitizedEvent.getScope().toString().contains("lkc-1234"));
    }
}

