/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.CellMigrationState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionPlacementStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.message.DescribeTenantsResponseData;
import org.apache.kafka.controller.metrics.CellControllerMetrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
class MultiTenantCellsMetricsIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    MultiTenantCellsMetricsIntegrationTest() {
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
    }

    @Override
    protected void createPhysicalAndLogicalClusters() {
        super.createPhysicalAndLogicalClusters();
        this.awaitMetadataPropagation();
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        super.createPhysicalAndLogicalClusters(brokerProperties);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testReplicaCounts(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 3, 3));
        client.createTopics(topics).all().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        DescribeTenantsResponseData.TenantDescription tenantDescription = (DescribeTenantsResponseData.TenantDescription)((List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get()).get(0);
        int sourceCell = (Integer)tenantDescription.cellIds().get(0);
        TestUtils.waitForCondition(() -> this.numReplicasMetric(sourceCell) == 9, (String)"Could not wait for replicas in source cell to be 9");
        for (DescribeCellsResponseData.Cell cell : cells) {
            Assertions.assertEquals((int)0, (int)this.numTenantsOutgoingMetric(cell.cellId()));
            Assertions.assertEquals((int)0, (int)this.numTenantsIncomingMetric(cell.cellId()));
        }
        HashMap<String, NewPartitions> newPartitions = new HashMap<String, NewPartitions>();
        newPartitions.put(topicName, NewPartitions.increaseTo((int)100));
        client.createPartitions(newPartitions).all().get();
        TestUtils.waitForCondition(() -> this.numReplicasMetric(sourceCell) == 300, (String)"Could not wait for replicas in source cell to be 300");
        int targetCell = (sourceCell + 1) % cells.size();
        this.assignTenantToCell(this.logicalCluster2.logicalClusterId(), targetCell);
        TestUtils.waitForCondition(() -> this.numReplicasMetric(sourceCell) == 300, (String)"Could not wait for replicas in source cell to be 300");
        TestUtils.waitForCondition(() -> this.numReplicasMetric(targetCell) == 0, (String)"Could not wait for replicas in target cell to be 0");
        for (DescribeCellsResponseData.Cell cell : cells) {
            Assertions.assertEquals((int)(cell.cellId() == sourceCell ? 1 : 0), (int)this.numTenantsOutgoingMetric(cell.cellId()));
            Assertions.assertEquals((int)(cell.cellId() == targetCell ? 1 : 0), (int)this.numTenantsIncomingMetric(cell.cellId()));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testTenantToMultipleCellMetrics(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 3, 3));
        client.createTopics(topics).all().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        DescribeTenantsResponseData.TenantDescription tenantDescription = (DescribeTenantsResponseData.TenantDescription)((List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get()).get(0);
        int originalSourceSingleCell = (Integer)tenantDescription.cellIds().get(0);
        int spanningTargetCell = (originalSourceSingleCell + 1) % cells.size();
        Assertions.assertEquals((int)1, (int)this.numTenantsPerCellMetric(originalSourceSingleCell));
        Assertions.assertEquals((int)0, (int)this.numTenantsPerCellMetric(spanningTargetCell));
        this.assignTenantToMultipleCells(this.logicalCluster2.logicalClusterId(), Arrays.asList(originalSourceSingleCell, spanningTargetCell));
        Assertions.assertEquals((int)1, (int)this.numTenantsPerCellMetric(spanningTargetCell));
        Assertions.assertEquals((int)1, (int)this.numTenantsPerCellMetric(originalSourceSingleCell));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testReplicaCountsAlterPartitionsWithAllReassigned(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        int numPartitions = 100;
        List<Integer> partitionsToReassign = IntStream.range(0, numPartitions).boxed().collect(Collectors.toList());
        this.testAlterPartitionAssignments(numPartitions, partitionsToReassign, Collections.emptyList());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testReplicaCountsAlterPartitionsWithHalfCancels(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        int numPartitions = 100;
        List<Integer> partitionsToReassign = IntStream.range(0, numPartitions).boxed().collect(Collectors.toList());
        List<Integer> partitionsToCancel = IntStream.range(0, numPartitions / 2).boxed().collect(Collectors.toList());
        this.testAlterPartitionAssignments(numPartitions, partitionsToReassign, partitionsToCancel);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testReplicaCountsAlterPartitionsWithAllCancels(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        int numPartitions = 100;
        List<Integer> partitionsToReassignAndCancel = IntStream.range(0, numPartitions).boxed().collect(Collectors.toList());
        this.testAlterPartitionAssignments(numPartitions, partitionsToReassignAndCancel, partitionsToReassignAndCancel);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testReplicaCountsForHealthcheckTenant(String quorum) throws Exception {
        int brokerCount = 9;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.adminUser());
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 5, 3));
        client.createTopics(topics).all().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        for (DescribeCellsResponseData.Cell cell : cells) {
            Assertions.assertEquals((int)0, (int)this.numTenantsOutgoingMetric(cell.cellId()));
            Assertions.assertEquals((int)0, (int)this.numTenantsIncomingMetric(cell.cellId()));
        }
        HashMap<String, NewPartitions> newPartitions = new HashMap<String, NewPartitions>();
        newPartitions.put(topicName, NewPartitions.increaseTo((int)100));
        client.createPartitions(newPartitions).all().get();
        for (DescribeCellsResponseData.Cell cell : cells) {
            Assertions.assertEquals((int)0, (int)this.numTenantsOutgoingMetric(cell.cellId()));
            Assertions.assertEquals((int)0, (int)this.numTenantsIncomingMetric(cell.cellId()));
        }
    }

    private void testAlterPartitionAssignments(int numPartitions, List<Integer> partitionsToReassignToTargetCell, List<Integer> partitionsToCancel) throws Exception {
        AdminClient client = this.testHarness.createAdminClient(this.logicalCluster2.user(22));
        String topicName = "testtopicname";
        List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, numPartitions, 3));
        client.createTopics(topics).all().get();
        List cells = ((DescribeCellsResponseData)this.physicalCluster.superConfluentAdmin().describeCells(Collections.emptyList()).value().get()).cells();
        DescribeTenantsResponseData.TenantDescription tenantDescription = (DescribeTenantsResponseData.TenantDescription)((List)this.physicalCluster.superConfluentAdmin().describeTenants(Collections.emptyList()).value().get()).get(0);
        int sourceCell = (Integer)tenantDescription.cellIds().get(0);
        int numReplicasExpected = numPartitions * 3;
        TestUtils.waitForCondition(() -> this.numReplicasMetric(sourceCell) == numReplicasExpected, (String)String.format("Could not wait for replicas in source cell to be %s", numReplicasExpected));
        int targetCell = (sourceCell + 1) % cells.size();
        List targetCellBrokers = cells.stream().filter(cell -> cell.cellId() == targetCell).findFirst().get().brokers();
        this.assignTenantToCell(this.logicalCluster2.logicalClusterId(), targetCell);
        HashMap<TopicPartition, Optional<NewPartitionReassignment>> alterMap = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
        HashMap cancelMap = new HashMap();
        for (int partitionId : partitionsToReassignToTargetCell) {
            alterMap.put(new TopicPartition(this.logicalCluster2.logicalClusterId() + "_" + topicName, partitionId), Optional.of(new NewPartitionReassignment(targetCellBrokers)));
        }
        for (int partitionId : partitionsToCancel) {
            cancelMap.put(new TopicPartition(this.logicalCluster2.logicalClusterId() + "_" + topicName, partitionId), Optional.empty());
        }
        this.physicalCluster.superConfluentAdmin().alterPartitionReassignments(alterMap).all();
        this.physicalCluster.superConfluentAdmin().alterPartitionReassignments(cancelMap).all().get();
        TestUtils.waitForCondition(() -> ((Map)this.physicalCluster.superConfluentAdmin().listPartitionReassignments().reassignments().get()).isEmpty(), (String)"Could not wait for partition assignments to finish");
        TestUtils.waitForCondition(() -> {
            Map topicDescriptions = (Map)client.describeTopics(Collections.singleton(topicName)).allTopicNames().get();
            TopicDescription topicDescription = (TopicDescription)topicDescriptions.get(topicName);
            int sourceCellReplicaCounts = 0;
            int targetReplicaCounts = 0;
            for (TopicPartitionInfo partitionInfo : topicDescription.partitions()) {
                for (Node replica : partitionInfo.replicas()) {
                    int brokerId = replica.id();
                    int cellId = brokerId / 3;
                    if (cellId == sourceCell) {
                        ++sourceCellReplicaCounts;
                        continue;
                    }
                    if (cellId != targetCell) continue;
                    ++targetReplicaCounts;
                }
            }
            int metricNumSourceReplicas = this.numReplicasMetric(sourceCell);
            int metricNumTargetReplicas = this.numReplicasMetric(targetCell);
            boolean replicasMatch = sourceCellReplicaCounts == metricNumSourceReplicas && targetReplicaCounts == metricNumTargetReplicas;
            boolean incomingMatch = this.numTenantsIncomingMetric(targetCell) == Math.min(metricNumSourceReplicas, 1) && this.numTenantsIncomingMetric(sourceCell) == 0;
            boolean outgoingMatch = this.numTenantsOutgoingMetric(sourceCell) == Math.min(metricNumSourceReplicas, 1) && this.numTenantsOutgoingMetric(targetCell) == 0;
            return replicasMatch && incomingMatch && outgoingMatch;
        }, (String)"Cell metrics are not consistent with actual replica counts");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft"})
    void testCellMigrationStateMetrics(String quorum) throws Exception {
        int brokerCount = 6;
        long timeoutWaitMs = 5000L;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.cellProps());
        String migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INACTIVE", (Object)migrationState);
        TestUtils.waitForCondition(() -> this.cellMigrationState() == 0, (long)timeoutWaitMs, (String)"Could not wait for cell migration state to be INACTIVE");
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.INITIATED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"INITIATED", (Object)migrationState);
        TestUtils.waitForCondition(() -> this.cellMigrationState() == 2, (long)timeoutWaitMs, (String)"Could not wait for cell migration state to be INITIATED");
        this.physicalCluster.superConfluentAdmin().alterCellMigration(CellMigrationState.PAUSED).value().get();
        migrationState = ((DescribeCellMigrationResponseData)this.physicalCluster.superConfluentAdmin().describeCellMigration().value().get()).cellMigrationState();
        Assertions.assertEquals((Object)"PAUSED", (Object)migrationState);
        TestUtils.waitForCondition(() -> this.cellMigrationState() == 1, (long)timeoutWaitMs, (String)"Could not wait for cell migration state to be PAUSED");
    }

    private int cellMigrationState() {
        CellControllerMetrics metrics = (CellControllerMetrics)this.physicalCluster.kafkaCluster().kraftController().cellControllerMetrics().get();
        return metrics.cellMigrationState();
    }

    private int numReplicasMetric(int cellId) {
        CellControllerMetrics metrics = (CellControllerMetrics)this.physicalCluster.kafkaCluster().kraftController().cellControllerMetrics().get();
        return metrics.cellMetrics(cellId).replicaCount();
    }

    private int numTenantsOutgoingMetric(int cellId) {
        CellControllerMetrics metrics = (CellControllerMetrics)this.physicalCluster.kafkaCluster().kraftController().cellControllerMetrics().get();
        return metrics.cellMetrics(cellId).numOutgoingTenants();
    }

    private int numTenantsPerCellMetric(int cellId) {
        CellControllerMetrics metrics = (CellControllerMetrics)this.physicalCluster.kafkaCluster().kraftController().cellControllerMetrics().get();
        return metrics.cellMetrics(cellId).tenantCount();
    }

    private int numTenantsIncomingMetric(int cellId) {
        CellControllerMetrics metrics = (CellControllerMetrics)this.physicalCluster.kafkaCluster().kraftController().cellControllerMetrics().get();
        return metrics.cellMetrics(cellId).numIncomingTenants();
    }

    private void assignTenantToCell(String tenantId, int cellId) throws Exception {
        AssignTenantsToCellRequestData.TenantToCellAssignment assignment = new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenantId).setCellIds(Collections.singletonList(cellId));
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Collections.singletonList(assignment)).value().get();
    }

    private void assignTenantToMultipleCells(String tenantId, List<Integer> cellIds) throws Exception {
        AssignTenantsToCellRequestData.TenantToCellAssignment assignment = new AssignTenantsToCellRequestData.TenantToCellAssignment().setTenantId(tenantId).setCellIds(cellIds);
        this.physicalCluster.superConfluentAdmin().assignTenantsToCells(Collections.singletonList(assignment)).value().get();
    }

    private Properties cellProps() {
        Properties props = this.nodeProps();
        props.put("confluent.cells.enable", (Object)true);
        props.put("confluent.cells.implicit.creation.enable", (Object)true);
        props.put("confluent.topic.partition.default.placement", PartitionPlacementStrategy.TENANT_IN_CELL.code().toString());
        props.put("confluent.cells.min.size", (Object)1);
        props.put("confluent.cells.default.size", (Object)3);
        props.put("confluent.cells.max.size", (Object)3);
        props.put("confluent.cell.metrics.refresh.period.ms", (Object)1);
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)3);
        props.put("default.replication.factor", (Object)3);
        return props;
    }
}

