/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import io.confluent.kafka.multitenant.metrics.utils.PartitionMetricUtils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.metrics.utils.MetricUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MultiTenantHotPartitionIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private List<KafkaProducer<String, String>> producers = null;
    private List<KafkaConsumer<String, String>> consumers = null;
    private final SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;

    @Override
    protected Properties nodeProps() {
        Properties props = super.nodeProps();
        props.put("confluent.hot.partition.ratio", (Object)0.1);
        props.put("confluent.broker.limit.producer.bytes.per.second", (Object)10);
        props.put("confluent.broker.limit.consumer.bytes.per.second", (Object)10);
        return props;
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
        this.producers = new ArrayList<KafkaProducer<String, String>>(1);
        this.consumers = new ArrayList<KafkaConsumer<String, String>>(1);
    }

    @AfterEach
    void shutdown() {
        this.producers.forEach(KafkaProducer::close);
        this.consumers.forEach(KafkaConsumer::close);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMultiTenantHotPartitionMetrics(String quorum) throws Throwable {
        this.setUp(1, Collections.emptyList());
        this.createPhysicalAndLogicalClusters();
        LogicalClusterUser user1 = this.logicalCluster1.user(11);
        this.producers.add(this.testHarness.createProducer(user1, this.securityProtocol));
        String groupId = "test-group";
        this.consumers.add(this.testHarness.createConsumer(user1, groupId, this.securityProtocol));
        String topic = "test-topic";
        String prefixedTopic1 = user1.tenantPrefix() + topic;
        this.physicalCluster.kafkaCluster().createTopic(prefixedTopic1, 1, 1);
        int firstMessageIndex = 0;
        KafkaTestUtils.sendRecords(this.producers.get(0), topic, firstMessageIndex, 10);
        KafkaTestUtils.consumeRecords(this.consumers.get(0), topic, firstMessageIndex, 10);
        this.consumers.forEach(KafkaConsumer::commitSync);
        List<KafkaBroker> brokers = this.physicalCluster.kafkaCluster().kafkaBrokers();
        long now = System.currentTimeMillis();
        for (KafkaBroker broker : brokers) {
            TopicPartition tp = new TopicPartition(prefixedTopic1, 0);
            Map tags = PartitionMetricUtils.tenantPartitionMetricTags((String)this.logicalCluster1.logicalClusterId(), (TopicPartition)tp);
            Metrics metrics = broker.metrics();
            MetricName partitionBytesInRateMetricName = MetricUtils.rateMetricName((Metrics)metrics, (String)"tenant-metrics", (Map)tags, (String)"partition-bytes-in", (String)"partition-bytes-in");
            KafkaMetric partitionBytesInRateMetric = metrics.metric(partitionBytesInRateMetricName);
            Assertions.assertNotNull((Object)partitionBytesInRateMetric);
            MetricName hotPartitionInMetricName = metrics.metricName("hot-partition-in", "tenant-metrics", tags);
            KafkaMetric hotPartitionInMetric = metrics.metric(hotPartitionInMetricName);
            Assertions.assertNotNull((Object)hotPartitionInMetric);
            Assertions.assertEquals((double)1.0, (double)hotPartitionInMetric.measurableValue(now));
            MetricName partitionBytesOutRateMetricName = MetricUtils.rateMetricName((Metrics)metrics, (String)"tenant-metrics", (Map)tags, (String)"partition-bytes-out", (String)"partition-bytes-out");
            KafkaMetric partitionBytesOutRateMetric = metrics.metric(partitionBytesOutRateMetricName);
            Assertions.assertNotNull((Object)partitionBytesOutRateMetric);
            MetricName hotPartitionOutMetricName = metrics.metricName("hot-partition-out", "tenant-metrics", tags);
            KafkaMetric hotPartitionOutMetric = metrics.metric(hotPartitionOutMetricName);
            Assertions.assertNotNull((Object)hotPartitionOutMetric);
            Assertions.assertEquals((double)1.0, (double)hotPartitionOutMetric.measurableValue(now));
        }
    }
}

