/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import io.confluent.kafka.test.cluster.EmbeddedKafka;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.metrics.BrokerLoad;
import kafka.metrics.BrokerLoadConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="bazel:size:medium")
public class MultiTenantKafkaIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    private final ListenerName externalListenerName = new ListenerName("external");
    private final String externalListenerPrefix = this.externalListenerName.configPrefix();

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMultiTenantMetadataInstances(String quorum) {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        List<String> brokerSessionUuids = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(broker -> {
            Object cfgVal = broker.config().values().get(KafkaConfig.BrokerSessionUuidProp());
            return cfgVal == null ? "" : cfgVal.toString();
        }).distinct().collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)brokerSessionUuids.size(), (String)"Expect each broker to have unique session UUID.");
        brokerSessionUuids.forEach(uuid -> Assertions.assertNotNull((Object)PhysicalClusterMetadata.getInstance((String)uuid), (String)("Expect valid instance of PhysicalClusterMetadata for broker session UUID " + uuid)));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProduceConsume(String quorum) throws Throwable {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        this.testHarness.produceConsume(this.logicalCluster1.user(11), this.logicalCluster1.user(12), "testtopic", "group1", 0);
        this.testHarness.produceConsume(this.logicalCluster2.user(21), this.logicalCluster2.user(22), "testtopic", "group1", 1000);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testUpdatingBrokerLoadMetricTenantTag(String quorum) throws Throwable {
        this.setUp();
        this.physicalCluster = this.testHarness.start(this.nodeProps());
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_ABC);
        this.assertBrokerLoadMetricTenantTag(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId());
        this.addLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_XYZ);
        this.assertBrokerLoadMetricTenantTag(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId());
        this.assertBrokerLoadMetricTenantTag(KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId());
        this.deleteLkcFileAndSyncMetadata(KafkaLogicalClusterUtils.LC_META_ABC);
        this.assertBrokerLoadMetricTenantTag(KafkaLogicalClusterUtils.LC_META_XYZ.logicalClusterId());
    }

    private void assertBrokerLoadMetricTenantTag(String lkcId) throws Throwable {
        Map<String, String> expectedTag = Collections.singletonMap("tenant", lkcId);
        TestUtils.waitForCondition(() -> this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(broker -> ((Metric)((BrokerLoad)broker.socketServer().brokerLoad().get()).brokerLoadTenantMetric(lkcId).get()).metricName().tags()).allMatch(expectedTag::equals), (String)String.format("Expect that the broker's broker load metric tenant tag to be %s", lkcId));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerConfigsWhenConfigDisabled(String quorum) throws Exception {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        this.expectAlterBrokerConfigsViaExternalListenerRejected(tenantAdminClient, internalAdminClient, new ConfigResource(ConfigResource.Type.BROKER, "0"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterClusterConfigsWhenConfigDisabled(String quorum) throws Exception {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        this.expectAlterBrokerConfigsViaExternalListenerRejected(tenantAdminClient, internalAdminClient, new ConfigResource(ConfigResource.Type.BROKER, ""));
    }

    private void expectAlterBrokerConfigsViaExternalListenerRejected(AdminClient tenantAdminClient, AdminClient internalAdminClient, ConfigResource configResource) throws Exception {
        KafkaBroker broker0 = this.physicalCluster.kafkaCluster().kafkas().get(0).kafkaBroker();
        List defaultCipherSuites = broker0.config().getList("ssl.cipher.suites");
        int defaultMaxMessageBytes = broker0.config().messageMaxBytes();
        Map<ConfigResource, Config> newConfigs = Collections.singletonMap(configResource, new Config(Arrays.asList(new ConfigEntry("message.max.bytes", "10000"), new ConfigEntry("auto.create.topics.enable", "true"), new ConfigEntry("ssl.cipher.suites", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"))));
        Throwable exceptionCause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)tenantAdminClient.alterConfigs(newConfigs).all().get();
        })).getCause();
        Assertions.assertEquals(PolicyViolationException.class, exceptionCause.getClass());
        Assertions.assertEquals((int)defaultMaxMessageBytes, (int)broker0.config().messageMaxBytes());
        Assertions.assertEquals((Object)false, (Object)broker0.config().autoCreateTopicsEnable());
        Assertions.assertEquals((Object)defaultCipherSuites, (Object)broker0.config().get("ssl.cipher.suites"));
        Map<ConfigResource, List<AlterConfigOp>> newConfigs2 = Collections.singletonMap(configResource, Arrays.asList(new AlterConfigOp(new ConfigEntry("message.max.bytes", "15000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("auto.create.topics.enable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("ssl.cipher.suites", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"), AlterConfigOp.OpType.SET)));
        exceptionCause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)tenantAdminClient.incrementalAlterConfigs(newConfigs2).all().get();
        })).getCause();
        Assertions.assertEquals(PolicyViolationException.class, exceptionCause.getClass());
        Assertions.assertEquals((int)defaultMaxMessageBytes, (int)broker0.config().messageMaxBytes());
        Assertions.assertEquals((Object)false, (Object)broker0.config().autoCreateTopicsEnable());
        Assertions.assertEquals((Object)defaultCipherSuites, (Object)broker0.config().get("ssl.cipher.suites"));
        Map<ConfigResource, Config> newConfigsInternal = Collections.singletonMap(configResource, new Config(Arrays.asList(new ConfigEntry("message.max.bytes", "10000"), new ConfigEntry("auto.create.topics.enable", "true"), new ConfigEntry(this.externalListenerPrefix + "ssl.cipher.suites", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"))));
        internalAdminClient.alterConfigs(newConfigsInternal).all().get();
        TestUtils.waitForCondition(() -> broker0.config().messageMaxBytes() == 10000, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().autoCreateTopicsEnable(), (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256".equals(this.sslCipherSuitesFromConfig(broker0.config(), this.externalListenerName)), (String)"Dynamic config not updated");
        Map<ConfigResource, List<AlterConfigOp>> newConfigs2Internal = Collections.singletonMap(configResource, Arrays.asList(new AlterConfigOp(new ConfigEntry("message.max.bytes", "15000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("auto.create.topics.enable", "true"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(this.externalListenerPrefix + "ssl.cipher.suites", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"), AlterConfigOp.OpType.SET)));
        internalAdminClient.incrementalAlterConfigs(newConfigs2Internal).all().get();
        TestUtils.waitForCondition(() -> broker0.config().messageMaxBytes() == 15000, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().autoCreateTopicsEnable(), (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384".equals(this.sslCipherSuitesFromConfig(broker0.config(), this.externalListenerName)), (String)"Dynamic config not updated");
        Map<ConfigResource, Config> invalidConfigs = Collections.singletonMap(configResource, new Config(Collections.singleton(new ConfigEntry("broker.id", "20"))));
        exceptionCause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)internalAdminClient.alterConfigs(invalidConfigs).all().get();
        })).getCause();
        Assertions.assertEquals(InvalidRequestException.class, exceptionCause.getClass());
        Assertions.assertEquals((int)0, (int)broker0.config().brokerId());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterBrokerConfigsWhenConfigEnabled(String quorum) throws Exception {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.alter.cluster.configs.enable", "true");
        this.createPhysicalAndLogicalClusters(props);
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        this.expectAlterBrokerConfigsViaExternalListenerRejected(tenantAdminClient, internalAdminClient, new ConfigResource(ConfigResource.Type.BROKER, "0"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterClusterConfigsWhenConfigEnabled(String quorum) throws Exception {
        this.setUp();
        Properties props = this.nodeProps();
        props.put("confluent.alter.cluster.configs.enable", "true");
        this.createPhysicalAndLogicalClusters(props);
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        String sslCipherSuitesConfig = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
        KafkaBroker broker0 = this.physicalCluster.kafkaCluster().kafkas().get(0).kafkaBroker();
        long retentionMs0 = 3600000L;
        long maxCompactionLagMs0 = 0x7FFFFFFEL;
        Map<ConfigResource, Config> newConfigs = Collections.singletonMap(configResource, new Config(Arrays.asList(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, String.valueOf(retentionMs0)), new ConfigEntry("auto.create.topics.enable", "true"), new ConfigEntry(KafkaConfig.SslCipherSuitesProp(), sslCipherSuitesConfig), new ConfigEntry(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, String.valueOf(maxCompactionLagMs0)))));
        tenantAdminClient.alterConfigs(newConfigs).all().get();
        TestUtils.waitForCondition(() -> broker0.config().logRetentionTimeMillis() == retentionMs0, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().autoCreateTopicsEnable(), (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> sslCipherSuitesConfig.equals(this.sslCipherSuitesFromConfig(broker0.config(), this.externalListenerName)), (String)"Dynamic config for ssl-cipher-suites not updated.");
        String sslCipherSuitesConfig2 = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        long retentionMs1 = 3600001L;
        int numPartitions = 2;
        long maxCompactionLagMs1 = Integer.MAX_VALUE;
        Map<ConfigResource, List<AlterConfigOp>> newConfigs2 = Collections.singletonMap(configResource, Arrays.asList(new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, String.valueOf(retentionMs1)), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("num.partitions", String.valueOf(numPartitions)), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("auto.create.topics.enable", "false"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(KafkaConfig.SslCipherSuitesProp(), sslCipherSuitesConfig2), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, String.valueOf(maxCompactionLagMs1)), AlterConfigOp.OpType.SET)));
        tenantAdminClient.incrementalAlterConfigs(newConfigs2).all().get();
        TestUtils.waitForCondition(() -> broker0.config().logRetentionTimeMillis() == retentionMs1, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().numPartitions() == numPartitions, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().autoCreateTopicsEnable() == false, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> sslCipherSuitesConfig2.equals(this.sslCipherSuitesFromConfig(broker0.config(), this.externalListenerName)), (String)"Dynamic config for ssl-cipher-suites not updated.");
        for (EmbeddedKafka broker : this.physicalCluster.kafkaCluster().kafkas()) {
            TestUtils.waitForCondition(() -> broker.kafkaBroker().config().numPartitions() == numPartitions, (String)"num.partitions not updated");
        }
        if (!this.isKraft()) {
            int actualPartitionCount = (Integer)tenantAdminClient.createTopics(Collections.singleton(new NewTopic("testTopic", Optional.empty(), Optional.empty()))).numPartitions("testTopic").get(15L, TimeUnit.SECONDS);
            Assertions.assertEquals((int)numPartitions, (int)actualPartitionCount);
        }
        Map<ConfigResource, Config> newConfigsInternal = Collections.singletonMap(configResource, new Config(Arrays.asList(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, String.valueOf(retentionMs0)), new ConfigEntry("auto.create.topics.enable", "true"), new ConfigEntry(this.externalListenerPrefix + KafkaConfig.SslCipherSuitesProp(), "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"), new ConfigEntry(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, String.valueOf(maxCompactionLagMs0)))));
        internalAdminClient.alterConfigs(newConfigsInternal).all().get();
        TestUtils.waitForCondition(() -> broker0.config().logRetentionTimeMillis() == retentionMs0, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().autoCreateTopicsEnable(), (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> sslCipherSuitesConfig.equals(this.sslCipherSuitesFromConfig(broker0.config(), this.externalListenerName)), (String)"Dynamic config for ssl-cipher-suites not updated.");
        Map<ConfigResource, List<AlterConfigOp>> newConfigs2Internal = Collections.singletonMap(configResource, Arrays.asList(new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, String.valueOf(retentionMs1)), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("auto.create.topics.enable", "false"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(this.externalListenerPrefix + KafkaConfig.SslCipherSuitesProp(), "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, String.valueOf(maxCompactionLagMs1)), AlterConfigOp.OpType.SET)));
        internalAdminClient.incrementalAlterConfigs(newConfigs2Internal).all().get();
        TestUtils.waitForCondition(() -> broker0.config().logRetentionTimeMillis() == retentionMs1, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> broker0.config().autoCreateTopicsEnable() == false, (String)"Dynamic config not updated");
        TestUtils.waitForCondition(() -> sslCipherSuitesConfig2.equals(this.sslCipherSuitesFromConfig(broker0.config(), this.externalListenerName)), (String)"Dynamic config for ssl-cipher-suites not updated.");
        long retentionMs2 = 2599999L;
        Map<ConfigResource, List<AlterConfigOp>> newConfigs3 = Collections.singletonMap(configResource, Collections.singletonList(new AlterConfigOp(new ConfigEntry(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, String.valueOf(retentionMs2)), AlterConfigOp.OpType.SET)));
        Throwable exceptionCause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)tenantAdminClient.incrementalAlterConfigs(newConfigs3).all().get();
        })).getCause();
        Assertions.assertEquals(PolicyViolationException.class, exceptionCause.getClass());
        Assertions.assertEquals((long)retentionMs1, (long)broker0.config().logRetentionTimeMillis());
        int defaultMaxMessageBytes = broker0.config().messageMaxBytes();
        Map<ConfigResource, List<AlterConfigOp>> newConfigs4 = Collections.singletonMap(configResource, Collections.singletonList(new AlterConfigOp(new ConfigEntry("message.max.bytes", "500000"), AlterConfigOp.OpType.SET)));
        exceptionCause = ((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> {
            Void cfr_ignored_0 = (Void)tenantAdminClient.incrementalAlterConfigs(newConfigs4).all().get();
        })).getCause();
        Assertions.assertEquals(PolicyViolationException.class, exceptionCause.getClass());
        Assertions.assertEquals((int)defaultMaxMessageBytes, (int)broker0.config().messageMaxBytes());
    }

    private String sslCipherSuitesFromConfig(KafkaConfig kafkaConfig, ListenerName listenerName) {
        return (String)kafkaConfig.originals().get(listenerName.configPrefix() + KafkaConfig.SslCipherSuitesProp());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAcls(String quorum) throws Throwable {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        AdminClient adminClient1 = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        AdminClient adminClient2 = this.testHarness.createAdminClient(this.logicalCluster2.adminUser());
        Assertions.assertEquals(Collections.emptySet(), this.describeAllAcls(adminClient1));
        List<ResourceType> resourceTypes = Arrays.asList(ResourceType.TOPIC, ResourceType.GROUP, ResourceType.TRANSACTIONAL_ID);
        HashSet acls = new HashSet();
        resourceTypes.forEach(resourceType -> acls.add(new AclBinding(new ResourcePattern(resourceType, "test.resource", PatternType.LITERAL), new AccessControlEntry(this.logicalCluster1.user(11).unprefixedKafkaPrincipal().toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW))));
        resourceTypes.forEach(resourceType -> acls.add(new AclBinding(new ResourcePattern(resourceType, "test.", PatternType.PREFIXED), new AccessControlEntry(this.logicalCluster1.user(12).unprefixedKafkaPrincipal().toString(), "*", AclOperation.READ, AclPermissionType.ALLOW))));
        resourceTypes.forEach(resourceType -> acls.add(new AclBinding(new ResourcePattern(resourceType, "*", PatternType.LITERAL), new AccessControlEntry(this.logicalCluster1.user(11).unprefixedKafkaPrincipal().toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW))));
        adminClient1.createAcls(acls).all().get();
        TestUtils.retryOnExceptionWithTimeout(() -> {
            Assertions.assertEquals((Object)acls, this.describeAllAcls(adminClient1));
            Assertions.assertEquals(Collections.emptySet(), this.describeAllAcls(adminClient2));
        });
        adminClient2.createAcls(acls).all().get();
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals((Object)acls, this.describeAllAcls(adminClient2)));
        adminClient2.deleteAcls(Collections.singletonList(new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, "test", PatternType.PREFIXED), new AccessControlEntryFilter("User:*", "*", AclOperation.ANY, AclPermissionType.ANY)))).all().get();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testBrokerLoadConfigIsDynamicallyUpdated(String quorum) throws Exception {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        AdminClient internalAdminClient = this.physicalCluster.superAdminClient();
        List<BrokerLoadConfig> brokerLoadConfigs = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(broker -> ((BrokerLoad)broker.socketServer().brokerLoad().get()).brokerLoadConfig()).collect(Collectors.toList());
        brokerLoadConfigs.forEach(brokerLoadConfig -> Assertions.assertEquals((double)0.1, (double)brokerLoadConfig.averageServiceRequestTime(), (double)0.0, (String)"Expect that the broker load config is set to the default value"));
        brokerLoadConfigs.forEach(brokerLoadConfig -> Assertions.assertEquals((double)20.0, (double)brokerLoadConfig.workloadCoefficient(), (double)0.0, (String)"Expect that the broker load config is set to the the default value"));
        internalAdminClient.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry("confluent.broker.load.average.service.request.time.ms", String.valueOf(0.2)), AlterConfigOp.OpType.SET)))).all().get();
        TestUtils.waitForCondition(() -> {
            List config = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(broker -> ((BrokerLoad)broker.socketServer().brokerLoad().get()).brokerLoadConfig()).collect(Collectors.toList());
            return 0.2 == ((BrokerLoadConfig)config.get(0)).averageServiceRequestTime();
        }, (String)"Expect that the broker load config is set to the configured value");
        internalAdminClient.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry("confluent.broker.load.workload.coefficient", String.valueOf(60.0)), AlterConfigOp.OpType.SET)))).all().get();
        TestUtils.waitForCondition(() -> {
            List config = this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(broker -> ((BrokerLoad)broker.socketServer().brokerLoad().get()).brokerLoadConfig()).collect(Collectors.toList());
            return 60.0 == ((BrokerLoadConfig)config.get(0)).workloadCoefficient();
        }, (String)"Expect that the broker load config is set to the configured value");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testValidBrokerLoadMetricValue(String quorum) throws Throwable {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        TestUtils.waitForCondition(() -> {
            this.physicalCluster.kafkaCluster().kafkaBrokers().forEach(n -> n.time().sleep(10L));
            return this.physicalCluster.kafkaCluster().kafkaBrokers().stream().map(broker -> (BrokerLoad)broker.socketServer().brokerLoad().get()).allMatch(brokerLoad -> !Double.isNaN((Double)((Metric)brokerLoad.weightedAverageExternalNetworkThreadIdleRatioMetric().get()).metricValue()) && !Double.isNaN((Double)((Metric)brokerLoad.weightedAverageReplicationNetworkThreadIdleRatioMetric().get()).metricValue()));
        }, (String)"Broker load's thread idle ratio metrics should not be NaN");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAdminDescribeConsumerGroupsFailbackMechanism(String quorum) {
        this.setUp();
        this.createPhysicalAndLogicalClusters();
        AdminClient tenantAdminClient = this.testHarness.createAdminClient(this.logicalCluster1.adminUser());
        DescribeConsumerGroupsResult result = tenantAdminClient.describeConsumerGroups(Collections.singletonList("group-id"));
        Assertions.assertDoesNotThrow(() -> (ConsumerGroupDescription)((KafkaFuture)result.describedGroups().get("group-id")).get());
    }
}

