/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.test.AbstractMultiTenantKafkaIntegrationTest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.network.SocketServer;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.network.TenantQuotaEntity;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
class MultiTenantThrottlingIntegrationTest
extends AbstractMultiTenantKafkaIntegrationTest {
    MultiTenantThrottlingIntegrationTest() {
    }

    @Override
    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        super.setUpTempDir(testInfo);
    }

    @Override
    protected void createPhysicalAndLogicalClusters() {
        super.createPhysicalAndLogicalClusters();
        this.awaitMetadataPropagation();
    }

    @Override
    protected void createPhysicalAndLogicalClusters(Properties brokerProperties) {
        super.createPhysicalAndLogicalClusters(brokerProperties);
        this.awaitMetadataPropagation();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottling(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.rateThrottlingProps());
        this.assertTenantThrottled(this.logicalCluster2.user(22), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottlingDefaultChanged(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.rateThrottlingProps());
        this.setTenantQuota(null, "connection_creation_rate", 100.0);
        this.assertTenantNotThrottled(this.logicalCluster2.user(22), 10, true);
        this.setTenantQuota(null, "connection_creation_rate", 0.1);
        this.assertTenantThrottled(this.logicalCluster2.user(22), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottlingOverride(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.rateThrottlingProps();
        props.put("confluent.max.connection.creation.rate.per.tenant", "100");
        this.createPhysicalAndLogicalClusters(props);
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_rate", 0.1);
        this.assertTenantNotThrottled(this.logicalCluster1.user(9), 10, true);
        this.assertTenantThrottled(this.logicalCluster2.user(22), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottlingOverrideHigherThanDefault(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.rateThrottlingProps());
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_rate", 100.0);
        this.assertTenantNotThrottled(this.logicalCluster2.user(22), 10, true);
        this.assertTenantThrottled(this.logicalCluster1.user(9), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottlingOverrideChanged(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.rateThrottlingProps();
        props.put("confluent.max.connection.creation.rate.per.tenant", "100");
        this.createPhysicalAndLogicalClusters(props);
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_rate", 0.1);
        this.assertTenantNotThrottled(this.logicalCluster1.user(9), 10, true);
        this.assertTenantThrottled(this.logicalCluster2.user(22), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottlingOverrideIfDeleted(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.rateThrottlingProps();
        props.put("confluent.max.connection.creation.rate.per.tenant", "100");
        this.createPhysicalAndLogicalClusters(props);
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_rate", 0.1);
        this.deleteTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_rate");
        this.assertTenantNotThrottled(this.logicalCluster2.user(22), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantThrottlingOverrideDefaultIfDeleted(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.rateThrottlingProps();
        props.put("confluent.max.connection.creation.rate.per.tenant", "100");
        this.createPhysicalAndLogicalClusters(props);
        this.setTenantQuota(null, "connection_creation_rate", 0.1);
        this.deleteTenantQuota(null, "connection_creation_rate");
        this.assertTenantNotThrottled(this.logicalCluster2.user(22), 2, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testNoTenantThrottlingIfHighMaxConnectionRatePerTenant(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.rateThrottlingProps();
        props.put("confluent.max.connection.creation.rate.per.tenant", "100");
        this.createPhysicalAndLogicalClusters(props);
        this.assertTenantNotThrottled(this.logicalCluster2.user(22), 10, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testNoTenantThrottlingIfNotTrackingTenantOrApiKey(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        Properties props = this.rateThrottlingProps();
        props.put("confluent.track.api.key.per.ip", "false");
        props.put("confluent.track.tenant.id.per.ip", "false");
        this.createPhysicalAndLogicalClusters(props);
        this.assertTenantNotThrottled(this.logicalCluster2.user(22), 10, true);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantCountThrottlingOverrideHigherThanDefault(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.countThrottlingProps());
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_count", 100.0);
        this.assertTenantNotThrottledForConnectionCount(this.logicalCluster2.user(22), 11);
        this.assertTenantThrottledForConnectionCount(this.logicalCluster1.user(9), 11);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantCountThrottlingOverrideLowerThanDefault(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.countThrottlingProps());
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_count", 5.0);
        this.assertTenantThrottledForConnectionCount(this.logicalCluster2.user(22), 8);
        this.assertTenantNotThrottledForConnectionCount(this.logicalCluster1.user(9), 8);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    void testTenantCountThrottlingDeletingOverrides(String quorum) throws Exception {
        int brokerCount = 1;
        this.setUp(brokerCount, Collections.emptyList());
        this.createPhysicalAndLogicalClusters(this.countThrottlingProps());
        this.setTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_count", 5.0);
        this.deleteTenantQuota(this.logicalCluster2.user((int)22).logicalClusterId, "connection_creation_count");
        this.assertTenantNotThrottledForConnectionCount(this.logicalCluster2.user(22), 8);
        this.setTenantQuota(null, "connection_creation_count", 3.0);
        this.deleteTenantQuota(null, "connection_creation_count");
        this.assertTenantNotThrottledForConnectionCount(this.logicalCluster1.user(9), 8);
    }

    private double throttlingTimeMs(String tenantId) {
        MetricName metricName;
        Metrics metrics = this.isKraft() ? this.physicalCluster.kafkaCluster().kafkaBrokers().get(0).metrics() : this.physicalCluster.kafkaCluster().brokers().get(0).metrics();
        if (metrics.metric(metricName = metrics.metricName(String.format("tenant-connection-accept-throttle-time", new Object[0]), SocketServer.MetricsGroup(), "Tracking average throttle-time, out of non-zero throttle times, per tenant", new TenantQuotaEntity(tenantId).metricTags())) == null) {
            return 0.0;
        }
        Object value = metrics.metric(metricName).metricValue();
        return (Double)value;
    }

    private double throttledConnections(String tenantId) {
        MetricName metricName;
        Metrics metrics = this.isKraft() ? this.physicalCluster.kafkaCluster().kafkaBrokers().get(0).metrics() : this.physicalCluster.kafkaCluster().brokers().get(0).metrics();
        if (metrics.metric(metricName = metrics.metricName(String.format("tenant-excess-connections", new Object[0]), SocketServer.MetricsGroup(), "Tracking number of connections being throttled due to exceeding connection count quota, per tenant", new TenantQuotaEntity(tenantId).metricTags())) == null) {
            return 0.0;
        }
        Object value = metrics.metric(metricName).metricValue();
        return (Double)value;
    }

    private void assertTenantThrottled(LogicalClusterUser tenant, int requests, boolean checkConnectionRateThrottling) throws InterruptedException {
        ArrayList<AdminClient> clients = new ArrayList<AdminClient>();
        for (int i = 0; i < requests; ++i) {
            AdminClient client2 = this.testHarness.createAdminClient(tenant);
            clients.add(client2);
            String topicName = "testtopicname" + i;
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 3, 1));
            client2.createTopics(topics, new CreateTopicsOptions().timeoutMs(Integer.valueOf(1000)).retryOnQuotaViolation(false)).all();
        }
        if (checkConnectionRateThrottling) {
            TestUtils.waitForCondition(() -> this.throttlingTimeMs(tenant.logicalClusterId) > 0.0, (String)"Expected it to throttle");
        } else {
            TestUtils.waitForCondition(() -> this.throttledConnections(tenant.logicalClusterId) > 0.0, (String)"Expected it to throttle");
        }
        clients.forEach(client -> client.close(Duration.ZERO));
    }

    private void setTenantQuota(String overrideTenant, String overrideConfig, double quota) throws ExecutionException, InterruptedException {
        this.physicalCluster.superConfluentAdmin().alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", overrideTenant)), Collections.singletonList(new ClientQuotaAlteration.Op(overrideConfig, Double.valueOf(quota)))))).all().get();
        ClientQuotaFilterComponent filter = overrideTenant == null ? ClientQuotaFilterComponent.ofDefaultEntity((String)"confluent-tenant") : ClientQuotaFilterComponent.ofEntity((String)"confluent-tenant", (String)overrideTenant);
        TestUtils.waitForCondition(() -> ((Map)this.physicalCluster.superConfluentAdmin().describeClientQuotas(ClientQuotaFilter.containsOnly(Collections.singletonList(filter))).entities().get()).size() == 1, (String)"Could not describe confluent tenant client quota");
    }

    private void deleteTenantQuota(String overrideTenant, String overrideConfig) throws ExecutionException, InterruptedException {
        this.physicalCluster.superConfluentAdmin().alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(new ClientQuotaEntity(Collections.singletonMap("confluent-tenant", overrideTenant)), Collections.singletonList(new ClientQuotaAlteration.Op(overrideConfig, null))))).all().get();
        ClientQuotaFilterComponent filter = overrideTenant == null ? ClientQuotaFilterComponent.ofDefaultEntity((String)"confluent-tenant") : ClientQuotaFilterComponent.ofEntity((String)"confluent-tenant", (String)overrideTenant);
        TestUtils.waitForCondition(() -> ((Map)this.physicalCluster.superConfluentAdmin().describeClientQuotas(ClientQuotaFilter.containsOnly(Collections.singletonList(filter))).entities().get()).isEmpty(), (String)"Could not describe confluent tenant client quota");
    }

    private void assertTenantNotThrottled(LogicalClusterUser tenant, int requests, boolean checkConnectionRateThrottling) throws InterruptedException {
        ArrayList<String> allTopicNames = new ArrayList<String>();
        for (int i = 0; i < requests; ++i) {
            AdminClient client = this.testHarness.createAdminClient(tenant);
            String topicName = "testtopicname" + i;
            allTopicNames.add(topicName);
            List<NewTopic> topics = Collections.singletonList(new NewTopic(topicName, 3, 1));
            client.createTopics(topics).all();
        }
        AdminClient nonOverriddenTenant = this.testHarness.createAdminClient(tenant);
        TestUtils.waitForCondition(() -> ((Set)nonOverriddenTenant.listTopics().names().get()).containsAll(allTopicNames), (String)String.format("Could not list topic %s in time", allTopicNames));
        if (checkConnectionRateThrottling) {
            Assertions.assertEquals((double)0.0, (double)this.throttlingTimeMs(tenant.logicalClusterId));
        } else {
            Assertions.assertEquals((double)0.0, (double)this.throttledConnections(tenant.logicalClusterId));
        }
    }

    private void assertTenantNotThrottledForConnectionCount(LogicalClusterUser tenant, int requests) throws InterruptedException {
        ArrayList<AdminClient> clients = new ArrayList<AdminClient>();
        for (int i = 0; i < requests; ++i) {
            AdminClient client2 = this.testHarness.createAdminClient(tenant);
            clients.add(client2);
        }
        Assertions.assertEquals((double)0.0, (double)this.throttledConnections(tenant.logicalClusterId));
        clients.forEach(client -> client.close(Duration.ZERO));
    }

    private void assertTenantThrottledForConnectionCount(LogicalClusterUser tenant, int requests) throws InterruptedException {
        ArrayList<AdminClient> clients = new ArrayList<AdminClient>();
        for (int i = 0; i < requests; ++i) {
            AdminClient client2 = this.testHarness.createAdminClient(tenant);
            clients.add(client2);
        }
        TestUtils.waitForCondition(() -> this.throttledConnections(tenant.logicalClusterId) > 0.0, (String)"Expected it to throttle");
        clients.forEach(client -> client.close(Duration.ZERO));
    }

    private Properties rateThrottlingProps() {
        Properties props = this.nodeProps();
        props.put("max.connection.creation.rate.per.tenant.enable.threshold", "0.0");
        props.put("confluent.max.connection.creation.rate.per.tenant", "0.1");
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("confluent.track.api.key.per.ip", "true");
        props.put("confluent.track.tenant.id.per.ip", "true");
        props.put("default.replication.factor", (Object)1);
        return props;
    }

    private Properties countThrottlingProps() {
        Properties props = this.nodeProps();
        props.put("max.connections.per.tenant", "10");
        props.put("confluent.plugins.topic.policy.replication.factor", (Object)1);
        props.put("confluent.track.api.key.per.ip", "true");
        props.put("confluent.track.tenant.id.per.ip", "true");
        props.put("default.replication.factor", (Object)1);
        return props;
    }
}

