/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class OAuthIntegrationTest {
    private IntegrationTestHarness testHarness;
    private OAuthUtils.JwsContainer jwsContainer;
    private Map<String, Object> saslClientConfigs;
    private Map<String, Object> saslServerConfigs;
    private final String allowedCluster = KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId();
    private final String orgId = KafkaLogicalClusterUtils.LC_META_ABC.organizationId();
    private final String[] allowedClusters = new String[]{this.allowedCluster};
    private Path tempDir;

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        Utils.createLogicalClusterFile(KafkaLogicalClusterUtils.LC_META_ABC, this.tempDir);
        CertStores serverCertStores = new CertStores(true, "localhost");
        CertStores clientCertStores = new CertStores(false, "localhost");
        this.saslServerConfigs = serverCertStores.getTrustingConfig(clientCertStores);
        this.saslClientConfigs = clientCertStores.getTrustingConfig(serverCertStores);
        this.testHarness = new IntegrationTestHarness(testInfo);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOAuthPluginInitializesCleanlyOnServerStartup(String quorum) throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(100000, "Confluent", "Confluent", this.orgId).build();
        this.configureMechanisms("OAUTHBEARER", Collections.singletonList("OAUTHBEARER"));
        this.testHarness.start(this.brokerProps());
        this.testHarness.shutdown();
    }

    private Properties brokerProps() throws IOException {
        Properties props = new Properties();
        props.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        props.put("multitenant.metadata.class", "io.confluent.kafka.multitenant.PhysicalClusterMetadata");
        HashMap<String, Object> serverProps = new HashMap<String, Object>();
        SecurityTestUtils.attachServerOAuthConfigs(serverProps, Collections.singletonList("OAUTHBEARER"), "listener.name.external", this.jwsContainer);
        props.putAll((Map<?, ?>)serverProps);
        return props;
    }

    private void configureMechanisms(String clientMechanism, List<String> serverMechanisms) {
        SecurityTestUtils.attachMechanisms(this.saslClientConfigs, clientMechanism, this.jwsContainer, this.allowedCluster);
        SecurityTestUtils.attachServerOAuthConfigs(this.saslServerConfigs, serverMechanisms, "listener.name.sasl_ssl", this.jwsContainer);
        TestJaasConfig.createConfiguration((String)clientMechanism, serverMechanisms);
    }
}

