/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.ConnectionInformationSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionInformationSensorsTest {
    private MockTime time;
    private TenantMetricsTestUtils utils;
    private Metrics metrics;
    private MultiTenantPrincipal principal;

    @BeforeEach
    public void setUp() {
        String tenantName = "tenant";
        String userName = "user1";
        this.time = new MockTime();
        this.metrics = new Metrics((Time)this.time);
        TenantMetadata metadata = new TenantMetadata.Builder(tenantName, "u-1").build();
        this.principal = new MultiTenantPrincipal(userName, metadata);
        this.utils = new TenantMetricsTestUtils(this.metrics);
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRecordAuthenticatedConnection() {
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id");
        Sensor sensor = new ConnectionInformationSensorBuilder(this.metrics, this.principal, clientInformation, "client-id", 1000).maybeBuildAndRecord();
        Assertions.assertNotNull((Object)sensor);
        this.utils.verifyTenantMetrics((MetricsBuilderContext)context, "connection-info-rate");
    }

    @Test
    public void testRecordAuthenticatedConnectionsPerClient() {
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context1 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id1");
        Sensor sensor1 = new ConnectionInformationSensorBuilder(this.metrics, this.principal, clientInformation, "client-id1", 1000).maybeBuildAndRecord();
        Assertions.assertNotNull((Object)sensor1);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context1, false, "connection-info-rate");
        TenantMetrics.TenantConnectionInformationMetricsContext context2 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id2");
        Sensor sensor2 = new ConnectionInformationSensorBuilder(this.metrics, this.principal, clientInformation, "client-id2", 1000).maybeBuildAndRecord();
        Assertions.assertNotNull((Object)sensor2);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context2, false, "connection-info-rate");
        ClientInformation clientInformation2 = new ClientInformation("another-name", "another-version");
        TenantMetrics.TenantConnectionInformationMetricsContext context3 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation2, "client-id1");
        Sensor sensor3 = new ConnectionInformationSensorBuilder(this.metrics, this.principal, clientInformation2, "client-id1", 1000).maybeBuildAndRecord();
        Assertions.assertNotNull((Object)sensor3);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context3, false, "connection-info-rate");
    }

    @Test
    public void testSenorsExpiry() {
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id");
        Sensor sensor = new ConnectionInformationSensorBuilder(this.metrics, this.principal, clientInformation, "client-id", 1000).maybeBuildAndRecord();
        Assertions.assertNotNull((Object)sensor);
        Sensor s = TenantMetricsTestUtils.sensorForMetric(this.metrics, context.sensorSuffix(), "connection-info-rate");
        Assertions.assertNotNull((Object)s);
        this.time.setCurrentTimeMs(this.time.milliseconds() + TimeUnit.HOURS.toMillis(2L));
        Assertions.assertTrue((boolean)s.hasExpired(), (String)"We expect the sensors to expire after hour, not longer");
    }

    @Test
    public void testCap() {
        MultiTenantPrincipal[] principals;
        ClientInformation clientInformation = new ClientInformation("name", "version");
        int cap = 5;
        for (MultiTenantPrincipal principal : principals = new MultiTenantPrincipal[]{this.principal, new MultiTenantPrincipal("user2", new TenantMetadata.Builder("another-tenant", "u-2").build())}) {
            for (int i = 0; i < cap; ++i) {
                Sensor sensor = new ConnectionInformationSensorBuilder(this.metrics, principal, clientInformation, "client-id-" + i, cap).maybeBuildAndRecord();
                Assertions.assertNotNull((Object)sensor);
            }
            Sensor aboveCapSensor = new ConnectionInformationSensorBuilder(this.metrics, principal, clientInformation, "client-id-" + cap + 1, cap).maybeBuildAndRecord();
            Assertions.assertNull((Object)aboveCapSensor, (String)"Shouldn't create a sensor if we've seen more client IDs than the cap");
            for (int i = 0; i < cap; ++i) {
                Sensor sensor = new ConnectionInformationSensorBuilder(this.metrics, principal, clientInformation, "client-id-" + i, cap).maybeBuildAndRecord();
                Assertions.assertNotNull((Object)sensor);
            }
        }
        this.time.setCurrentTimeMs(this.time.milliseconds() + TimeUnit.HOURS.toMillis(2L));
        Sensor sensor = new ConnectionInformationSensorBuilder(this.metrics, this.principal, clientInformation, "client-id-" + cap + 1, cap).maybeBuildAndRecord();
        Assertions.assertNotNull((Object)sensor, (String)"Delay passed, we should be above cap now");
    }
}

