/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.TestLogicalClusterMetadata;
import io.confluent.kafka.server.plugins.auth.TestPhysicalClusterMetadata;
import io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.TopicBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicBasedPlainSaslAuthenticatorTest {
    @Test
    public void testVerifyValidNetworkId() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), TrafficNetworkIdValidationMode.STRICT);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.PL_PUBLIC_IP_NLB);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
        authenticator = this.createAuthenticator(new TrafficNetworkIdRoutes(Arrays.asList("ne1", "ne2"), null), TrafficNetworkIdValidationMode.NONE, CCloudTrafficType.PL_PUBLIC_IP_NLB);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
    }

    @Test
    public void testVerifyInvalidNetworkId() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), TrafficNetworkIdValidationMode.STRICT);
        this.assertInvalidNetworkFailsAuth(authenticator);
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.PL_PUBLIC_IP_NLB);
        this.assertInvalidNetworkFailsAuth(authenticator);
        authenticator = this.createAuthenticator(new TrafficNetworkIdRoutes(Arrays.asList("ne1", "ne2"), null), TrafficNetworkIdValidationMode.NONE, CCloudTrafficType.PL_PUBLIC_IP_NLB);
        this.assertInvalidNetworkFailsAuth(authenticator);
    }

    private void assertInvalidNetworkFailsAuth(TopicBasedPlainSaslAuthenticator authenticator) {
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        Assertions.assertTrue((boolean)exception.errorInfo().errorMessage().contains("isn't allowed to communicate to the cluster ID"));
    }

    @Test
    public void testRoutesNotYetLoaded() throws Exception {
        TrafficNetworkIdRoutes routes = null;
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(routes, TrafficNetworkIdValidationMode.STRICT);
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
        Assertions.assertTrue((boolean)exception.errorInfo().errorMessage().contains("validation failed due to an internal error"));
    }

    @Test
    public void testRoutesNotYetLoadedNoneMode() throws Exception {
        TrafficNetworkIdRoutes routes = null;
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(routes, TrafficNetworkIdValidationMode.NONE);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("ne1")));
    }

    @Test
    public void testVerifyNoneMode() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), TrafficNetworkIdValidationMode.NONE);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), (TrafficNetworkIdValidationMode)null);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.UNKNOWN);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
        authenticator = this.createAuthenticator(Arrays.asList("ne1", "ne2"), CCloudTrafficType.PL_PRIVATE_LINK_NLB);
        Assertions.assertTrue((boolean)authenticator.verifyNetworkId(this.getUserInfo(), "test", Optional.of("neInvalid")));
    }

    @Test
    public void testVerifyListenerStrictModeOverridesTlvNoneMode() throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(new TrafficNetworkIdRoutes(Arrays.asList("ne1", "ne2"), null), TrafficNetworkIdValidationMode.STRICT, CCloudTrafficType.UNKNOWN);
        this.assertInvalidNetworkFailsAuth(authenticator);
    }

    @Test
    public void testDefaultDataPolicy() throws Exception {
        String brokerSessionUuid = Uuid.randomUuid().toString();
        TopicBasedPlainSaslAuthenticator authenticator = this.createAuthenticator(brokerSessionUuid, DefaultDataPolicyValidationMode.NONE, null);
        Assertions.assertTrue((boolean)authenticator.verifyDefaultDataPolicy(this.getUserInfo(), "test", new DefaultDataPolicyContext.Builder().build()));
        TopicBasedPlainSaslAuthenticator strictAuthenticator = this.createAuthenticator(brokerSessionUuid, DefaultDataPolicyValidationMode.STRICT, null);
        this.verifyAuthError(strictAuthenticator, "", SaslInternalConfigs.NetworkType.PRIVATE, true, "cluster metadata not found");
        TestPhysicalClusterMetadata testPkcMetadata = new TestPhysicalClusterMetadata();
        TestPhysicalClusterMetadata.addInstance(brokerSessionUuid, testPkcMetadata);
        this.verifyAuthError(strictAuthenticator, "org-1", SaslInternalConfigs.NetworkType.PRIVATE, true, "logical cluster metadata not found");
        TestLogicalClusterMetadata testLkcMetadata = new TestLogicalClusterMetadata(this.getUserInfo().logicalClusterId, "org-1", "env-1");
        testPkcMetadata.addLogicalCluster(testLkcMetadata);
        Assertions.assertTrue((boolean)authenticator.verifyDefaultDataPolicy(this.getUserInfo(), "test", new DefaultDataPolicyContext.Builder("org-1", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build()));
        this.verifyAuthError(strictAuthenticator, "org-1", SaslInternalConfigs.NetworkType.PUBLIC, true, "isn't allowed to communicate to the cluster");
        this.verifyAuthError(strictAuthenticator, "org-1", SaslInternalConfigs.NetworkType.NOT_SET, true, "isn't allowed to communicate to the cluster");
        this.verifyAuthError(strictAuthenticator, "org-2", SaslInternalConfigs.NetworkType.PRIVATE, true, "isn't allowed to communicate to the cluster");
        this.verifyAuthError(strictAuthenticator, "org-1", SaslInternalConfigs.NetworkType.PRIVATE, false, "isn't allowed to communicate to the cluster");
        TopicBasedPlainSaslAuthenticator denyAuthenticator = this.createAuthenticator(brokerSessionUuid, DefaultDataPolicyValidationMode.STRICT, "foo,org-1");
        this.verifyAuthError(denyAuthenticator, "org-1", SaslInternalConfigs.NetworkType.PRIVATE, true, "isn't allowed to communicate to the cluster");
        TopicBasedPlainSaslAuthenticator denyAuthenticatorWithDifferentOrgs = this.createAuthenticator(brokerSessionUuid, DefaultDataPolicyValidationMode.STRICT, "foo,org-2");
        Assertions.assertTrue((boolean)denyAuthenticatorWithDifferentOrgs.verifyDefaultDataPolicy(this.getUserInfo(), "test", new DefaultDataPolicyContext.Builder("org-1", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build()));
        TopicBasedPlainSaslAuthenticator denyAuthenticatorEmptyOrgs = this.createAuthenticator(brokerSessionUuid, DefaultDataPolicyValidationMode.STRICT, "");
        Assertions.assertTrue((boolean)denyAuthenticatorEmptyOrgs.verifyDefaultDataPolicy(this.getUserInfo(), "test", new DefaultDataPolicyContext.Builder("org-1", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build()));
    }

    private MultiTenantSaslConfigEntry getUserInfo() {
        return new MultiTenantSaslConfigEntry("PLAIN", "foobar", "none", "23", "lkc-bkey", false, "u-23");
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(List<String> routesList, TrafficNetworkIdValidationMode networkIdValidationMode) throws Exception {
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(routesList, null);
        return this.createAuthenticator(routes, networkIdValidationMode, null);
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(List<String> routesList, CCloudTrafficType trafficTypeTlv) throws Exception {
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(routesList, null);
        return this.createAuthenticator(routes, null, trafficTypeTlv);
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(TrafficNetworkIdRoutes routes, TrafficNetworkIdValidationMode networkIdValidationMode) throws Exception {
        return this.createAuthenticator(routes, networkIdValidationMode, null);
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(TrafficNetworkIdRoutes routes, TrafficNetworkIdValidationMode networkIdValidationMode, CCloudTrafficType trafficTypeTlv) throws Exception {
        String brokerSessionUuid = Uuid.randomUuid().toString();
        TrafficNetworkIdRoutesStore.addRoutes((String)brokerSessionUuid, (TrafficNetworkIdRoutes)routes);
        TopicBasedPlainSaslAuthenticator authenticator = new TopicBasedPlainSaslAuthenticator(null, brokerSessionUuid, trafficTypeTlv, null);
        HashMap<String, String> options = new HashMap<String, String>();
        if (networkIdValidationMode != null) {
            options.put("traffic_network_id_validation_mode", networkIdValidationMode.name());
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(TopicBasedLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        List<AppConfigurationEntry> jaasEntries = Collections.singletonList(entry);
        authenticator.initialize(jaasEntries);
        if (trafficTypeTlv != null && trafficTypeTlv.shouldValidateTraffic()) {
            Assertions.assertEquals((Object)TrafficNetworkIdValidationMode.STRICT, (Object)authenticator.networkIdValidationMode);
        } else if (networkIdValidationMode != null) {
            Assertions.assertEquals((Object)authenticator.networkIdValidationMode, (Object)networkIdValidationMode);
        } else {
            Assertions.assertEquals((Object)authenticator.networkIdValidationMode, (Object)TrafficNetworkIdValidationMode.NONE);
        }
        return authenticator;
    }

    private TopicBasedPlainSaslAuthenticator createAuthenticator(String brokerSessionUuid, DefaultDataPolicyValidationMode defaultDataPolicyValidationMode, String denyOrgIds) throws Exception {
        TopicBasedPlainSaslAuthenticator authenticator = new TopicBasedPlainSaslAuthenticator(null, brokerSessionUuid, CCloudTrafficType.UNKNOWN, (List)ConfigDef.parseType((String)"denyOrgIds", (Object)denyOrgIds, (ConfigDef.Type)ConfigDef.Type.LIST));
        HashMap<String, String> options = new HashMap<String, String>();
        if (defaultDataPolicyValidationMode != null) {
            options.put("default_data_policy_validation_mode", defaultDataPolicyValidationMode.name());
        }
        AppConfigurationEntry entry = new AppConfigurationEntry(TopicBasedLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        List<AppConfigurationEntry> jaasEntries = Collections.singletonList(entry);
        authenticator.initialize(jaasEntries);
        if (defaultDataPolicyValidationMode != null) {
            Assertions.assertEquals((Object)authenticator.defaultDataPolicyValidationMode, (Object)defaultDataPolicyValidationMode);
        } else {
            Assertions.assertEquals((Object)authenticator.defaultDataPolicyValidationMode, (Object)TrafficNetworkIdValidationMode.NONE);
        }
        return authenticator;
    }

    private void verifyAuthError(TopicBasedPlainSaslAuthenticator authenticator, String organizationId, SaslInternalConfigs.NetworkType networkType, Boolean hasPeerCertificate, String errorMessage) {
        SaslAuthenticationException exception = (SaslAuthenticationException)Assertions.assertThrows(SaslAuthenticationException.class, () -> authenticator.verifyDefaultDataPolicy(this.getUserInfo(), "test", new DefaultDataPolicyContext.Builder(organizationId, networkType, hasPeerCertificate).build()));
        Assertions.assertTrue((boolean)exception.errorInfo().errorMessage().contains(errorMessage));
    }
}

