/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.multitenant.TopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthBearerServerLoginCallbackHandler;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthBearerValidatorCallbackHandler;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import io.confluent.security.authentication.oidc.MetadataResponse;
import io.confluent.security.fixtures.http.JerseyHttpService;
import io.confluent.security.fixtures.jwt.TestJwkProvider;
import io.confluent.security.fixtures.jwt.TestJwtProvider;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.security.auth.callback.Callback;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.test.TestUtils;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class OAuthBearerValidatorCallbackHandlerTest {
    private static final List<String> ALLOWED_LOGICAL_CLUSTERS = Collections.singletonList(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId());
    private static final String ORG_RESOURCE_ID = KafkaLogicalClusterUtils.LC_META_ABC.organizationId();
    private static final OAuthBearerJwsToken TOKEN_MOCK = new OAuthBearerJwsToken("", new HashSet<String>(Arrays.asList(ORG_RESOURCE_ID)), 0L, "", Long.valueOf(0L), Collections.singletonMap("orgResourceId", ORG_RESOURCE_ID));
    private static final OAuthBearerJwsToken INVALID_ORG_TOKEN_MOCK = new OAuthBearerJwsToken("", new HashSet<String>(Arrays.asList("org_1")), 0L, "", Long.valueOf(0L), Collections.singletonMap("orgResourceId", "org_1"));
    private static final String DEFAULT_ISSUER = "Confluent";
    private static final String DEFAULT_SUBJECT = "Customer";
    private OAuthUtils.JwsContainer jwsContainer;
    private TopicBasedPhysicalClusterMetadata metadata;
    private Map<String, Object> configs;
    private String brokerUUID;
    private static JerseyHttpService server;
    private static URI providerURI;
    private static ObjectMapper objectMapper;
    private static TestJwkProvider jwks;
    private static MetadataResponse providerContext;
    private Path tempDir;

    @BeforeAll
    public static void setUpStaticResources() throws Exception {
        objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new Jdk8Module());
        jwks = new TestJwkProvider();
        server = new JerseyHttpService(new Consumer[]{configurable -> {
            configurable.register(TestJwtProvider.class);
            configurable.register((Object)new JacksonJaxbJsonProvider(objectMapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
            configurable.register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bind(jwks).to(TestJwkProvider.class);
                }
            });
        }});
        server.start();
        providerURI = server.getURI();
        providerContext = (MetadataResponse)objectMapper.readValue(providerURI.resolve("/.well-known/openid-configuration").toURL(), MetadataResponse.class);
    }

    @AfterAll
    public static void tearDownResources() throws Exception {
        if (server != null) {
            server.stop();
            server = null;
            providerURI = null;
            jwks = null;
            objectMapper = null;
            providerContext = null;
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.tempDir = TestUtils.tempDirectory().toPath();
        this.brokerUUID = "uuid";
        this.configs = new HashMap<String, Object>();
        this.configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        this.initiateTopicBasedPhysicalClusterMetadata(this.configs);
    }

    @AfterEach
    public void tearDown() {
        this.metadata.close(this.brokerUUID);
        KafkaTestUtils.verifyThreadCleanup();
    }

    private void initiateTopicBasedPhysicalClusterMetadata(Map<String, Object> configs) {
        this.metadata = (TopicBasedPhysicalClusterMetadata)Mockito.mock(TopicBasedPhysicalClusterMetadata.class);
        ((TopicBasedPhysicalClusterMetadata)Mockito.doCallRealMethod().when((Object)this.metadata)).configure((Map)ArgumentMatchers.any(Map.class));
        ((TopicBasedPhysicalClusterMetadata)Mockito.doCallRealMethod().when((Object)this.metadata)).getSessionUuid((Map)ArgumentMatchers.any(Map.class));
        ((TopicBasedPhysicalClusterMetadata)Mockito.doCallRealMethod().when((Object)this.metadata)).close((String)ArgumentMatchers.any(String.class));
        try {
            this.metadata.configure(configs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Mockito.when((Object)this.metadata.metadata(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId())).thenReturn((Object)KafkaLogicalClusterUtils.LC_META_ABC);
        Mockito.when((Object)this.metadata.logicalClusterIds()).thenReturn(Collections.singleton(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId()));
    }

    @Test
    public void testAttachesJws() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assertions.assertNotNull((Object)callback.token());
        Assertions.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assertions.assertNull((Object)callback.errorStatus());
    }

    @Test
    public void testPopulatesInvalidExtensionsWhenNoLogicalClusterMetadata() throws Exception {
        this.deleteLogicalClusterMetadata();
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId());
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToLogicalClusterNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyMatchTokensLogicalClusterAndIsHostedOnBroker() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyStartWithPkcLegacySniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "pkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterNoBelongToOrg() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "pkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)INVALID_ORG_TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToLogicalClusterNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyMatchTokensLogicalClusterLegacySniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId() + "-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenNotProvidedLegacySniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", null);
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenTheyNotMatchTokensLogicalClusterLegacySniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.ALLOW_LEGACY_BOOTSTRAP);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "lkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsValidatedWhenTheyMatchTokensLogicalClusterStrictSniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.STRICT);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId() + "-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifySuccessfulAuthentication(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenSNIHostNameNotMatchingStrictSniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.STRICT);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", "lkc-wrong-123.confluent.io");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testLogicalClusterExtensionsFailedWhenSNIHostNameIsNotSuppliedStrictSniValidationMode() throws Exception {
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions(), SniValidationMode.STRICT);
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", ALLOWED_LOGICAL_CLUSTERS.get(0));
        extensions.put("__confluent_sni_broker_host_name", null);
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)TOKEN_MOCK, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToSniHostNameNotMatched(callback);
    }

    @Test
    public void testPopulatesInvalidExtensionsWhenLogicalClusterIsNotHostedOnBroker() throws Exception {
        List<String> allowedLogicalClusters = Collections.singletonList("cp12");
        OAuthBearerJwsToken tokenMock = new OAuthBearerJwsToken("", new HashSet<String>(allowedLogicalClusters), 0L, "", Long.valueOf(0L));
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("logicalCluster", allowedLogicalClusters.get(0));
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback((OAuthBearerToken)tokenMock, new SaslExtensions(extensions));
        callbackHandler.handle(new Callback[]{callback});
        this.verifyFailedAuthenticationDueToLogicalClusterNotMatched(callback);
    }

    @Test
    public void testConfigureRaisesExceptionWhenInvalidKeyPath() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        Map<String, String> options = this.baseOptions();
        options.put("jwksLocation", this.jwsContainer.getPublicKeyFile().getAbsolutePath() + "/invalid!");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testConfigureDoesNotRaiseExceptionWithoutPublicKeyPath() {
        this.createCallbackHandler(new OAuthBearerServerLoginCallbackHandler(), new HashMap<String, String>(), SniValidationMode.OPTIONAL_VALIDATION);
    }

    @Test
    public void testConfigureRaisesExceptionWhenInvalidPhysicalMetadataInstance() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        this.configs.put("broker.session.uuid", "made-up");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(this.baseOptions()));
    }

    @Test
    public void testRaisesJwtExceptionWhenInvalidJws() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        OAuthUtils.writePemFile(this.jwsContainer.getPublicKeyFile(), OAuthUtils.generateKeyPair().getPublic());
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionWhenExpiredJws() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(50, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        Thread.sleep(100L);
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionIfDifferentIssuer() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, "AWS", DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionIfMissingSubject() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, null, ORG_RESOURCE_ID).build();
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testRaisesJwtExceptionIfNoExpirationTime() throws Exception {
        this.jwsContainer = new OAuthUtils.Builder(null, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testKeyResolverHttps() throws Exception {
        jwks.createJwkIfAbsent("");
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("verificationKeyResolver", "https");
        options.put("allowUnsafeURL", "true");
        options.put("jwksLocation", providerContext.jwksEndpoint().toString());
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(options);
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testKeyResolverHttpsNoJwksUri() throws Exception {
        jwks.createJwkIfAbsent("");
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("verificationKeyResolver", "https");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testKeyResolverJku() throws Exception {
        jwks.createJwkIfAbsent("");
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("verificationKeyResolver", "jku");
        options.put("jkuDomainWhiteList", "localhost");
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(options);
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    @Test
    public void testKeyResolverJkuNoWhiteList() throws Exception {
        jwks.createJwkIfAbsent("");
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("verificationKeyResolver", "jku");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testKeyResolverJkuEmptyWhiteList() throws Exception {
        jwks.createJwkIfAbsent("");
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("verificationKeyResolver", "jku");
        options.put("jkuDomainWhiteList", "");
        Assertions.assertThrows(ConfigException.class, () -> this.createCallbackHandler(options));
    }

    @Test
    public void testInvalidIssuer() throws Exception {
        jwks.createJwkIfAbsent("");
        this.jwsContainer = new OAuthUtils.Builder(3600, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("issuer", providerContext.issuer().toString());
        options.put("verificationKeyResolver", "pemfile");
        options.put("jwksLocation", this.jwsContainer.getPublicKeyFile().toString());
        OAuthBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(options);
        Assertions.assertThrows(JwtVerificationException.class, () -> callbackHandler.processToken(this.jwsContainer.getJwsToken()));
    }

    private void verifySuccessfulAuthentication(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertTrue((boolean)callback.errorMessage().isEmpty());
    }

    private void verifyFailedAuthenticationDueToLogicalClusterNotMatched(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertNotNull(callback.invalidExtensions().get("logicalCluster"));
        Assertions.assertFalse((boolean)callback.errorMessage().isEmpty());
    }

    private void verifyFailedAuthenticationDueToSniHostNameNotMatched(OAuthBearerExtensionsValidatorCallback callback) {
        Assertions.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertNotNull(callback.invalidExtensions().get("__confluent_sni_broker_host_name"));
        Assertions.assertFalse((boolean)callback.errorMessage().isEmpty());
    }

    private void deleteLogicalClusterMetadata() {
        Mockito.when((Object)this.metadata.metadata(KafkaLogicalClusterUtils.LC_META_ABC.logicalClusterId())).thenReturn(null);
        Mockito.when((Object)this.metadata.logicalClusterIds()).thenReturn(Collections.emptySet());
    }

    private OAuthBearerValidatorCallbackHandler createCallbackHandler(Map<String, String> options) {
        return this.createCallbackHandler(options, SniValidationMode.OPTIONAL_VALIDATION);
    }

    private OAuthBearerValidatorCallbackHandler createCallbackHandler(Map<String, String> options, SniValidationMode mode) {
        return this.createCallbackHandler(new OAuthBearerValidatorCallbackHandler(), options, mode);
    }

    private <T extends AuthenticateCallbackHandler> T createCallbackHandler(T callbackHandler, Map<String, String> options, SniValidationMode mode) {
        TestJaasConfig config = new TestJaasConfig();
        options.put("sni_host_name_validation_mode", mode.getText());
        config.createOrUpdateEntry("Kafka", OAuthBearerLoginModule.class.getCanonicalName(), options);
        callbackHandler.configure(this.configs, "OAUTHBEARER", Collections.singletonList(config.getAppConfigurationEntry("Kafka")[0]));
        return callbackHandler;
    }

    private Map<String, String> baseOptions() throws Exception {
        if (this.jwsContainer == null) {
            this.jwsContainer = new OAuthUtils.Builder(36000, DEFAULT_ISSUER, DEFAULT_SUBJECT, ORG_RESOURCE_ID).build();
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("verificationKeyResolver", "pemfile");
        options.put("jwksLocation", this.jwsContainer.getPublicKeyFile().getAbsolutePath());
        options.put("audience", String.join((CharSequence)",", new CharSequence[0]));
        return options;
    }
}

