/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.ssl;

import io.confluent.kafka.server.plugins.ssl.ConfluentTrustProviderCreator;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.security.DefaultRequestCallbackManager;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class ConfluentTrustManagerInterBrokerTest {
    private static final int BUFFER_SIZE = 4096;
    private static final Time TIME = Time.SYSTEM;
    private NioEchoServer server;
    private Selector selector;
    private Map<String, Object> sslClientConfigs;
    private Map<String, Object> sslServerConfigs;

    private void setupInterBroker(String clientCN, String serverSanHostName, String hostSuffixesConfig, Class<?> sslEngineFactoryClass) throws Exception {
        SecurityProtocol securityProtocol = SecurityProtocol.SSL;
        CertStores serverCertStores = new CertStores(true, serverSanHostName, serverSanHostName);
        SecurityTestUtils.clearSecurityConfigs();
        CertStores clientCertStores = new CertStores(false, clientCN, clientCN);
        this.sslServerConfigs = serverCertStores.getTrustingConfig(clientCertStores);
        this.sslClientConfigs = clientCertStores.getTrustingConfig(serverCertStores);
        this.sslServerConfigs.put("security.providers", ConfluentTrustProviderCreator.class.getName());
        this.sslServerConfigs.put("ssl.trustmanager.algorithm", "ConfluentTls");
        this.sslServerConfigs.put("ssl.engine.factory.class", sslEngineFactoryClass);
        this.sslServerConfigs.put("ssl.client.auth", "required");
        this.sslServerConfigs.put("confluent.ccloud.host.suffixes", hostSuffixesConfig);
        this.sslClientConfigs.put("security.providers", ConfluentTrustProviderCreator.class.getName());
        this.sslClientConfigs.put("ssl.trustmanager.algorithm", "ConfluentTls");
        this.sslClientConfigs.put("ssl.endpoint.identification.algorithm", "");
        this.sslClientConfigs.put("confluent.ccloud.host.suffixes", hostSuffixesConfig);
        this.sslServerConfigs.putAll(serverCertStores.keyStoreProps());
        this.sslServerConfigs.putAll(serverCertStores.trustStoreProps());
        this.sslClientConfigs.putAll(serverCertStores.keyStoreProps());
        this.sslClientConfigs.putAll(serverCertStores.trustStoreProps());
        TestSecurityConfig config = new TestSecurityConfig(this.sslServerConfigs);
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        ChannelBuilder serverChannelBuilder = ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (boolean)true, (SecurityProtocol)securityProtocol, (AbstractConfig)config, null, null, (Time)Time.SYSTEM, (LogContext)new LogContext(), this.defaultApiVersionsSupplier(), (RequestCallback)new DefaultRequestCallbackManager());
        this.server = new NioEchoServer(listenerName, securityProtocol, (AbstractConfig)config, "localhost", serverChannelBuilder, null, Time.SYSTEM);
        this.server.start();
        LogContext logContext = new LogContext();
        SslChannelBuilder clientChannelBuilder = new SslChannelBuilder(ConnectionMode.CLIENT, null, false, logContext, new ProxyProtocolEngineFactory(ProxyProtocol.NONE));
        clientChannelBuilder.configure(this.sslClientConfigs);
        this.selector = new Selector(5000L, new Metrics(), Time.SYSTEM, "MetricGroup", (ChannelBuilder)clientChannelBuilder, logContext);
    }

    private Function<Short, ApiVersionsResponse> defaultApiVersionsSupplier() {
        return version -> TestUtils.confluentCloudApiVersionsResponse((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
    }

    @AfterEach
    public void teardown() throws Exception {
        SecurityTestUtils.clearSecurityConfigs();
        if (this.selector != null) {
            this.selector.close();
        }
        if (this.server != null) {
            this.server.close();
        }
    }

    private void checkAuthenticationSucceed() throws IOException, InterruptedException {
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect("0", addr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady((Selector)this.selector, (String)"0");
        this.server.verifyAuthenticationMetrics(1, 0);
    }

    @ParameterizedTest(name="{displayName}.sslEngineFactoryClass={0}")
    @ValueSource(classes={DefaultSslEngineFactory.class, NettySslEngineFactory.class})
    public void testSuccessfulHandshakeWithInterBroker(Class<?> sslEngineFactoryClass) throws Exception {
        this.setupInterBroker("client1.us-west-1.aws.confluent.testhost1", "server1.us-west-1.aws.confluent.testhost2", "testhost1,testhost2", sslEngineFactoryClass);
        this.checkAuthenticationSucceed();
    }

    @ParameterizedTest(name="{displayName}.sslEngineFactoryClass={0}")
    @ValueSource(classes={DefaultSslEngineFactory.class, NettySslEngineFactory.class})
    public void testHandshakeFailureWithInterBroker(Class<?> sslEngineFactoryClass) throws Exception {
        Assertions.assertThrows(KafkaException.class, () -> this.setupInterBroker("client1.us-west-1.aws.confluent.testhost3", "server1.us-west-1.aws.confluent.testhost4", "testhost1,testhost2", sslEngineFactoryClass));
    }
}

