/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.ssl;

import io.confluent.kafka.server.plugins.ssl.ConfluentTrustProviderCreator;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SslAuthenticationException;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.SaslAuthenticatorTest;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.test.ValuelessCallable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ConfluentTrustProviderTransportLayerTest {
    private static final long CONNECTIONS_MAX_REAUTH_MS_VALUE = 100L;
    private static Time time = Time.SYSTEM;
    private static Map<String, Object> pp2ValidateTrafficHeader = Collections.singletonMap("confluent.ccloud.traffic.type", CCloudTrafficType.PL_PUBLIC_IP_NLB);
    private static Map<String, Object> pp2NoValidateTrafficHeader = Collections.singletonMap("confluent.ccloud.traffic.type", CCloudTrafficType.PL_PRIVATE_LINK_NLB);
    private static final int BUFFER_SIZE = 4096;
    private static final Time TIME = Time.SYSTEM;
    private NioEchoServer server;
    private String brokerSessionUuId;
    private Selector selector;
    private Map<String, Object> saslClientConfigs;
    private Map<String, Object> saslServerConfigs;
    private CredentialCache credentialCache;
    private String clientCN;
    private int successfulAuthentication = 0;
    private int failedAuthentication = 0;

    private void setupAndRunTest(boolean useProxyProtocolV2, boolean useNetworkLinkAlgorithm, SslClientAuth proxyProtocol2ClientAuth, String clientCN, Class<?> sslEngineFactoryClass, Map<String, Object> pp2TrafficHeaders, ValuelessCallable test) throws Exception {
        SecurityTestUtils.clearSecurityConfigs();
        this.brokerSessionUuId = Uuid.randomUuid().toString();
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(Arrays.asList("n1"), Arrays.asList(new String[0]));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuId, (TrafficNetworkIdRoutes)routes);
        this.clientCN = clientCN;
        this.credentialCache = new CredentialCache();
        CertStores serverCertStores = new CertStores(true, "localhost", "localhost");
        CertStores clientCertStores = new CertStores(false, clientCN, clientCN);
        this.saslServerConfigs = serverCertStores.getTrustingConfig(clientCertStores);
        this.saslClientConfigs = clientCertStores.getTrustingConfig(serverCertStores);
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_SSL;
        String listenerPrefix = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).configPrefix();
        this.configureMechanisms("PLAIN", Collections.singletonList("PLAIN"));
        if (useProxyProtocolV2) {
            this.saslServerConfigs.put(listenerPrefix + "ssl.client.auth", proxyProtocol2ClientAuth.name());
        } else {
            this.saslServerConfigs.put(listenerPrefix + "ssl.client.auth", SslClientAuth.REQUIRED.name());
        }
        this.saslServerConfigs.put("principal.builder.class", SaslAuthenticatorTest.SaslSslPrincipalBuilder.class.getName());
        this.saslServerConfigs.put("ssl.engine.factory.class", sslEngineFactoryClass);
        this.saslServerConfigs.put("confluent.security.revoked.certificate.ids", " ");
        this.saslServerConfigs.put("broker.session.uuid", this.brokerSessionUuId);
        this.createClient(useProxyProtocolV2, securityProtocol, pp2TrafficHeaders);
        this.server = this.createEchoServer(useProxyProtocolV2, useNetworkLinkAlgorithm, securityProtocol);
        test.call();
    }

    private NioEchoServer createEchoServer(boolean useProxyProtocolV2, boolean useNetworkLinkAlgorithm, SecurityProtocol securityProtocol) throws Exception {
        this.saslServerConfigs.put("security.providers", ConfluentTrustProviderCreator.class.getName());
        if (useNetworkLinkAlgorithm) {
            this.saslServerConfigs.put("ssl.trustmanager.algorithm", "ConfluentNetworkLinkTls");
        } else {
            this.saslServerConfigs.put("ssl.trustmanager.algorithm", "ConfluentTls");
        }
        if (useProxyProtocolV2) {
            return NetworkTestUtils.createEchoServer((ListenerName)ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), (SecurityProtocol)securityProtocol, (AbstractConfig)new TestSecurityConfig(this.saslServerConfigs), (CredentialCache)this.credentialCache, (int)100, (Time)time, (DelegationTokenCache)new DelegationTokenCache(ScramMechanism.mechanismNames()), (ProxyProtocolEngineFactory)new ProxyProtocolEngineFactory(ProxyProtocol.V2));
        }
        return NetworkTestUtils.createEchoServer((ListenerName)ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), (SecurityProtocol)securityProtocol, (AbstractConfig)new TestSecurityConfig(this.saslServerConfigs), (CredentialCache)this.credentialCache, (Time)TIME);
    }

    private void createClient(boolean useProxyProtocolV2, SecurityProtocol securityProtocol, Map<String, Object> pp2TrafficHeaders) {
        ProxyProtocolEngineFactory proxyProtocolEngineFactory;
        LogContext logContext = new LogContext();
        String saslMechanism = (String)this.saslClientConfigs.get("sasl.mechanism");
        if (useProxyProtocolV2) {
            HashMap<String, Object> clientConfigs = new HashMap<String, Object>(this.saslClientConfigs);
            clientConfigs.put("confluent.proxy.protocol.client.address", "1.1.1.1");
            clientConfigs.put("confluent.proxy.protocol.client.port", 1111);
            clientConfigs.put("confluent.proxy.protocol.client.mode", ConfluentConfigs.PROXY_PROTOCOL_CLIENT_MODE_DEFAULT);
            clientConfigs.putAll(pp2TrafficHeaders);
            proxyProtocolEngineFactory = new ProxyProtocolEngineFactory(ProxyProtocol.V2, clientConfigs, ConnectionMode.CLIENT, logContext);
        } else {
            proxyProtocolEngineFactory = new ProxyProtocolEngineFactory(ProxyProtocol.NONE);
        }
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)securityProtocol, (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)new TestSecurityConfig(this.saslClientConfigs), null, (String)saslMechanism, (Time)time, (boolean)true, (LogContext)logContext, null, (ProxyProtocolEngineFactory)proxyProtocolEngineFactory);
        this.selector = NetworkTestUtils.createSelector((ChannelBuilder)channelBuilder, (Time)time);
    }

    private TestJaasConfig configureMechanisms(String clientMechanism, List<String> serverMechanisms) {
        this.saslClientConfigs.put("sasl.mechanism", clientMechanism);
        this.saslServerConfigs.put("sasl.enabled.mechanisms", serverMechanisms);
        this.saslServerConfigs.put("connections.max.reauth.ms", 100L);
        return TestJaasConfig.createConfiguration((String)clientMechanism, serverMechanisms);
    }

    @AfterEach
    public void teardown() throws Exception {
        SecurityTestUtils.clearSecurityConfigs();
        this.closeClientConnectionIfNecessary();
        if (this.server != null) {
            this.server.close();
        }
    }

    private void closeClientConnectionIfNecessary() throws Exception {
        if (this.selector != null) {
            this.selector.close();
            this.selector = null;
        }
    }

    private void checkAuthenticationFailed(boolean useProxyProtocolV2) throws IOException, InterruptedException {
        String node = "0";
        this.createClientConnection(node);
        ChannelState finalState = NetworkTestUtils.waitForChannelClose((Selector)this.selector, (String)node, (ChannelState.State)ChannelState.State.AUTHENTICATION_FAILED);
        AuthenticationException exception = finalState.exception();
        Assertions.assertEquals(SslAuthenticationException.class, exception.getClass());
        ++this.failedAuthentication;
        this.server.verifyAuthenticationMetrics(this.successfulAuthentication, this.failedAuthentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAuthenticationSucceed(boolean useOneWayTLS) throws Exception {
        try {
            Assertions.assertEquals(Collections.emptyList(), (Object)this.server.selector().channels());
            String node = "0";
            this.createClientConnection(node);
            NetworkTestUtils.waitForChannelReady((Selector)this.selector, (String)node);
            if (useOneWayTLS) {
                KafkaPrincipal principalWithOneWayTls = SaslAuthenticatorTest.SaslSslPrincipalBuilder.saslSslPrincipal((String)"myuser", (String)"ANONYMOUS");
                Assertions.assertEquals((Object)principalWithOneWayTls, (Object)((KafkaChannel)this.server.selector().channels().get(0)).principal());
            } else {
                String certDn = "O=A client,CN=" + this.clientCN;
                KafkaPrincipal principalWithMutualTls = SaslAuthenticatorTest.SaslSslPrincipalBuilder.saslSslPrincipal((String)"myuser", (String)certDn);
                Assertions.assertEquals((Object)principalWithMutualTls, (Object)((KafkaChannel)this.server.selector().channels().get(0)).principal());
            }
            ++this.successfulAuthentication;
            this.server.verifyAuthenticationMetrics(this.successfulAuthentication, this.failedAuthentication);
            NetworkTestUtils.checkClientConnection((Selector)this.selector, (String)node, (int)100, (int)10);
        }
        finally {
            this.closeClientConnectionIfNecessary();
            TestUtils.waitForCondition(() -> this.server.selector().channels().isEmpty(), (String)"Channel not removed after disconnection");
        }
    }

    private void createClientConnection(String node) throws IOException {
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
    }

    @ParameterizedTest(name="{displayName}.{0}.{1}.{2}")
    @MethodSource(value={"allCombinations"})
    public void testSuccessfulHandshakeWithCCloudClient(boolean useProxyProtocolV2, boolean verifyClientDNSDomain, SslClientAuth proxyProtocol2ClientAuth, Class<?> sslEngineFactoryClass) throws Exception {
        this.setupAndRunTest(useProxyProtocolV2, verifyClientDNSDomain, proxyProtocol2ClientAuth, "client1.us-west-1.aws.confluent.cloud", sslEngineFactoryClass, pp2ValidateTrafficHeader, () -> this.checkAuthenticationSucceed(false));
    }

    @ParameterizedTest(name="{displayName}.{0}.{1}.{2}.{3}")
    @MethodSource(value={"allCombinations"})
    public void testHandshakeFailureWithLocalClient(boolean useProxyProtocolV2, boolean verifyClientDNSDomain, SslClientAuth proxyProtocol2ClientAuth, Class<?> sslEngineFactoryClass) throws Exception {
        this.setupAndRunTest(useProxyProtocolV2, verifyClientDNSDomain, proxyProtocol2ClientAuth, "localhost", sslEngineFactoryClass, pp2ValidateTrafficHeader, () -> this.checkAuthenticationFailed(useProxyProtocolV2));
    }

    @Test
    public void testSuccessfulHandshakeWithLocalClientPP2NoValidateMutualTls() throws Exception {
        this.setupAndRunTest(true, false, SslClientAuth.REQUESTED, "localhost", DefaultSslEngineFactory.class, pp2NoValidateTrafficHeader, () -> this.checkAuthenticationSucceed(false));
    }

    @Test
    public void testSuccessfulHandshakeWithLocalClientPP2NoValidateOneWayTls() throws Exception {
        this.setupAndRunTest(true, false, SslClientAuth.NONE, "localhost", DefaultSslEngineFactory.class, pp2NoValidateTrafficHeader, () -> this.checkAuthenticationSucceed(true));
    }

    @Test
    public void testHandshakesWithWithNetworkLinkAlgorithm() throws Exception {
        this.setupAndRunTest(false, true, SslClientAuth.NONE, "client1.us-west-1.aws.confluent.cloud", NettySslEngineFactory.class, pp2NoValidateTrafficHeader, () -> this.testNetworkLinkAlgorithmHandshakes());
    }

    private void testNetworkLinkAlgorithmHandshakes() throws Exception {
        TrafficNetworkIdRoutes routes = new TrafficNetworkIdRoutes(Arrays.asList("n1"), Arrays.asList("us-west-1.aws.confluent.cloud"));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuId, (TrafficNetworkIdRoutes)routes);
        this.checkAuthenticationSucceed(false);
        this.createClient(false, SecurityProtocol.SASL_SSL, pp2NoValidateTrafficHeader);
        routes = new TrafficNetworkIdRoutes(Arrays.asList(new String[0]), Arrays.asList(new String[0]));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuId, (TrafficNetworkIdRoutes)routes);
        this.checkAuthenticationFailed(false);
        this.createClient(false, SecurityProtocol.SASL_SSL, pp2NoValidateTrafficHeader);
        routes = new TrafficNetworkIdRoutes(Arrays.asList("n1", "n2"), Arrays.asList("us-east-1.aws.confluent.cloud", "us-west-1.aws.confluent.cloud"));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuId, (TrafficNetworkIdRoutes)routes);
        this.checkAuthenticationSucceed(false);
        this.createClient(false, SecurityProtocol.SASL_SSL, pp2NoValidateTrafficHeader);
        routes = new TrafficNetworkIdRoutes(Arrays.asList("n1"), Arrays.asList("us-east-1.aws.confluent.cloud"));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuId, (TrafficNetworkIdRoutes)routes);
        this.checkAuthenticationFailed(false);
        this.createClient(false, SecurityProtocol.SASL_SSL, pp2NoValidateTrafficHeader);
        routes = new TrafficNetworkIdRoutes(Arrays.asList("n1"), Arrays.asList(""));
        TrafficNetworkIdRoutesStore.addRoutes((String)this.brokerSessionUuId, (TrafficNetworkIdRoutes)routes);
        this.checkAuthenticationSucceed(false);
    }

    public static Collection<Object[]> allCombinations() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{true, false, SslClientAuth.REQUESTED, DefaultSslEngineFactory.class});
        params.add(new Object[]{true, false, SslClientAuth.NONE, DefaultSslEngineFactory.class});
        params.add(new Object[]{false, false, SslClientAuth.NONE, DefaultSslEngineFactory.class});
        params.add(new Object[]{true, false, SslClientAuth.REQUESTED, NettySslEngineFactory.class});
        params.add(new Object[]{true, false, SslClientAuth.NONE, NettySslEngineFactory.class});
        params.add(new Object[]{false, false, SslClientAuth.NONE, NettySslEngineFactory.class});
        params.add(new Object[]{false, true, SslClientAuth.NONE, DefaultSslEngineFactory.class});
        params.add(new Object[]{false, true, SslClientAuth.NONE, NettySslEngineFactory.class});
        params.add(new Object[]{true, true, SslClientAuth.REQUESTED, DefaultSslEngineFactory.class});
        params.add(new Object[]{true, true, SslClientAuth.REQUESTED, NettySslEngineFactory.class});
        return params;
    }
}

