/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.test.utils;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

public class KafkaTestUtils {
    private static final Set<String> UNEXPECTED_THREADS = Utils.mkSet((Object[])new String[]{"kafka-coordinator-heartbeat-thread", "event-process-thread", "EventThread", "auth-writer-", "auth-reader-", "metadata-service-coordinator", "license-", "authorizer-"});

    public static Properties securityProps(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", bootstrapServers);
        props.setProperty("security.protocol", securityProtocol.name);
        if (securityProtocol.name.equals("SSL") || securityProtocol.name.equals("SASL_SSL")) {
            props.setProperty("ssl.endpoint.identification.algorithm", "");
        }
        if (saslMechanism != null) {
            props.setProperty("sasl.mechanism", saslMechanism);
        }
        if (jaasConfig != null) {
            props.setProperty("sasl.jaas.config", jaasConfig);
        }
        props.setProperty("sasl.kerberos.service.name", "kafka");
        return props;
    }

    public static Properties producerProps(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        Properties props = KafkaTestUtils.securityProps(bootstrapServers, securityProtocol, saslMechanism, jaasConfig);
        props.setProperty("key.serializer", StringSerializer.class.getName());
        props.setProperty("value.serializer", StringSerializer.class.getName());
        return props;
    }

    public static Properties consumerProps(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, String consumerGroup) {
        Properties props = KafkaTestUtils.securityProps(bootstrapServers, securityProtocol, saslMechanism, jaasConfig);
        props.setProperty("group.id", consumerGroup);
        props.setProperty("key.deserializer", StringDeserializer.class.getName());
        props.setProperty("value.deserializer", StringDeserializer.class.getName());
        props.setProperty("enable.auto.commit", "true");
        props.setProperty("auto.commit.interval.ms", "10");
        props.setProperty("auto.offset.reset", "earliest");
        return props;
    }

    public static KafkaProducer<String, String> createProducer(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties properties) {
        Properties producerProps = KafkaTestUtils.producerProps(bootstrapServers, securityProtocol, saslMechanism, jaasConfig);
        producerProps.putAll((Map<?, ?>)properties);
        return new KafkaProducer(producerProps);
    }

    public static KafkaProducer<String, String> createProducer(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        return KafkaTestUtils.createProducer(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, new Properties());
    }

    public static KafkaProducer<String, byte[]> createByteProducer(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        Properties producerProps = KafkaTestUtils.producerProps(bootstrapServers, securityProtocol, saslMechanism, jaasConfig);
        producerProps.setProperty("value.serializer", ByteArraySerializer.class.getName());
        return new KafkaProducer(producerProps);
    }

    public static KafkaConsumer<String, String> createConsumer(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, String consumerGroup, Properties properties) {
        Properties consumerProps = KafkaTestUtils.consumerProps(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, consumerGroup);
        consumerProps.putAll((Map<?, ?>)properties);
        return new KafkaConsumer(consumerProps);
    }

    public static KafkaConsumer<String, String> createConsumer(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, String consumerGroup) {
        return KafkaTestUtils.createConsumer(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, consumerGroup, new Properties());
    }

    public static List<Future<RecordMetadata>> produce(KafkaProducer<String, String> producer, String topic, int first, int count) {
        ArrayList<Future<RecordMetadata>> futures = new ArrayList<Future<RecordMetadata>>(count);
        for (int i = 0; i < count; ++i) {
            int index = first + i;
            ProducerRecord record = new ProducerRecord(topic, (Object)String.valueOf(index), (Object)("value" + index));
            futures.add(producer.send(record));
        }
        return futures;
    }

    public static void sendRecords(KafkaProducer<String, String> producer, String topic, int first, int count) throws Throwable {
        for (Future<RecordMetadata> future : KafkaTestUtils.produce(producer, topic, first, count)) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    public static void consumeRecords(KafkaConsumer<String, String> consumer, String topic, int first, int count) throws Exception {
        consumer.subscribe(Collections.singleton(topic));
        KafkaTestUtils.consumeRecords(consumer, first, count, count);
    }

    public static void consumeRecords(KafkaConsumer<String, String> consumer, int first, int minCount, int maxCount) throws Exception {
        int received = 0;
        long endTimeMs = System.currentTimeMillis() + 30000L;
        while (received < minCount && System.currentTimeMillis() < endTimeMs) {
            ConsumerRecords records = consumer.poll(Duration.ofSeconds(1L));
            received += records.count();
            for (ConsumerRecord record : records) {
                int key = Integer.parseInt((String)record.key());
                Assertions.assertTrue((key >= first && key < first + minCount ? 1 : 0) != 0, (String)("Unexpected record " + key));
            }
        }
        Assertions.assertTrue((received >= minCount ? 1 : 0) != 0, (String)("Some messages not consumed: min=" + minCount + ", received=" + received));
        Assertions.assertTrue((received <= maxCount ? 1 : 0) != 0, (String)("Too many messages consumed: max=" + maxCount + ", received=" + received));
    }

    public static CloudAdmin createCloudAdmin(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        return KafkaTestUtils.createKafkaAdminClient(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, new Properties(), null, null);
    }

    public static AdminClient createAdminClient(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
        return KafkaTestUtils.createAdminClient(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, new Properties());
    }

    public static AdminClient createAdminClient(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties props) {
        return KafkaTestUtils.createKafkaAdminClient(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, props, null, null);
    }

    public static AdminClient createAdminClient(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties props, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        return KafkaTestUtils.createKafkaAdminClient(bootstrapServers, securityProtocol, saslMechanism, jaasConfig, props, requestCallback, proxyProtocolEngineFactory);
    }

    private static KafkaAdminClient createKafkaAdminClient(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties props, RequestCallback requestCallback, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        Properties adminProps = new Properties();
        adminProps.putAll((Map<?, ?>)props);
        adminProps.setProperty("bootstrap.servers", bootstrapServers);
        adminProps.setProperty("security.protocol", securityProtocol.name);
        if (saslMechanism != null) {
            adminProps.setProperty("sasl.mechanism", saslMechanism);
        }
        if (jaasConfig != null) {
            adminProps.setProperty("sasl.jaas.config", jaasConfig);
        }
        adminProps.setProperty("sasl.kerberos.service.name", "kafka");
        return (KafkaAdminClient)ConfluentAdminUtils.createConfluentAdmin((AdminClientConfig)new AdminClientConfig((Map)adminProps), (RequestCallback)requestCallback, (ProxyProtocolEngineFactory)proxyProtocolEngineFactory);
    }

    public static void createTopic(Admin adminClient, String topicName, int partitionCount, int replicationFactor) throws InterruptedException {
        adminClient.createTopics(Collections.singleton(new NewTopic(topicName, partitionCount, (short)replicationFactor)));
        TestUtils.waitForCondition(() -> ((Set)adminClient.listTopics().names().get()).contains(topicName), (long)30000L, (String)("Could not assert that " + topicName + " exists after creation."));
    }

    public static void createTopic(Admin adminClient, String topicName, Map<Integer, List<Integer>> replicasAssignments) throws InterruptedException, ExecutionException {
        adminClient.createTopics(Collections.singleton(new NewTopic(topicName, replicasAssignments))).all().get();
        TestUtils.waitForCondition(() -> ((Set)adminClient.listTopics().names().get()).contains(topicName), (long)30000L, (String)("Could not assert that " + topicName + " exists after creation."));
    }

    public static TopicDescription describeTopic(Admin adminClient, String topicName) throws InterruptedException {
        AtomicReference desc = new AtomicReference();
        TestUtils.waitForCondition(() -> {
            Map descriptions = (Map)adminClient.describeTopics(Collections.singletonList(topicName)).allTopicNames().get();
            if (descriptions.containsKey(topicName)) {
                desc.set(descriptions.get(topicName));
                return true;
            }
            return false;
        }, (long)30000L, (String)("Could not describe " + topicName + " in time."));
        return (TopicDescription)desc.get();
    }

    public static <T> T fieldValue(Object o, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object o, Class<?> clazz, String fieldName, Object value) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canAccess(AdminClient adminClient, String topic) {
        try {
            return ((Map)adminClient.describeTopics(Collections.singleton(topic)).allTopicNames().get()).containsKey(topic);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void verifyProduceConsume(ClientBuilder clientBuilder, String topic, String consumerGroup, boolean authorized) throws Throwable {
        KafkaTestUtils.verifyProduce(clientBuilder, topic, authorized);
        KafkaTestUtils.verifyConsume(clientBuilder, consumerGroup, c -> c.subscribe(Collections.singleton(topic)), authorized);
    }

    public static void verifyProduce(ClientBuilder clientBuilder, String topic, boolean authorized) throws Throwable {
        try (KafkaProducer<String, String> producer = clientBuilder.buildProducer();){
            KafkaTestUtils.sendRecords(producer, topic, 0, 10);
            Assertions.assertTrue((boolean)authorized, (String)"No authorization exception from unauthorized client");
        }
        catch (AuthorizationException e) {
            Assertions.assertFalse((boolean)authorized, (String)"Authorization exception from authorized client");
        }
        catch (KafkaException e) {
            Assertions.assertFalse((boolean)authorized, (String)"Wrapped authorization exception from authorized client");
            Assertions.assertTrue((boolean)(e.getCause() instanceof AuthorizationException));
        }
    }

    public static void verifyConsume(ClientBuilder clientBuilder, String consumerGroup, Consumer<KafkaConsumer<String, String>> subscribeOrAssign, boolean authorized) throws Throwable {
        try (KafkaConsumer<String, String> consumer = clientBuilder.buildConsumer(consumerGroup);){
            subscribeOrAssign.accept(consumer);
            KafkaTestUtils.consumeRecords(consumer, 0, 10, Integer.MAX_VALUE);
            Assertions.assertTrue((boolean)authorized, (String)"No authorization exception from unauthorized client");
        }
        catch (AuthorizationException e) {
            Assertions.assertFalse((boolean)authorized, (String)"Authorization exception from authorized client");
        }
    }

    public static void addProducerAcls(ClientBuilder clientBuilder, KafkaPrincipal principal, String topic, PatternType patternType) throws Exception {
        try (AdminClient adminClient = clientBuilder.buildAdminClient();){
            AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic, patternType), new AccessControlEntry(principal.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW));
            adminClient.createAcls(Arrays.asList(topicAcl)).all().get();
        }
    }

    public static void addProducerAcls(ConfluentAdmin adminClient, KafkaPrincipal principal, String topic, PatternType patternType) throws Exception {
        AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic, patternType), new AccessControlEntry(principal.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW));
        adminClient.createAcls(Arrays.asList(topicAcl)).all().get();
    }

    public static void addConsumerAcls(ClientBuilder clientBuilder, KafkaPrincipal principal, String topic, String consumerGroup, PatternType patternType) throws Exception {
        try (AdminClient adminClient = clientBuilder.buildAdminClient();){
            AclBinding topicAcl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, topic, patternType), new AccessControlEntry(principal.toString(), "*", AclOperation.READ, AclPermissionType.ALLOW));
            AclBinding consumerGroupAcl = new AclBinding(new ResourcePattern(ResourceType.GROUP, consumerGroup, patternType), new AccessControlEntry(principal.toString(), "*", AclOperation.ALL, AclPermissionType.ALLOW));
            List<AclBinding> acls = Arrays.asList(topicAcl, consumerGroupAcl);
            adminClient.createAcls(acls).all().get();
        }
    }

    public static byte[] buildEventMetadataContent(long sequenceId) {
        EventsMetadata.Builder builder = EventsMetadata.newBuilder();
        builder.setSequenceId(sequenceId);
        return builder.build().toByteArray();
    }

    public static RecordHeaders createGoodSequenceIdRecordHeaders(long sequenceId) {
        return KafkaTestUtils.createGoodSequenceIdRecordHeaders(sequenceId, true);
    }

    public static RecordHeaders createGoodSequenceIdRecordHeaders(long sequenceId, boolean eventsHeader) {
        if (sequenceId == 0L || Long.compareUnsigned(Long.MAX_VALUE, sequenceId) <= 0) {
            throw new IllegalArgumentException("Sequence ID must be in the range 0 < seq_id < 2^63");
        }
        return new RecordHeaders(new Header[]{eventsHeader ? new RecordHeader("eventsmetadata", KafkaTestUtils.buildEventMetadataContent(sequenceId)) : new RecordHeader("_sequence_id", Long.toUnsignedString(sequenceId).getBytes(StandardCharsets.UTF_8))});
    }

    public static void verifyThreadCleanup() {
        KafkaTestUtils.verifyThreadCleanup(15000L);
    }

    public static void verifyThreadCleanup(long maxWaitMs) {
        try {
            TestUtils.waitForCondition(KafkaTestUtils::hasNoUnexpectedThreads, (long)maxWaitMs, () -> "Unexpected threads: " + KafkaTestUtils.filterUnexpectedThreads());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasNoUnexpectedThreads() {
        return Thread.getAllStackTraces().keySet().stream().noneMatch(KafkaTestUtils::isUnexpectedThread);
    }

    private static List<Thread> filterUnexpectedThreads() {
        return Thread.getAllStackTraces().keySet().stream().filter(KafkaTestUtils::isUnexpectedThread).collect(Collectors.toList());
    }

    public static ConfluentAuthorizerServerInfo serverInfo(String clusterId, SecurityProtocol ... protocols) {
        return KafkaTestUtils.serverInfo(clusterId, new KafkaHttpServerBinder(), Collections.emptyMap(), protocols);
    }

    public static ConfluentAuthorizerServerInfo serverInfo(String clusterId, Map<String, Object> interBrokerConfigs, SecurityProtocol ... protocols) {
        return KafkaTestUtils.serverInfo(clusterId, new KafkaHttpServerBinder(), interBrokerConfigs, protocols);
    }

    public static ConfluentAuthorizerServerInfo serverInfo(String clusterId, KafkaHttpServerBinder httpServerBinder, SecurityProtocol ... protocols) {
        return KafkaTestUtils.serverInfo(clusterId, httpServerBinder, Collections.emptyMap(), protocols);
    }

    public static ConfluentAuthorizerServerInfo serverInfo(final String clusterId, final KafkaHttpServerBinder httpServerBinder, Map<String, Object> interBrokerConfigs, SecurityProtocol ... protocols) {
        final ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>(protocols.length);
        int port = 9092;
        if (protocols.length != 0) {
            for (SecurityProtocol protocol : protocols) {
                endpoints.add(new Endpoint(protocol.name, protocol, "localhost", port++));
            }
        } else {
            endpoints.add(new Endpoint(SecurityProtocol.PLAINTEXT.name, SecurityProtocol.PLAINTEXT, "localhost", port++));
        }
        final HashMap<String, Object> interBrokerClientConfigs = new HashMap<String, Object>();
        interBrokerClientConfigs.putAll(interBrokerConfigs);
        interBrokerClientConfigs.put("bootstrap.servers", "localhost:" + ((Endpoint)endpoints.get(0)).port());
        return new ConfluentAuthorizerServerInfo(){

            public ClusterResource clusterResource() {
                return new ClusterResource(clusterId);
            }

            public int brokerId() {
                return 0;
            }

            public Collection<Endpoint> endpoints() {
                return endpoints;
            }

            public Endpoint interBrokerEndpoint() {
                return (Endpoint)endpoints.get(0);
            }

            public Collection<String> earlyStartListeners() {
                return Collections.emptyList();
            }

            public KafkaHttpServerBinder httpServerBinder() {
                return httpServerBinder;
            }

            public Metrics metrics() {
                return new Metrics();
            }

            public Map<String, ?> interBrokerClientConfig() {
                return interBrokerClientConfigs;
            }
        };
    }

    private static boolean isUnexpectedThread(Thread thread) {
        return UNEXPECTED_THREADS.stream().anyMatch(thread.getName()::contains);
    }

    public static class ClientBuilder {
        private final String bootstrapServers;
        private final SecurityProtocol securityProtocol;
        private final String saslMechanism;
        private final String jaasConfig;
        private final Properties properties;

        public ClientBuilder(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig) {
            this.bootstrapServers = bootstrapServers;
            this.securityProtocol = securityProtocol;
            this.saslMechanism = saslMechanism;
            this.jaasConfig = jaasConfig;
            this.properties = new Properties();
        }

        public ClientBuilder(String bootstrapServers, SecurityProtocol securityProtocol, String saslMechanism, String jaasConfig, Properties properties) {
            this.bootstrapServers = bootstrapServers;
            this.securityProtocol = securityProtocol;
            this.saslMechanism = saslMechanism;
            this.jaasConfig = jaasConfig;
            this.properties = properties;
        }

        public KafkaProducer<String, String> buildProducer() {
            return KafkaTestUtils.createProducer(this.bootstrapServers, this.securityProtocol, this.saslMechanism, this.jaasConfig, this.properties);
        }

        public KafkaConsumer<String, String> buildConsumer(String consumerGroup) {
            return KafkaTestUtils.createConsumer(this.bootstrapServers, this.securityProtocol, this.saslMechanism, this.jaasConfig, consumerGroup, this.properties);
        }

        public AdminClient buildAdminClient() {
            return KafkaTestUtils.createAdminClient(this.bootstrapServers, this.securityProtocol, this.saslMechanism, this.jaasConfig, this.properties);
        }

        public Properties producerProps() {
            return KafkaTestUtils.producerProps(this.bootstrapServers, this.securityProtocol, this.saslMechanism, this.jaasConfig);
        }
    }
}

