/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.server;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.confluent.security.auth.oauth.mockserver.common.SupportedAlgorithms;
import io.confluent.security.auth.oauth.mockserver.server.CommonHttp;
import io.confluent.security.auth.oauth.mockserver.server.Endpoint;
import io.confluent.security.auth.oauth.mockserver.server.MockOAuthServer;
import io.confluent.security.auth.oauth.mockserver.server.Mode;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServerRequestHandler
implements Handler<HttpServerRequest> {
    private static final Logger log = LoggerFactory.getLogger((String)"oauth");
    private static final int EXPIRES_IN_SECONDS = 600;
    private final MockOAuthServer verticle;

    public AuthServerRequestHandler(MockOAuthServer verticle) {
        this.verticle = verticle;
    }

    public void handle(HttpServerRequest req) {
        log.info("> " + req.method().name() + " " + req.path());
        CommonHttp.setContextLog(log);
        if (!CommonHttp.isOneOf(req.method(), HttpMethod.GET, HttpMethod.POST)) {
            CommonHttp.sendResponse(req, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        String[] path = req.path().split("/");
        if (path.length != 2) {
            CommonHttp.sendResponse(req, HttpResponseStatus.NOT_FOUND);
            return;
        }
        Endpoint endpoint = Endpoint.fromString(path[1]);
        try {
            this.processRequest(endpoint, req);
        }
        catch (Throwable t) {
            CommonHttp.handleFailure(req, t, log);
        }
    }

    private boolean processRequest(Endpoint endpoint, HttpServerRequest req) {
        if (endpoint == Endpoint.JWKS) {
            this.processJwksRequest(req);
        } else if (endpoint == Endpoint.TOKEN) {
            this.processTokenRequest(req);
        } else {
            return false;
        }
        return true;
    }

    private static boolean generateResponse(HttpServerRequest req, Mode mode) {
        boolean result = true;
        switch (mode) {
            case MODE_STALL: {
                break;
            }
            case MODE_400: {
                CommonHttp.sendResponse(req, HttpResponseStatus.BAD_REQUEST);
                break;
            }
            case MODE_401: {
                CommonHttp.sendResponse(req, HttpResponseStatus.UNAUTHORIZED);
                break;
            }
            case MODE_403: {
                CommonHttp.sendResponse(req, HttpResponseStatus.FORBIDDEN);
                break;
            }
            case MODE_404: {
                CommonHttp.sendResponse(req, HttpResponseStatus.NOT_FOUND);
                break;
            }
            case MODE_500: {
                CommonHttp.sendResponse(req, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                break;
            }
            case MODE_503: {
                CommonHttp.sendResponse(req, HttpResponseStatus.SERVICE_UNAVAILABLE);
                break;
            }
            default: {
                result = false;
                log.error("Unexpected mode: " + (Object)((Object)mode));
            }
        }
        if (result) {
            log.info("Returned mode status: " + (Object)((Object)mode));
        }
        return result;
    }

    private void processTokenRequest(HttpServerRequest req) {
        HttpMethod method = req.method();
        if (method != HttpMethod.POST) {
            CommonHttp.sendResponse(req, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        req.setExpectMultipart(true);
        req.endHandler(v -> {
            MultiMap form = req.formAttributes();
            log.info(form.toString());
            String grantType = form.get("grant_type");
            if (grantType == null) {
                CommonHttp.sendResponse(req, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            int expiry = Integer.parseInt(form.get("expiry"));
            String authorization = req.headers().get("Authorization");
            String clientId = this.authorizeClient(authorization);
            try {
                String accessToken = this.createSignedAccessToken(clientId, expiry, form);
                JsonObject result = new JsonObject();
                result.put("access_token", (Object)accessToken);
                result.put("expires_in", (Object)expiry);
                result.put("scope", (Object)"all");
                String jsonString = result.encode();
                CommonHttp.sendResponse(req, HttpResponseStatus.OK, jsonString);
            }
            catch (Throwable t) {
                CommonHttp.handleFailure(req, t, log);
            }
        });
    }

    private String createSignedAccessToken(String clientId, long expiresIn, MultiMap form) throws Exception {
        String issuer = form.get("issuer");
        String algorithm = form.get("algorithm");
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().subject(form.get("subject")).issuer(form.get("issuer")).expirationTime(new Date(System.currentTimeMillis() + expiresIn * 1000L));
        form.remove("issuer").remove("expiry").remove("subject").remove("grant_type").remove("algorithm");
        String value = form.get("clusters");
        value = value.substring(1, value.length() - 1);
        String[] arr = value.split(",");
        ArrayList<String> clustersAllowed = new ArrayList<String>(Arrays.asList(arr));
        builder.claim("clusters", clustersAllowed);
        form.remove("clusters");
        List map = form.entries();
        map.forEach(e -> builder.claim((String)e.getKey(), e.getValue()));
        JWTClaimsSet claimsSet = builder.build();
        RSASSASigner signer = new RSASSASigner(this.verticle.getSigKey(this.getAlgo(algorithm), issuer));
        String jku = (String)this.verticle.getConfig().get((Object)"jwks-url");
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(this.getAlgo(algorithm).getAlgorithm()).keyID(issuer).type(JOSEObjectType.JWT).jwkURL(URI.create(jku)).build(), claimsSet);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT.serialize();
    }

    private String authorizeClient(String authorization) {
        if (authorization == null || !authorization.startsWith("Basic ")) {
            return null;
        }
        String decoded = this.base64decode(authorization.substring(6));
        int pos = decoded.indexOf(":");
        if (pos == -1) {
            return null;
        }
        return decoded.substring(0, pos);
    }

    private void processJwksRequest(HttpServerRequest req) {
        if (req.method() != HttpMethod.GET) {
            CommonHttp.sendResponse(req, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        CommonHttp.sendResponse(req, HttpResponseStatus.OK, this.jwksets());
    }

    private SupportedAlgorithms getAlgo(String algorithm) {
        switch (algorithm) {
            case "RS384": {
                return SupportedAlgorithms.RS384;
            }
            case "RS512": {
                return SupportedAlgorithms.RS512;
            }
        }
        return SupportedAlgorithms.RS256;
    }

    private String jwksets() {
        ArrayList<JWK> list = new ArrayList<JWK>();
        Map<String, JWK> jwks = this.verticle.getKeys();
        for (Map.Entry<String, JWK> jwk : jwks.entrySet()) {
            list.add(jwk.getValue());
        }
        return "{\"keys\":" + list + "}";
    }

    private String base64decode(String value) {
        return new String(Base64.getUrlDecoder().decode(value), StandardCharsets.UTF_8);
    }
}

