/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.mtls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;

public class CaCertificatesUtils {
    private CaCertificatesUtils() {
    }

    public static X509Certificate[] x509CertificatesFromPem(String pem) throws CertificateException, IOException {
        Collection<? extends Certificate> certificates;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));){
            certificates = factory.generateCertificates(inputStream);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static X509Certificate[] x509CertificatesFromPemFile(Path pemFile) throws CertificateException, IOException {
        Collection<? extends Certificate> certificates;
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (InputStream inputStream = Files.newInputStream(pemFile, new OpenOption[0]);){
            certificates = factory.generateCertificates(inputStream);
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    public static boolean isCertificateAuthority(X509Certificate cert) {
        return cert.getBasicConstraints() != -1;
    }

    public static X509CRL x509CrlFromPem(String pem) throws CertificateException, IOException, CRLException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));){
            X509CRL x509CRL = (X509CRL)factory.generateCRL(stream);
            return x509CRL;
        }
    }

    public static String x509CrlToPem(X509CRL crl) throws CRLException {
        String pemCrl = "-----BEGIN X509 CRL-----\n";
        pemCrl = pemCrl + Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(crl.getEncoded()) + "\n";
        pemCrl = pemCrl + "-----END X509 CRL-----\n";
        return pemCrl;
    }

    public static boolean isSelfSigned(Certificate cert) {
        if (cert == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        try {
            cert.verify(cert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Certificate findSigningCert(Certificate signedCert, Collection<Certificate> certificates) {
        if (signedCert == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        if (certificates == null) {
            throw new IllegalArgumentException("certificate collection cannot be null");
        }
        if (CaCertificatesUtils.isSelfSigned(signedCert)) {
            return null;
        }
        for (Certificate certificate : certificates) {
            try {
                signedCert.verify(certificate.getPublicKey());
                return certificate;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static Certificate[] buildCertChain(Certificate[] partialChain, Collection<Certificate> caCertificates) {
        if (partialChain == null || partialChain.length == 0) {
            throw new IllegalArgumentException("partial chain cannot be null or empty");
        }
        if (caCertificates == null) {
            throw new IllegalArgumentException("certificate collection cannot be null");
        }
        int lastValidIndex = 0;
        for (int i = 0; i < partialChain.length - 1; ++i) {
            Certificate currentCert = partialChain[i];
            Certificate nextCert = partialChain[i + 1];
            try {
                currentCert.verify(nextCert.getPublicKey());
                lastValidIndex = i + 1;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        ArrayList<Certificate> completeChain = new ArrayList<Certificate>();
        for (int i = 0; i <= lastValidIndex; ++i) {
            completeChain.add(partialChain[i]);
        }
        HashSet<Certificate> caCerts = new HashSet<Certificate>(caCertificates);
        for (int i = lastValidIndex + 1; i < partialChain.length; ++i) {
            caCerts.add(partialChain[i]);
        }
        while (true) {
            Certificate last = (Certificate)completeChain.get(completeChain.size() - 1);
            caCerts.remove(last);
            Certificate signingCert = CaCertificatesUtils.findSigningCert(last, caCerts);
            if (signingCert == null) break;
            completeChain.add(signingCert);
        }
        return completeChain.toArray(new Certificate[0]);
    }
}

