/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.cache;

import io.confluent.security.auth.store.cache.AccessRuleStore;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.PermissionType;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class ScopeAccessRuleStore
implements AccessRuleStore {
    private static final NavigableMap<ResourcePattern, Set<AccessRule>> NO_RULES = Collections.emptyNavigableMap();
    private final Map<Scope, NavigableMap<ResourcePattern, Set<AccessRule>>> accessRules;

    public ScopeAccessRuleStore(Map<Scope, NavigableMap<ResourcePattern, Set<AccessRule>>> accessRules) {
        this.accessRules = accessRules;
    }

    public ScopeAccessRuleStore() {
        this(new ConcurrentHashMap<Scope, NavigableMap<ResourcePattern, Set<AccessRule>>>());
    }

    @Override
    public Set<Scope> knownScopes() {
        return this.accessRules.keySet();
    }

    @Override
    public NavigableMap<ResourcePattern, Set<AccessRule>> get(Scope scope) {
        return this.accessRules.getOrDefault(scope, NO_RULES);
    }

    @Override
    public void add(Scope scope, KafkaPrincipal principal, Map<ResourcePattern, Set<AccessRule>> rules) {
        NavigableMap scopeRules = this.accessRules.computeIfAbsent(scope, s -> new ConcurrentSkipListMap());
        rules.forEach((r, a) -> scopeRules.computeIfAbsent(r, x -> ConcurrentHashMap.newKeySet()).addAll(a));
    }

    @Override
    public void update(Scope scope, ResourcePattern resourcePattern, Set<AccessRule> newRules) {
        NavigableMap scopeRules = this.accessRules.computeIfAbsent(scope, s -> new ConcurrentSkipListMap());
        scopeRules.computeIfAbsent(resourcePattern, x -> ConcurrentHashMap.newKeySet()).clear();
        ((Set)scopeRules.get(resourcePattern)).addAll(newRules);
    }

    @Override
    public Set<AccessRule> remove(Scope scope, ResourcePattern resourcePattern) {
        NavigableMap<ResourcePattern, Set<AccessRule>> scopeRules = this.accessRules.get(scope);
        Set accessRules = null;
        if (scopeRules != null) {
            accessRules = (Set)scopeRules.remove(resourcePattern);
        }
        return accessRules;
    }

    @Override
    public AuthorizeRule findMatchingRule(Set<KafkaPrincipal> matchingPrincipals, String host, Action action) {
        Scope resourceScope = action.scope();
        ResourcePattern resource = action.resourcePattern();
        AuthorizeRule authorizeRule = new AuthorizeRule();
        for (Scope nextScope = resourceScope; nextScope != null; nextScope = nextScope.parent()) {
            NavigableMap<ResourcePattern, Set<AccessRule>> rules = this.get(nextScope);
            if (rules.isEmpty()) continue;
            String resourceName = resource.name();
            ResourceType resourceType = resource.resourceType();
            if (this.updateAuthorizeRule((Collection)rules.get(resource), matchingPrincipals, host, action, authorizeRule)) {
                return authorizeRule;
            }
            if (this.updateAuthorizeRule((Collection)rules.get(ResourcePattern.all((ResourceType)resourceType)), matchingPrincipals, host, action, authorizeRule)) {
                return authorizeRule;
            }
            if (this.updateAuthorizeRule((Collection)rules.get(ResourcePattern.ALL), matchingPrincipals, host, action, authorizeRule)) {
                return authorizeRule;
            }
            if (this.updateAuthorizeRule((Collection)rules.get(new ResourcePattern(ResourceType.ALL, resourceName, PatternType.LITERAL)), matchingPrincipals, host, action, authorizeRule)) {
                return authorizeRule;
            }
            if (resourceName.isEmpty() || !rules.subMap(new ResourcePattern(resourceType.name(), resourceName, PatternType.PREFIXED), true, new ResourcePattern(resourceType.name(), resourceName.substring(0, 1), PatternType.PREFIXED), true).entrySet().stream().filter(e -> resourceName.startsWith(((ResourcePattern)e.getKey()).name())).anyMatch(e -> this.updateAuthorizeRule((Collection)e.getValue(), matchingPrincipals, host, action, authorizeRule))) continue;
            return authorizeRule;
        }
        return authorizeRule;
    }

    @Override
    public void addMatchingRules(ResourceAuthorizeRules matchingRules, Scope resourceScope, Set<KafkaPrincipal> principals, String host, Operation operation, ResourceType resourceType) {
        for (Scope nextScope = resourceScope; nextScope != null; nextScope = nextScope.parent()) {
            NavigableMap<ResourcePattern, Set<AccessRule>> rules = this.get(nextScope);
            for (Map.Entry entry : rules.entrySet()) {
                ResourcePattern resourcePattern = (ResourcePattern)entry.getKey();
                if (!resourceType.equals((Object)resourcePattern.resourceType())) continue;
                for (AccessRule rule : (Set)entry.getValue()) {
                    if (!rule.matches(principals, host, operation, PermissionType.DENY) && !rule.matches(principals, host, operation, PermissionType.ALLOW)) continue;
                    matchingRules.addRuleIfNotExist(rule);
                }
            }
        }
    }

    @Override
    public long ruleCount() {
        int count = 0;
        for (NavigableMap<ResourcePattern, Set<AccessRule>> entry : this.accessRules.values()) {
            for (Set accessRules : entry.values()) {
                count += accessRules.size();
            }
        }
        return count;
    }

    @Override
    public void removeDeletedAccessRules(Scope scope, KafkaPrincipal principal, Map<ResourcePattern, Set<AccessRule>> keepRules) {
        NavigableMap<ResourcePattern, Set<AccessRule>> scopeRules = this.get(scope);
        if (!scopeRules.isEmpty()) {
            HashMap<ResourcePattern, Set> deletedRules = new HashMap<ResourcePattern, Set>();
            scopeRules.forEach((resource, rules) -> {
                Set principalRules = rules.stream().filter(a -> a.principal().equals((Object)principal)).collect(Collectors.toSet());
                deletedRules.put((ResourcePattern)resource, principalRules);
            });
            keepRules.forEach((r, ruleSet) -> {
                Set rules = (Set)deletedRules.get(r);
                if (rules != null) {
                    rules.removeAll((Collection<?>)ruleSet);
                }
            });
            deletedRules.forEach((resource, rules) -> {
                Set resourceRules = (Set)scopeRules.get(resource);
                if (resourceRules != null) {
                    resourceRules.removeAll((Collection<?>)rules);
                    if (resourceRules.isEmpty()) {
                        scopeRules.remove(resource);
                    }
                }
            });
        }
    }

    private boolean updateAuthorizeRule(Collection<AccessRule> inputRules, Set<KafkaPrincipal> principals, String host, Action action, AuthorizeRule authorizeRule) {
        boolean matchAllow;
        boolean bl = matchAllow = !authorizeRule.allowRule().isPresent();
        if (inputRules != null) {
            if (!inputRules.isEmpty()) {
                authorizeRule.noResourceAcls(false);
            }
            for (AccessRule rule : inputRules) {
                if (rule.matches(principals, host, action.operation(), PermissionType.DENY)) {
                    authorizeRule.addRuleIfNotExist(rule);
                    return true;
                }
                if (!matchAllow || !rule.matches(principals, host, action.operation(), PermissionType.ALLOW)) continue;
                authorizeRule.addRuleIfNotExist(rule);
                matchAllow = false;
            }
        }
        return false;
    }
}

