/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;

public class ConfigurableSslSocketFactory
extends SSLSocketFactory {
    private static SslFactory sslFactory;
    private SSLSocketFactory sslSocketFactory = DefaultSslEngineFactory.castOrThrow((SslEngineFactory)sslFactory.sslEngineFactory()).sslContext().getSocketFactory();

    public static void createSslFactory(Map<String, ?> sslConfigs) {
        sslFactory = new SslFactory(ConnectionMode.CLIENT);
        sslFactory.configure(sslConfigs);
    }

    public static SocketFactory getDefault() {
        return new ConfigurableSslSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.sslSocketFactory.createSocket(socket, host, port, autoClose);
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = this.sslSocketFactory.createSocket();
        socket.setKeepAlive(true);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port);
        socket.setKeepAlive(true);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(host, port, localAddress, localPort);
        socket.setKeepAlive(true);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port);
        socket.setKeepAlive(true);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress remoteAddress, int remotePort) throws IOException {
        Socket socket = this.sslSocketFactory.createSocket(address, port, remoteAddress, remotePort);
        socket.setKeepAlive(true);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, InputStream inputStream, boolean autoClose) throws IOException {
        return this.sslSocketFactory.createSocket(socket, inputStream, autoClose);
    }
}

