/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.coordinator;

import io.confluent.security.store.kafka.KafkaStoreConfig;
import io.confluent.security.store.kafka.clients.Writer;
import io.confluent.security.store.kafka.coordinator.MetadataServiceAssignment;
import io.confluent.security.store.kafka.coordinator.MetadataServiceCoordinator;
import io.confluent.security.store.kafka.coordinator.MetadataServiceRebalanceListener;
import io.confluent.security.store.kafka.coordinator.NodeMetadata;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class MetadataNodeManager
implements MetadataServiceRebalanceListener {
    private static final String COORDINATOR_METRICS_PREFIX = "confluent.metadata.service";
    private static final String JMX_PREFIX = "confluent.metadata.service";
    private final Logger log;
    private final Time time;
    private final CompletableFuture<Void> startFuture;
    private final NodeMetadata nodeMetadata;
    private final Writer writer;
    private final Metrics metrics;
    private final String clientId;
    private final ConsumerNetworkClient coordinatorNetworkClient;
    private final MetadataServiceCoordinator coordinator;
    private final AtomicBoolean isAlive;
    private final ConcurrentLinkedQueue<Runnable> pendingTasks;
    private final Thread managerThread;
    private final long retryBackoffMs;
    private volatile NodeMetadata masterWriterNode;
    private volatile int masterWriterGenerationId;
    private volatile Collection<NodeMetadata> activeNodes;

    public MetadataNodeManager(Collection<URL> nodeUrls, KafkaStoreConfig config, Writer metadataWriter, Time time) {
        this.nodeMetadata = new NodeMetadata(nodeUrls);
        this.writer = metadataWriter;
        this.time = time;
        this.pendingTasks = new ConcurrentLinkedQueue();
        this.startFuture = new CompletableFuture();
        ConsumerConfig coordinatorConfig = new ConsumerConfig(config.coordinatorConfigs());
        long rebalanceTimeoutMs = coordinatorConfig.getInt("max.poll.interval.ms").intValue();
        if (rebalanceTimeoutMs < config.refreshTimeout.toMillis()) {
            throw new ConfigException(String.format("Metadata service coordinator rebalance timeout %d should be higher than refresh timeout %d", rebalanceTimeoutMs, config.refreshTimeout.toMillis()));
        }
        this.retryBackoffMs = coordinatorConfig.getLong("retry.backoff.ms");
        this.clientId = coordinatorConfig.getString("client.id");
        this.metrics = this.createMetrics(this.clientId, coordinatorConfig, time);
        String logPrefix = String.format("[%s clientId=%s, groupId=%s]", MetadataNodeManager.class.getName(), this.clientId, coordinatorConfig.getString("group.id"));
        LogContext logContext = new LogContext(logPrefix);
        this.log = logContext.logger(MetadataNodeManager.class);
        Metadata metadata = new Metadata(coordinatorConfig.getLong("retry.backoff.ms").longValue(), coordinatorConfig.getLong("retry.backoff.max.ms").longValue(), coordinatorConfig.getLong("metadata.max.age.ms").longValue(), logContext, new ClusterResourceListeners());
        List addresses = ClientUtils.parseAndValidateAddresses((List)coordinatorConfig.getList("bootstrap.servers"), (String)coordinatorConfig.getString("client.dns.lookup"));
        metadata.bootstrap(addresses);
        KafkaClient networkClient = this.createKafkaClient(coordinatorConfig, metadata, time, logContext);
        this.coordinatorNetworkClient = new ConsumerNetworkClient(logContext, networkClient, metadata, time, coordinatorConfig.getLong("retry.backoff.ms").longValue(), coordinatorConfig.getInt("request.timeout.ms").intValue(), Integer.MAX_VALUE);
        this.coordinator = new MetadataServiceCoordinator(logContext, this.coordinatorNetworkClient, this.nodeMetadata, coordinatorConfig, this.metrics, "confluent.metadata.service", time, this);
        this.managerThread = new MetadataNodeManagerThread();
        this.isAlive = new AtomicBoolean(true);
        this.activeNodes = Collections.emptySet();
    }

    public CompletionStage<Void> start() {
        this.managerThread.start();
        return this.startFuture;
    }

    public synchronized boolean isMasterWriter() {
        if (!this.isAlive.get()) {
            return false;
        }
        return this.nodeMetadata.equals(this.masterWriterNode);
    }

    public synchronized URL masterWriterUrl(String protocol) {
        if (!this.isAlive.get()) {
            return null;
        }
        return this.masterWriterNode == null ? null : this.masterWriterNode.url(protocol);
    }

    public synchronized Collection<URL> activeNodeUrls(String protocol) {
        if (!this.isAlive.get()) {
            return Collections.emptySet();
        }
        return this.activeNodes.stream().map(n -> n.url(protocol)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public synchronized void onAssigned(MetadataServiceAssignment assignment, int generationId) {
        this.log.info("Metadata writer assignment complete: generation {} assignment {}", (Object)assignment, (Object)generationId);
        this.pendingTasks.add(() -> {
            this.activeNodes = assignment.nodes().values();
            this.stopWriter(null);
            NodeMetadata newWriter = assignment.writerNodeMetadata();
            if (assignment.error() != MetadataServiceAssignment.AssignmentError.NONE.errorCode) {
                this.log.error("Metadata assignment failed with error code {}", (Object)assignment.error());
                if (assignment.error() == MetadataServiceAssignment.AssignmentError.DUPLICATE_URLS.errorCode) {
                    for (URI uri : this.nodeMetadata.uris()) {
                        if (assignment.nodes().values().stream().filter(m -> m.uris().contains(uri)).count() <= 1L) continue;
                        String errorMessage = String.format("Metadata service url %s is used by multiple brokers: %s", uri, assignment.nodes());
                        if (this.startFuture.completeExceptionally((Throwable)new InvalidConfigurationException(errorMessage))) {
                            this.log.error("{} Broker start up will be terminated.", (Object)errorMessage);
                        } else {
                            this.log.error("{} Broker must be restarted with unique metadata service URLs.", (Object)errorMessage);
                        }
                        break;
                    }
                }
            } else if (assignment.error() == MetadataServiceAssignment.AssignmentError.NONE.errorCode && newWriter != null) {
                if (this.nodeMetadata.equals(newWriter)) {
                    this.writer.startWriter(generationId);
                } else {
                    this.log.info("Not starting writer from node {} since new writer is {} with generation {}", new Object[]{this.nodeMetadata, newWriter, generationId});
                }
                this.startFuture.complete(null);
                this.masterWriterNode = newWriter;
                this.masterWriterGenerationId = generationId;
            }
        });
        this.coordinator.wakeup();
    }

    @Override
    public synchronized void onRevoked(int generationId) {
        this.log.info("Metadata writer assignment revoked for generation {}", (Object)generationId);
        this.pendingTasks.add(() -> this.stopWriter(generationId));
        this.coordinator.wakeup();
    }

    @Override
    public synchronized void onWriterResigned(int generationId) {
        this.log.info("Metadata writer resigned, generation {}", (Object)generationId);
        this.pendingTasks.add(() -> this.maybeResign(generationId));
        this.coordinator.wakeup();
    }

    protected void onWriterResigned() {
        this.coordinator.onWriterResigned();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Duration closeTimeout) {
        this.log.debug("Closing Metadata Service node manager");
        this.startFuture.complete(null);
        MetadataNodeManager metadataNodeManager = this;
        synchronized (metadataNodeManager) {
            this.isAlive.set(false);
            this.masterWriterNode = null;
        }
        this.coordinatorNetworkClient.wakeup();
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        try {
            this.managerThread.join(closeTimeout.toMillis());
        }
        catch (Throwable e) {
            firstException.set(e);
        }
        try {
            this.coordinator.close(this.time.timer(closeTimeout.toMillis()));
        }
        catch (Throwable e) {
            firstException.compareAndSet(null, e);
        }
        Utils.closeQuietly((AutoCloseable)this.coordinatorNetworkClient, (String)"coordinatorNetworkClient", firstException);
        Utils.closeQuietly((AutoCloseable)this.metrics, (String)"metrics", firstException);
        AppInfoParser.unregisterAppInfo((String)"confluent.metadata.service", (String)this.clientId, (Metrics)this.metrics);
        Throwable exception = firstException.getAndSet(null);
        if (exception != null) {
            throw new KafkaException("Failed to close Metadata Service node manager", exception);
        }
    }

    protected KafkaClient createKafkaClient(ConsumerConfig coordinatorConfig, Metadata metadata, Time time, LogContext logContext) {
        Selector selector = new Selector(coordinatorConfig.getLong("connections.max.idle.ms").longValue(), this.metrics, time, "confluent.metadata.service", ClientUtils.createChannelBuilder((AbstractConfig)coordinatorConfig, (Time)time, (LogContext)logContext), logContext);
        return new NetworkClient((Selectable)selector, metadata, this.clientId, 100, coordinatorConfig.getLong("reconnect.backoff.ms").longValue(), coordinatorConfig.getLong("reconnect.backoff.max.ms").longValue(), coordinatorConfig.getInt("send.buffer.bytes").intValue(), coordinatorConfig.getInt("receive.buffer.bytes").intValue(), coordinatorConfig.getInt("request.timeout.ms").intValue(), coordinatorConfig.getLong("socket.connection.setup.timeout.ms").longValue(), coordinatorConfig.getLong("socket.connection.setup.timeout.max.ms").longValue(), time, true, new ApiVersions(), logContext, MetadataRecoveryStrategy.forName((String)coordinatorConfig.getString("metadata.recovery.strategy")));
    }

    private Metrics createMetrics(String clientId, ConsumerConfig coordinatorConfig, Time time) {
        LinkedHashMap<String, String> metricsTags = new LinkedHashMap<String, String>();
        metricsTags.put("client-id", clientId);
        long sampleWindowMs = coordinatorConfig.getLong("metrics.sample.window.ms");
        MetricConfig metricConfig = new MetricConfig().samples(coordinatorConfig.getInt("metrics.num.samples").intValue()).timeWindow(sampleWindowMs, TimeUnit.MILLISECONDS).tags(metricsTags);
        List reporters = coordinatorConfig.getConfiguredInstances("metric.reporters", MetricsReporter.class);
        reporters.add(new JmxReporter());
        KafkaMetricsContext metricsContext = new KafkaMetricsContext("confluent.metadata.service");
        Metrics metrics = new Metrics(metricConfig, reporters, time, (MetricsContext)metricsContext);
        AppInfoParser.registerAppInfo((String)"confluent.metadata.service", (String)clientId, (Metrics)metrics, (long)time.milliseconds());
        return metrics;
    }

    private void stopWriter(Integer stoppingGenerationId) {
        if (this.nodeMetadata.equals(this.masterWriterNode)) {
            this.writer.stopWriter(stoppingGenerationId);
        }
        this.masterWriterNode = null;
        this.masterWriterGenerationId = -1;
    }

    private void maybeResign(int generationId) {
        if (this.nodeMetadata.equals(this.masterWriterNode) && this.masterWriterGenerationId == generationId) {
            this.log.info("Writer with generation id {} resigning", (Object)generationId);
            this.stopWriter(generationId);
            Utils.sleep((long)this.retryBackoffMs);
            this.onWriterResigned();
        }
    }

    private class MetadataNodeManagerThread
    extends Thread {
        MetadataNodeManagerThread() {
            this.setName("metadata-service-coordinator");
        }

        @Override
        public void run() {
            block10: {
                try {
                    MetadataNodeManager.this.log.debug("Starting metadata node coordinator");
                    while (MetadataNodeManager.this.isAlive.get()) {
                        while (true) {
                            try {
                                Runnable runnable;
                                while ((runnable = (Runnable)MetadataNodeManager.this.pendingTasks.poll()) != null) {
                                    runnable.run();
                                }
                            }
                            catch (Throwable e) {
                                if (!MetadataNodeManager.this.isAlive.get()) continue;
                                MetadataNodeManager.this.log.error("Metadata service node manager task failed", e);
                                MetadataNodeManager.this.maybeResign(MetadataNodeManager.this.masterWriterGenerationId);
                                continue;
                            }
                            break;
                        }
                        try {
                            MetadataNodeManager.this.coordinator.poll(Duration.ofMillis(Long.MAX_VALUE));
                        }
                        catch (WakeupException e) {
                            MetadataNodeManager.this.log.debug("Wake up exception from poll");
                        }
                        catch (Exception e) {
                            if (!MetadataNodeManager.this.isAlive.get()) continue;
                            MetadataNodeManager.this.log.error("Metadata service coordinator encountered exception during poll", (Throwable)e);
                            MetadataNodeManager.this.maybeResign(MetadataNodeManager.this.masterWriterGenerationId);
                        }
                    }
                }
                catch (Throwable e) {
                    if (!MetadataNodeManager.this.isAlive.get()) break block10;
                    MetadataNodeManager.this.log.error("Metadata service node manager thread failed", e);
                    MetadataNodeManager.this.maybeResign(MetadataNodeManager.this.masterWriterGenerationId);
                }
            }
        }
    }
}

