/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.utils.JsonMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NodeMetadata
implements Comparable<NodeMetadata> {
    private static final List<String> PROTOCOLS = Arrays.asList("https", "http");
    private final Map<String, URL> urls;
    private final Set<URI> uris;

    @JsonCreator
    public NodeMetadata(@JsonProperty(value="urls") Collection<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("Node urls not specified");
        }
        this.urls = urls.stream().collect(Collectors.toMap(URL::getProtocol, Function.identity()));
        this.uris = urls.stream().map(url -> {
            try {
                return url.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid node URL " + url);
            }
        }).collect(Collectors.toSet());
    }

    @JsonProperty
    public Collection<URL> urls() {
        return this.urls.values();
    }

    public URL url(String protocol) {
        return this.urls.get(protocol);
    }

    public Collection<URI> uris() {
        return this.uris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeMetadata)) {
            return false;
        }
        NodeMetadata that = (NodeMetadata)o;
        return Objects.equals(this.uris, that.uris);
    }

    public int hashCode() {
        return Objects.hash(this.urls);
    }

    @Override
    public int compareTo(NodeMetadata o) {
        for (String protocol2 : PROTOCOLS) {
            int result = this.compareUrls(this.urls.get(protocol2), o.urls.get(protocol2));
            if (result == 0) continue;
            return result;
        }
        Set unknownProtocols = this.urls.keySet().stream().filter(protocol -> !PROTOCOLS.contains(protocol)).collect(Collectors.toSet());
        for (String protocol3 : unknownProtocols) {
            int result = this.compareUrls(this.urls.get(protocol3), o.urls.get(protocol3));
            if (result == 0) continue;
            return result;
        }
        return this.urls.keySet().equals(o.urls.keySet()) ? 0 : 1;
    }

    private int compareUrls(URL url, URL otherUrl) {
        int result = 0;
        result = otherUrl == null ? (url != null ? -1 : 0) : (url == null ? 1 : url.toString().compareTo(otherUrl.toString()));
        return result;
    }

    public String toString() {
        return "NodeMetadata(urls=" + this.urls + ')';
    }

    public ByteBuffer serialize() {
        return JsonMapper.toByteBuffer((Object)this);
    }

    public static NodeMetadata deserialize(ByteBuffer buffer) {
        return (NodeMetadata)JsonMapper.fromByteBuffer((ByteBuffer)buffer, NodeMetadata.class);
    }
}

