/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.projectnessie.cel.checker.Types;

public final class Mapping {
    private final Map<String, Type> mapping;
    private final Map<Type, String> typeKeys;

    private Mapping(Map<String, Type> srcMapping, Map<Type, String> srcTypeKeys) {
        this.mapping = new HashMap<String, Type>(srcMapping.size() * 4 / 3 + 1);
        this.mapping.putAll(srcMapping);
        this.typeKeys = new HashMap<Type, String>(srcTypeKeys.size() * 4 / 3 + 1);
        this.typeKeys.putAll(srcTypeKeys);
    }

    static Mapping newMapping() {
        return new Mapping(Collections.emptyMap(), Collections.emptyMap());
    }

    private String keyForType(Type t) {
        return this.typeKeys.computeIfAbsent(t, Types::typeKey);
    }

    void add(Type from, Type to) {
        this.mapping.put(this.keyForType(from), to);
    }

    Type find(Type from) {
        return this.mapping.get(this.keyForType(from));
    }

    Mapping copy() {
        return new Mapping(this.mapping, this.typeKeys);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{");
        this.mapping.forEach((k, v) -> result.append((String)k).append(" => ").append(v));
        result.append("}");
        return result.toString();
    }
}

