/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.tls.crypto.impl.jcajce.Primes;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SubjectPublicKeyInfoChecker {
    private static final Cache validatedQs = new Cache();

    SubjectPublicKeyInfoChecker() {
    }

    public static void checkInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)aSN1ObjectIdentifier)) {
            X962Parameters x962Parameters = X962Parameters.getInstance((Object)subjectPublicKeyInfo.getAlgorithm().getParameters());
            if (x962Parameters.isImplicitlyCA() || x962Parameters.isNamedCurve()) {
                return;
            }
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)x962Parameters.getParameters());
            X9FieldID x9FieldID = X9FieldID.getInstance((Object)aSN1Sequence.getObjectAt(1));
            if (x9FieldID.getIdentifier().equals((Object)X9FieldID.prime_field)) {
                BigInteger bigInteger = ASN1Integer.getInstance((Object)x9FieldID.getParameters()).getValue();
                if (validatedQs.contains(bigInteger)) {
                    return;
                }
                int n = SubjectPublicKeyInfoChecker.asInteger("org.bouncycastle.ec.fp_max_size", 1042);
                int n2 = SubjectPublicKeyInfoChecker.asInteger("org.bouncycastle.ec.fp_certainty", 100);
                int n3 = bigInteger.bitLength();
                if (n < n3) {
                    throw new IllegalArgumentException("Fp q value out of range");
                }
                if (Primes.hasAnySmallFactors(bigInteger) || !Primes.isMRProbablePrime(bigInteger, CryptoServicesRegistrar.getSecureRandom(), SubjectPublicKeyInfoChecker.getNumberOfIterations(n3, n2))) {
                    throw new IllegalArgumentException("Fp q value not prime");
                }
                validatedQs.add(bigInteger);
            }
        } else if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)aSN1ObjectIdentifier) || X509ObjectIdentifiers.id_ea_rsa.equals((Object)aSN1ObjectIdentifier) || PKCSObjectIdentifiers.id_RSAES_OAEP.equals((Object)aSN1ObjectIdentifier) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)aSN1ObjectIdentifier)) {
            RSAPublicKey rSAPublicKey;
            try {
                rSAPublicKey = RSAPublicKey.getInstance((Object)subjectPublicKeyInfo.parsePublicKey());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to parse RSA key");
            }
            if ((rSAPublicKey.getPublicExponent().intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA publicExponent is even");
            }
            SubjectPublicKeyInfoChecker.validate(rSAPublicKey.getModulus());
        }
    }

    private static void validate(BigInteger bigInteger) {
        int n;
        if ((bigInteger.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA modulus is even");
        }
        int n2 = SubjectPublicKeyInfoChecker.asInteger("org.bouncycastle.rsa.max_size", 15360);
        if (n2 < (n = bigInteger.bitLength())) {
            throw new IllegalArgumentException("modulus value out of range");
        }
    }

    private static int getNumberOfIterations(int n, int n2) {
        if (n >= 1536) {
            return n2 <= 100 ? 3 : (n2 <= 128 ? 4 : 4 + (n2 - 128 + 1) / 2);
        }
        if (n >= 1024) {
            return n2 <= 100 ? 4 : (n2 <= 112 ? 5 : 5 + (n2 - 112 + 1) / 2);
        }
        if (n >= 512) {
            return n2 <= 80 ? 5 : (n2 <= 100 ? 7 : 7 + (n2 - 100 + 1) / 2);
        }
        return n2 <= 80 ? 40 : 40 + (n2 - 80 + 1) / 2;
    }

    static int asInteger(String string, int n) {
        String string2 = SubjectPublicKeyInfoChecker.getPropertyValue(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    static String getPropertyValue(final String string) {
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(string);
            }
        });
        if (string2 != null) {
            return string2;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Cache {
        private final Map<BigInteger, Boolean> values = new WeakHashMap<BigInteger, Boolean>();
        private final BigInteger[] preserve = new BigInteger[8];
        private int preserveCounter = 0;

        private Cache() {
        }

        public synchronized void add(BigInteger bigInteger) {
            this.values.put(bigInteger, Boolean.TRUE);
            this.preserve[this.preserveCounter] = bigInteger;
            this.preserveCounter = (this.preserveCounter + 1) % this.preserve.length;
        }

        public synchronized boolean contains(BigInteger bigInteger) {
            return this.values.containsKey(bigInteger);
        }

        public synchronized int size() {
            return this.values.size();
        }

        public synchronized void clear() {
            this.values.clear();
            for (int i = 0; i != this.preserve.length; ++i) {
                this.preserve[i] = null;
            }
        }
    }
}

