/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9FieldID;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.tls.crypto.impl.jcajce.Primes;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SubjectPublicKeyInfoChecker {
    private static final Cache validatedQs = new Cache();

    SubjectPublicKeyInfoChecker() {
    }

    public static void checkInfo(SubjectPublicKeyInfo pubInfo) {
        ASN1ObjectIdentifier algorithm = pubInfo.getAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)algorithm)) {
            X962Parameters params = X962Parameters.getInstance((Object)pubInfo.getAlgorithm().getParameters());
            if (params.isImplicitlyCA() || params.isNamedCurve()) {
                return;
            }
            ASN1Sequence ecParameters = ASN1Sequence.getInstance((Object)params.getParameters());
            X9FieldID fieldID = X9FieldID.getInstance((Object)ecParameters.getObjectAt(1));
            if (fieldID.getIdentifier().equals((Object)X9FieldID.prime_field)) {
                BigInteger q = ASN1Integer.getInstance((Object)fieldID.getParameters()).getValue();
                if (validatedQs.contains(q)) {
                    return;
                }
                int maxBitLength = SubjectPublicKeyInfoChecker.asInteger("org.bouncycastle.ec.fp_max_size", 1042);
                int certainty = SubjectPublicKeyInfoChecker.asInteger("org.bouncycastle.ec.fp_certainty", 100);
                int qBitLength = q.bitLength();
                if (maxBitLength < qBitLength) {
                    throw new IllegalArgumentException("Fp q value out of range");
                }
                if (Primes.hasAnySmallFactors(q) || !Primes.isMRProbablePrime(q, CryptoServicesRegistrar.getSecureRandom(), SubjectPublicKeyInfoChecker.getNumberOfIterations(qBitLength, certainty))) {
                    throw new IllegalArgumentException("Fp q value not prime");
                }
                validatedQs.add(q);
            }
        } else if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)algorithm) || X509ObjectIdentifiers.id_ea_rsa.equals((Object)algorithm) || PKCSObjectIdentifiers.id_RSAES_OAEP.equals((Object)algorithm) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)algorithm)) {
            RSAPublicKey params;
            try {
                params = RSAPublicKey.getInstance((Object)pubInfo.parsePublicKey());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to parse RSA key");
            }
            if ((params.getPublicExponent().intValue() & 1) == 0) {
                throw new IllegalArgumentException("RSA publicExponent is even");
            }
            SubjectPublicKeyInfoChecker.validate(params.getModulus());
        }
    }

    private static void validate(BigInteger modulus) {
        int modBitLength;
        if ((modulus.intValue() & 1) == 0) {
            throw new IllegalArgumentException("RSA modulus is even");
        }
        int maxBitLength = SubjectPublicKeyInfoChecker.asInteger("org.bouncycastle.rsa.max_size", 15360);
        if (maxBitLength < (modBitLength = modulus.bitLength())) {
            throw new IllegalArgumentException("modulus value out of range");
        }
    }

    private static int getNumberOfIterations(int bits, int certainty) {
        if (bits >= 1536) {
            return certainty <= 100 ? 3 : (certainty <= 128 ? 4 : 4 + (certainty - 128 + 1) / 2);
        }
        if (bits >= 1024) {
            return certainty <= 100 ? 4 : (certainty <= 112 ? 5 : 5 + (certainty - 112 + 1) / 2);
        }
        if (bits >= 512) {
            return certainty <= 80 ? 5 : (certainty <= 100 ? 7 : 7 + (certainty - 100 + 1) / 2);
        }
        return certainty <= 80 ? 40 : 40 + (certainty - 80 + 1) / 2;
    }

    static int asInteger(String propertyName, int defaultValue) {
        String p = SubjectPublicKeyInfoChecker.getPropertyValue(propertyName);
        if (p != null) {
            return Integer.parseInt(p);
        }
        return defaultValue;
    }

    static String getPropertyValue(final String propertyName) {
        String val = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty(propertyName);
            }
        });
        if (val != null) {
            return val;
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        });
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Cache {
        private final Map<BigInteger, Boolean> values = new WeakHashMap<BigInteger, Boolean>();
        private final BigInteger[] preserve = new BigInteger[8];
        private int preserveCounter = 0;

        private Cache() {
        }

        public synchronized void add(BigInteger value) {
            this.values.put(value, Boolean.TRUE);
            this.preserve[this.preserveCounter] = value;
            this.preserveCounter = (this.preserveCounter + 1) % this.preserve.length;
        }

        public synchronized boolean contains(BigInteger value) {
            return this.values.containsKey(value);
        }

        public synchronized int size() {
            return this.values.size();
        }

        public synchronized void clear() {
            this.values.clear();
            for (int i = 0; i != this.preserve.length; ++i) {
                this.preserve[i] = null;
            }
        }
    }
}

