/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Max;

public class KafkaLogicalClusterMetadataLoaderMetrics {
    private static final String LKC_LOAD_METRICS_GROUP_NAME = "confluent-lkc-load-metrics";
    private static final String LKC_METADATA_STARTUP_LOAD_TIME_SENSOR_NAME = "lkc-metadata-startup-load-time";
    private static final String LKC_METADATA_STARTUP_LOAD_TIME_METRIC_NAME = "lkc-metadata-startup-load-time-max";
    private final Sensor logicalClusterMetadataStartupSensor;

    public KafkaLogicalClusterMetadataLoaderMetrics(Metrics metrics) {
        this.logicalClusterMetadataStartupSensor = metrics.sensor(LKC_METADATA_STARTUP_LOAD_TIME_SENSOR_NAME);
        this.logicalClusterMetadataStartupSensor.add(metrics.metricName(LKC_METADATA_STARTUP_LOAD_TIME_METRIC_NAME, LKC_LOAD_METRICS_GROUP_NAME, "The time it took for the first load of all logical cluster metadata from the topic in ms"), (MeasurableStat)new Max());
    }

    public void recordStartupLoadTime(long startupLoadTimeMs) {
        this.logicalClusterMetadataStartupSensor.record((double)startupLoadTimeMs);
    }
}

