/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.utils.PartitionMetricUtils;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorCreator;

public abstract class AbstractPartitionSensorCreator
extends AbstractSensorCreator {
    protected final String tenant;
    protected final TopicPartition tp;

    public AbstractPartitionSensorCreator(String name, String descriptiveName, String tenant, TopicPartition tp) {
        super(name, descriptiveName);
        this.tenant = tenant;
        this.tp = tp;
    }

    protected Map<String, String> metricTags() {
        return PartitionMetricUtils.tenantPartitionMetricTags(this.tenant, this.tp);
    }

    protected String sensorName(String baseName) {
        return String.format("%s:%s-%s:%s-%s,%s-%s", baseName, "tenant", this.tenant, "topic", this.tp.topic(), "partition", this.tp.partition());
    }

    public Sensor createSensor(Metrics metrics, String sensorName, long expirySeconds) {
        Sensor sensor = super.createSensor(metrics, sensorName, expirySeconds);
        this.registerMetrics(metrics, sensor);
        return sensor;
    }

    protected abstract void registerMetrics(Metrics var1, Sensor var2);
}

