/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.kafka.server.plugins.auth.BaseMultiTenantSaslSecretsStore;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyAuthenticator;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.PlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.PlainSaslCredentials;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdAuthenticator;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;

public class TopicBasedPlainSaslAuthenticator
extends PlainSaslAuthenticator {
    private final BaseMultiTenantSaslSecretsStore secretsLoader;
    protected final String brokerSessionUuid;
    protected TrafficNetworkIdValidationMode networkIdValidationMode;
    protected DefaultDataPolicyValidationMode defaultDataPolicyValidationMode;
    protected final CCloudTrafficType trafficType;
    private final List<String> defaultDataPolicyDenyOrgIds;

    public TopicBasedPlainSaslAuthenticator(Map<String, ?> props) {
        this(BaseMultiTenantSaslSecretsStore.getInstance((String)AuthUtils.getBrokerSessionUuid(props)), AuthUtils.getBrokerSessionUuid(props), (CCloudTrafficType)props.get("__confluent_ccloud_traffic_type"), (List)props.get("confluent.cluster.link.intranet.connectivity.denied.org.ids"));
    }

    public TopicBasedPlainSaslAuthenticator(BaseMultiTenantSaslSecretsStore secretsLoader, String brokerSessionUuid, CCloudTrafficType trafficType, List<String> defaultDataPolicyDenyOrgIds) {
        super(SUCCESSFUL_AUTH_CACHE, FAILED_AUTH_CACHE);
        this.secretsLoader = secretsLoader;
        this.brokerSessionUuid = brokerSessionUuid;
        this.trafficType = trafficType;
        this.defaultDataPolicyDenyOrgIds = defaultDataPolicyDenyOrgIds;
    }

    @Override
    public void initialize(List<AppConfigurationEntry> jaasContextEntries) {
        this.mode = SniValidationMode.fromString(TopicBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "sni_host_name_validation_mode", TopicBasedLoginModule.class.getName()));
        this.networkIdValidationMode = TrafficNetworkIdValidationMode.fromConfigs(this.trafficType, () -> TopicBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "traffic_network_id_validation_mode", TopicBasedLoginModule.class.getName()));
        this.defaultDataPolicyValidationMode = DefaultDataPolicyValidationMode.fromConfigs(() -> TopicBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "default_data_policy_validation_mode", TopicBasedLoginModule.class.getName()));
        this.log.debug("TopicBasedPlainSaslAuthenticator initialized with mode: {}, networkIdValidationMode:{}, defaultDataPolicyValidationMode:{}", new Object[]{this.mode.getText(), this.networkIdValidationMode.name(), this.defaultDataPolicyValidationMode.name()});
    }

    boolean verifyNetworkId(MultiTenantSaslConfigEntry userInfo, String username, Optional<String> networkId) {
        TrafficNetworkIdRoutes networkIdRoutes = TrafficNetworkIdRoutesStore.getRoutes((String)this.brokerSessionUuid);
        TrafficNetworkIdAuthenticator networkIdAuthenticator = new TrafficNetworkIdAuthenticator(networkIdRoutes, this.networkIdValidationMode, errorMessage -> this.throwAuthException(userInfo, username, errorMessage + " for user name: " + username));
        return networkIdAuthenticator.authenticate(networkId, userInfo.logicalClusterId);
    }

    boolean verifyDefaultDataPolicy(MultiTenantSaslConfigEntry userInfo, String username, DefaultDataPolicyContext policyContext) {
        LogicalClusterMetadata lkcMetadata;
        if (this.defaultDataPolicyValidationMode == DefaultDataPolicyValidationMode.NONE) {
            return true;
        }
        BasePhysicalClusterMetadata clusterMetadata = BasePhysicalClusterMetadata.getInstance((String)this.brokerSessionUuid);
        if (clusterMetadata == null) {
            this.throwAuthException(userInfo, username, "cluster metadata not found for user name: " + username);
        }
        if ((lkcMetadata = clusterMetadata.metadata(userInfo.logicalClusterId)) == null) {
            this.throwAuthException(userInfo, username, "logical cluster metadata not found for user name: " + username);
        }
        boolean isOrgDenied = this.defaultDataPolicyDenyOrgIds != null && this.defaultDataPolicyDenyOrgIds.contains(lkcMetadata.organizationId());
        DefaultDataPolicyAuthenticator defaultDataPolicyAuthenticator = new DefaultDataPolicyAuthenticator(this.defaultDataPolicyValidationMode, isOrgDenied, lkcMetadata, errorMessage -> this.throwAuthException(userInfo, username, errorMessage + " for user name: " + username));
        return defaultDataPolicyAuthenticator.authenticate(policyContext);
    }

    @Override
    protected void pluginAuthenticate(MultiTenantSaslConfigEntry userInfo, PlainSaslCredentials credentials) {
        this.verifyNetworkId(userInfo, credentials.username, credentials.networkId);
        this.verifyDefaultDataPolicy(userInfo, credentials.username, new DefaultDataPolicyContext.Builder(credentials.organizationId, credentials.networkType, credentials.hasSslPeerCertificate).build());
    }

    @Override
    protected MultiTenantSaslSecrets loadSecrets() {
        return this.secretsLoader.load();
    }
}

