/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.auditlog.remote.AuditProducerConfig;
import java.util.Map;
import java.util.Objects;

public class RemoteAuditConfiguration {
    private static final String SCHEMA_VERSION = "1.0";
    private final String activeRegion;
    private final Map<String, AuditProducerConfig> regionProducerConfig;

    @JsonCreator
    public RemoteAuditConfiguration(@JsonProperty(value="activeRegion") String activeRegion, @JsonProperty(value="regionProducerConfig") Map<String, AuditProducerConfig> regionProducerConfig) {
        this.activeRegion = Objects.requireNonNull(activeRegion, "activeRegion can't be null");
        this.regionProducerConfig = regionProducerConfig;
    }

    @JsonIgnore
    public static String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public String getActiveRegion() {
        return this.activeRegion;
    }

    public AuditProducerConfig getAuditProducerConfig(String region) {
        return this.regionProducerConfig.get(region);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteAuditConfiguration)) {
            return false;
        }
        RemoteAuditConfiguration that = (RemoteAuditConfiguration)o;
        return Objects.equals(this.activeRegion, that.activeRegion) && Objects.equals(this.regionProducerConfig, that.regionProducerConfig);
    }

    public int hashCode() {
        return Objects.hash(this.activeRegion, this.regionProducerConfig);
    }
}

