/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.checksums.internal.Crc32Checksum;
import software.amazon.awssdk.checksums.internal.Crc64NvmeChecksum;
import software.amazon.awssdk.checksums.internal.CrcChecksumProvider;
import software.amazon.awssdk.checksums.internal.Md5Checksum;
import software.amazon.awssdk.checksums.internal.Sha1Checksum;
import software.amazon.awssdk.checksums.internal.Sha256Checksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;

@SdkProtectedApi
public interface SdkChecksum
extends Checksum {
    public static SdkChecksum forAlgorithm(ChecksumAlgorithm algorithm) {
        switch (algorithm.algorithmId()) {
            case "CRC32C": {
                return CrcChecksumProvider.crc32cImplementation();
            }
            case "CRC32": {
                return new Crc32Checksum();
            }
            case "SHA1": {
                return new Sha1Checksum();
            }
            case "SHA256": {
                return new Sha256Checksum();
            }
            case "MD5": {
                return new Md5Checksum();
            }
            case "CRC64NVME": {
                return new Crc64NvmeChecksum();
            }
        }
        throw new UnsupportedOperationException("Unsupported checksum algorithm: " + algorithm);
    }

    public byte[] getChecksumBytes();

    public void mark(int var1);

    @Override
    default public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    default public void update(ByteBuffer buffer) {
        int pos = buffer.position();
        int limit = buffer.limit();
        int rem = limit - pos;
        if (rem <= 0) {
            return;
        }
        if (buffer.hasArray()) {
            this.update(buffer.array(), pos + buffer.arrayOffset(), rem);
        } else {
            byte[] b = new byte[Math.min(buffer.remaining(), 4096)];
            while (buffer.hasRemaining()) {
                int length = Math.min(buffer.remaining(), b.length);
                buffer.get(b, 0, length);
                this.update(b, 0, length);
            }
        }
        buffer.position(limit);
    }
}

