/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rest.resources;

import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryStoreException;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.storage.KafkaSchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/contexts")
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class ContextsResource {
    public static final String apiTag = "Contexts (v1)";
    private final KafkaSchemaRegistry schemaRegistry;

    public ContextsResource(KafkaSchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    @GET
    @DocumentedName(value="getAllContexts")
    @Operation(summary="List contexts", description="Retrieves a list of contexts.", responses={@ApiResponse(responseCode="200", description="The contexts.", content={@Content(array=@ArraySchema(schema=@Schema(example=".")))}), @ApiResponse(responseCode="500", description="Internal Server Error. Error code 50001 indicates a failure in the backend data store. ", content={@Content(schema=@Schema(implementation=ErrorMessage.class))})})
    @Tags(value={@Tag(name="Contexts (v1)")})
    @PerformanceMetric(value="contexts.list")
    public List<String> listContexts() {
        try {
            return this.schemaRegistry.listContexts();
        }
        catch (SchemaRegistryStoreException e) {
            throw Errors.storeException("Error while listing contexts", e);
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException("Error while listing contexts", e);
        }
    }
}

