/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.common.Platform;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.apache.kafka.trogdor.workload.ConsumeBenchWorker;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.MetadataRequestWorkloadSpec;
import org.apache.kafka.trogdor.workload.Throttle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataRequestBenchWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(MetadataRequestBenchWorker.class);
    private static final int THROTTLE_PERIOD_MS = 100;
    private static final Time TIME = Time.SYSTEM;
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private final String id;
    private final MetadataRequestWorkloadSpec spec;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Future<?> statusUpdaterFuture;
    private ExecutorService workerExecutor;
    private ScheduledExecutorService statusUpdaterExecutor;
    private WorkerStatusTracker status;
    private KafkaFutureImpl<String> doneFuture;
    private long totalCalls;
    private long startTimeMs;
    private Histogram latencyHistogram;

    public MetadataRequestBenchWorker(String id, MetadataRequestWorkloadSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> doneFuture) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("MetadataRequestWorkloadSpec is already running.");
        }
        MetadataRequestBenchWorker metadataRequestBenchWorker = this;
        synchronized (metadataRequestBenchWorker) {
            this.totalCalls = 0L;
            this.latencyHistogram = new Histogram(10000);
            this.startTimeMs = TIME.milliseconds();
        }
        log.info("{}: Activating MetadataRequestWorkloadSpec.", (Object)this.id);
        try {
            this.status = status;
            this.doneFuture = doneFuture;
            this.validateConfigs();
            this.workerExecutor = Executors.newFixedThreadPool(this.spec.noOfThreads(), ThreadUtils.createThreadFactory((String)"MetadataRequestBenchWorker%d", (boolean)false));
            for (int i = 0; i < this.spec.noOfThreads(); ++i) {
                this.workerExecutor.submit(new Worker());
            }
            this.statusUpdaterExecutor = Executors.newScheduledThreadPool(1, ThreadUtils.createThreadFactory((String)"StatusUpdaterWorkerThread%d", (boolean)false));
            this.statusUpdaterFuture = this.statusUpdaterExecutor.scheduleAtFixedRate(new StatusUpdater(), 30L, 10L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            WorkerUtils.abort(log, "MetadataRequestBenchWorker", e, doneFuture);
        }
    }

    private void validateConfigs() {
        if (this.spec.targetOperationsPerSec() <= 0) {
            throw new ConfigException("Can't have targetOperationsPerSec <= 0.");
        }
    }

    private int runAclOperations(AdminClient adminClient, long index) throws ExecutionException, InterruptedException {
        ListTopicsOptions options = new ListTopicsOptions();
        options.listInternal(false);
        long startTimeMs = Time.SYSTEM.milliseconds();
        ListTopicsResult topicsList = adminClient.listTopics(options);
        topicsList.namesToListings().get();
        this.latencyHistogram.add(Time.SYSTEM.milliseconds() - startTimeMs);
        return 1;
    }

    private AdminClient createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.spec.bootstrapServers());
        WorkerUtils.addConfigsToProperties(props, this.spec.commonClientConf(), this.spec.commonClientConf());
        return AdminClient.create((Properties)props);
    }

    @Override
    public void stop(Platform platform) throws Exception {
        if (!this.running.compareAndSet(true, false)) {
            throw new IllegalStateException("MetadataRequestBenchWorker is not running.");
        }
        log.info("{}: Deactivating MetadataRequestBenchWorker.", (Object)this.id);
        this.doneFuture.complete((Object)"");
        this.statusUpdaterFuture.cancel(false);
        this.statusUpdaterExecutor.shutdown();
        this.statusUpdaterExecutor.awaitTermination(1L, TimeUnit.DAYS);
        this.statusUpdaterExecutor = null;
        this.workerExecutor.shutdownNow();
        this.workerExecutor.awaitTermination(1L, TimeUnit.DAYS);
        new StatusUpdater().run();
        this.workerExecutor = null;
        this.doneFuture = null;
        long lastTimeMs = Time.SYSTEM.milliseconds();
        double callsPerSec = (double)this.totalCalls * 1000.0 / (double)(lastTimeMs - this.startTimeMs);
        log.info("Achieved CallsPerSec : {}, minSupportedOpsPerSec : {}", (Object)callsPerSec, (Object)this.spec.minSupportedOpsPerSec());
        if (callsPerSec < (double)this.spec.minSupportedOpsPerSec()) {
            throw new RuntimeException("Minimum supported operations/sec is " + this.spec.minSupportedOpsPerSec() + " , but got " + callsPerSec);
        }
        log.info("{}: Deactivated MetadataRequestBenchWorker.", (Object)this.id);
    }

    public static class StatusData {
        private final double callsPerSec;
        private final double totalCalls;
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p95LatencyMs;
        private final int p99LatencyMs;

        @JsonCreator
        StatusData(@JsonProperty(value="totalCalls") double totalCalls, @JsonProperty(value="callsPerSec") double callsPerSec, @JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs) {
            this.callsPerSec = callsPerSec;
            this.totalCalls = totalCalls;
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p95LatencyMs = p95latencyMs;
            this.p99LatencyMs = p99latencyMs;
        }

        @JsonProperty
        public double callsPerSec() {
            return this.callsPerSec;
        }

        @JsonProperty
        public double totalCalls() {
            return this.totalCalls;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p95LatencyMs() {
            return this.p95LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }

    private class StatusUpdater
    implements Runnable {
        private StatusUpdater() {
        }

        @Override
        public void run() {
            try {
                long lastTimeMs = Time.SYSTEM.milliseconds();
                Histogram.Summary latSummary = MetadataRequestBenchWorker.this.latencyHistogram.summarize(ConsumeBenchWorker.StatusData.PERCENTILES);
                JsonNode node = JsonUtil.JSON_SERDE.valueToTree((Object)new StatusData(MetadataRequestBenchWorker.this.totalCalls, (double)MetadataRequestBenchWorker.this.totalCalls * 1000.0 / (double)(lastTimeMs - MetadataRequestBenchWorker.this.startTimeMs), latSummary.average(), latSummary.percentiles().get(0).value(), latSummary.percentiles().get(1).value(), latSummary.percentiles().get(2).value()));
                MetadataRequestBenchWorker.this.status.update(node);
            }
            catch (Exception e) {
                WorkerUtils.abort(log, "StatusUpdater", e, (KafkaFutureImpl<String>)MetadataRequestBenchWorker.this.doneFuture);
            }
        }
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int perPeriod = WorkerUtils.perSecToPerPeriod((float)MetadataRequestBenchWorker.this.spec.targetOperationsPerSec() / (float)MetadataRequestBenchWorker.this.spec.noOfThreads(), 100L);
            Throttle throttle = new Throttle(perPeriod, 100);
            AdminClient adminClient = null;
            try {
                adminClient = MetadataRequestBenchWorker.this.createAdminClient();
                while (!MetadataRequestBenchWorker.this.doneFuture.isDone()) {
                    throttle.increment();
                    int noOfOps = MetadataRequestBenchWorker.this.runAclOperations(adminClient, COUNTER.incrementAndGet());
                    MetadataRequestBenchWorker metadataRequestBenchWorker = MetadataRequestBenchWorker.this;
                    synchronized (metadataRequestBenchWorker) {
                        MetadataRequestBenchWorker.this.totalCalls = MetadataRequestBenchWorker.this.totalCalls + (long)noOfOps;
                    }
                }
                return;
            }
            catch (Throwable e) {
                Utils.closeQuietly((AutoCloseable)adminClient, (String)"AdminClient");
                WorkerUtils.abort(log, "MetadataRequestBenchWorker#Worker", e, (KafkaFutureImpl<String>)MetadataRequestBenchWorker.this.doneFuture);
            }
        }
    }
}

