/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.MetadataRequestBenchWorker;

public class MetadataRequestWorkloadSpec
extends TaskSpec {
    private final String clientNode;
    private final String bootstrapServers;
    private final int noOfThreads;
    private final int targetOperationsPerSec;
    private final int minSupportedOpsPerSec;
    private final Map<String, String> commonClientConf;

    @JsonCreator
    public MetadataRequestWorkloadSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="targetOperationsPerSec") int targetOperationsPerSec, @JsonProperty(value="minSupportedOpsPerSec") int minSupportedOpsPerSec, @JsonProperty(value="noOfThreads") int noOfThreads, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.targetOperationsPerSec = targetOperationsPerSec;
        this.minSupportedOpsPerSec = minSupportedOpsPerSec;
        this.noOfThreads = noOfThreads;
        this.commonClientConf = this.configOrEmptyMap(commonClientConf);
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public int targetOperationsPerSec() {
        return this.targetOperationsPerSec;
    }

    @JsonProperty
    public int minSupportedOpsPerSec() {
        return this.minSupportedOpsPerSec;
    }

    @JsonProperty
    public int noOfThreads() {
        return this.noOfThreads;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Collections.singleton(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new MetadataRequestBenchWorker(id, this);
    }
}

