/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.TransactionBenchWorker;

public class TransactionBenchWorkerMetrics
implements AutoCloseable {
    public static final String GROUP = "trogdor-transaction-bench-worker-metrics";
    private static final String TXN_E2E = "txn-e2e";
    private final Map<String, String> tags;
    private final Metrics metrics;
    private final Histogram histogram;
    private final MetricName transactionE2eLatencyAvg;
    private final MetricName transactionCount;
    private final MetricName transactionE2eLatency50;
    private final MetricName transactionE2eLatency90;
    private final MetricName transactionE2eLatency99;

    public TransactionBenchWorkerMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.tags = this.metrics.config().tags();
        this.histogram = new Histogram(100000);
        this.transactionE2eLatencyAvg = this.metricName("txn-e2e-latency-ms-Avg", "Total avg time for transactions from end to end has spent in milliseconds.");
        this.transactionCount = this.metricName("txn-e2e-count", "Total number of transactions.");
        this.transactionE2eLatency50 = this.metricName("txn-e2e-latency-ms-50percentile", "50 percentile time for transactions from end to end has spent in milliseconds.");
        this.transactionE2eLatency90 = this.metricName("txn-e2e-latency-ms-90percentile", "90 percentile time for transactions from end to end has spent in milliseconds.");
        this.transactionE2eLatency99 = this.metricName("txn-e2e-latency-ms-99percentile", "99 percentile time for transactions from end to end has spent in milliseconds.");
        metrics.addMetric(this.transactionE2eLatencyAvg, (MetricValueProvider)new Gauge<Double>(){

            public Double value(MetricConfig config, long now) {
                return TransactionBenchWorkerMetrics.this.histogramSummary().average();
            }
        });
        metrics.addMetric(this.transactionCount, (MetricValueProvider)new Gauge<Long>(){

            public Long value(MetricConfig config, long now) {
                return TransactionBenchWorkerMetrics.this.histogramSummary().numSamples();
            }
        });
        metrics.addMetric(this.transactionE2eLatency50, (MetricValueProvider)new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return TransactionBenchWorkerMetrics.this.histogramSummary().percentiles().get(0).value();
            }
        });
        metrics.addMetric(this.transactionE2eLatency90, (MetricValueProvider)new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return TransactionBenchWorkerMetrics.this.histogramSummary().percentiles().get(1).value();
            }
        });
        metrics.addMetric(this.transactionE2eLatency99, (MetricValueProvider)new Gauge<Integer>(){

            public Integer value(MetricConfig config, long now) {
                return TransactionBenchWorkerMetrics.this.histogramSummary().percentiles().get(2).value();
            }
        });
    }

    public synchronized void recordTxnE2eLatency(long duration) {
        this.histogram.add(duration);
    }

    @Override
    public void close() {
        this.metrics.removeMetric(this.transactionE2eLatencyAvg);
        this.metrics.removeMetric(this.transactionCount);
        this.metrics.removeMetric(this.transactionE2eLatency50);
        this.metrics.removeMetric(this.transactionE2eLatency90);
        this.metrics.removeMetric(this.transactionE2eLatency99);
    }

    private MetricName metricName(String name, String description) {
        return this.metrics.metricName(name, GROUP, description, this.tags);
    }

    private synchronized Histogram.Summary histogramSummary() {
        return this.histogram.summarize(TransactionBenchWorker.StatusData.PERCENTILES);
    }
}

